/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import com.blackgear.cavesandcliffs.common.world.gen.chunk.StructureWeightType;
import com.blackgear.cavesandcliffs.core.registries.api.util.HeightLimitReader;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Iterator;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.feature.jigsaw.JigsawJunction;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.StrongholdPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public class Beardifier {
    public static final Beardifier INSTANCE = new Beardifier();
    private static final float[] STRUCTURE_WEIGHT_TABLE = (float[])Util.func_200696_a((Object)new float[13824], array -> {
        for (int x = 0; x < 24; ++x) {
            for (int y = 0; y < 24; ++y) {
                for (int z = 0; z < 24; ++z) {
                    array[x * 24 * 24 + y * 24 + z] = (float)Beardifier.calculateStructureWeight(y - 12, z - 12, x - 12);
                }
            }
        }
    });
    private final ObjectList<StructurePiece> pieces;
    private final ObjectList<JigsawJunction> junctions;
    private final ObjectListIterator<StructurePiece> pieceIterator;
    private final ObjectListIterator<JigsawJunction> junctionIterator;

    public Beardifier(StructureManager manager, IChunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int i = chunkPos.field_77276_a;
        int j = chunkPos.field_77275_b;
        this.junctions = new ObjectArrayList(32);
        this.pieces = new ObjectArrayList(10);
        for (Structure structure : Structure.field_236384_t_) {
            manager.func_235011_a_(SectionPos.func_218156_a((ChunkPos)chunkPos, (int)HeightLimitReader.getBottomSectionCoord()), structure).forEach(start -> {
                Iterator var5 = start.func_186161_c().iterator();
                block0: while (var5.hasNext()) {
                    StructurePiece structurePiece = (StructurePiece)var5.next();
                    if (!structurePiece.func_214810_a(chunkPos, 12)) continue;
                    if (structurePiece instanceof AbstractVillagePiece) {
                        AbstractVillagePiece poolStructurePiece = (AbstractVillagePiece)structurePiece;
                        JigsawPattern.PlacementBehaviour projection = poolStructurePiece.func_214826_b().func_214854_c();
                        if (projection == JigsawPattern.PlacementBehaviour.RIGID) {
                            this.pieces.add((Object)poolStructurePiece);
                        }
                        Iterator iterator = poolStructurePiece.func_214829_e().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block0;
                            JigsawJunction jigsawJunction = (JigsawJunction)iterator.next();
                            int k = jigsawJunction.func_214895_a();
                            int l = jigsawJunction.func_214893_c();
                            if (k <= i - 12 || l <= j - 12 || k >= i + 15 + 12 || l >= j + 15 + 12) continue;
                            this.junctions.add((Object)jigsawJunction);
                        }
                    }
                    this.pieces.add((Object)structurePiece);
                }
                return;
            });
        }
        this.pieceIterator = this.pieces.iterator();
        this.junctionIterator = this.junctions.iterator();
    }

    private Beardifier() {
        this.junctions = new ObjectArrayList();
        this.pieces = new ObjectArrayList();
        this.pieceIterator = this.pieces.iterator();
        this.junctionIterator = this.junctions.iterator();
    }

    public double getWeight(int x, int y, int z) {
        int j;
        int i;
        double d = 0.0;
        while (this.pieceIterator.hasNext()) {
            StructurePiece structurePiece = (StructurePiece)this.pieceIterator.next();
            MutableBoundingBox blockBox = structurePiece.func_74874_b();
            i = Math.max(0, Math.max(blockBox.field_78897_a - x, x - blockBox.field_78893_d));
            j = y - (blockBox.field_78895_b + (structurePiece instanceof AbstractVillagePiece ? ((AbstractVillagePiece)structurePiece).func_214830_d() : 0));
            int k = Math.max(0, Math.max(blockBox.field_78896_c - z, z - blockBox.field_78892_f));
            StructureWeightType structureWeightType = this.getWeightType(structurePiece);
            if (structureWeightType == StructureWeightType.BURY) {
                d += Beardifier.getMagnitudeWeight(i, j, k);
                continue;
            }
            if (structureWeightType != StructureWeightType.BEARD) continue;
            d += Beardifier.getStructureWeight(i, j, k) * 0.8;
        }
        this.pieceIterator.back(this.pieces.size());
        while (this.junctionIterator.hasNext()) {
            JigsawJunction jigsawJunction = (JigsawJunction)this.junctionIterator.next();
            int l = x - jigsawJunction.func_214895_a();
            i = y - jigsawJunction.func_214896_b();
            j = z - jigsawJunction.func_214893_c();
            d += Beardifier.getStructureWeight(l, i, j) * 0.4;
        }
        this.junctionIterator.back(this.junctions.size());
        return d;
    }

    private static double getMagnitudeWeight(int x, int y, int z) {
        double d = MathUtils.magnitude(x, (double)y / 2.0, z);
        return MathUtils.clampedLerpFromProgress(d, 0.0, 6.0, 1.0, 0.0);
    }

    private static double getStructureWeight(int x, int y, int z) {
        int i = x + 12;
        int j = y + 12;
        int k = z + 12;
        if (i >= 0 && i < 24) {
            if (j >= 0 && j < 24) {
                return k >= 0 && k < 24 ? (double)STRUCTURE_WEIGHT_TABLE[k * 24 * 24 + i * 24 + j] : 0.0;
            }
            return 0.0;
        }
        return 0.0;
    }

    private static double calculateStructureWeight(int x, int y, int z) {
        double d = x * x + z * z;
        double e = (double)y + 0.5;
        double f = e * e;
        double g = Math.pow(Math.E, -(f / 16.0 + d / 16.0));
        double h = -e * MathHelper.func_181161_i((double)(f / 2.0 + d / 2.0)) / 2.0;
        return h * g;
    }

    private StructureWeightType getWeightType(StructurePiece structurePiece) {
        if (structurePiece instanceof StrongholdPieces.Stronghold) {
            return StructureWeightType.BURY;
        }
        return StructureWeightType.BEARD;
    }
}

