/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import com.blackgear.cavesandcliffs.common.world.gen.chunk.BaseStoneSource;
import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.SeedRandomUtils;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;

public class DeepslateStoneSource
implements BaseStoneSource {
    private final SharedSeedRandom random;
    private final long seed;
    private final BlockState defaultBlock;
    private final BlockState deepslateState;

    public DeepslateStoneSource(long seed, BlockState defaultBlock, BlockState deepslateState) {
        this.random = new SharedSeedRandom(seed);
        this.seed = seed;
        this.defaultBlock = defaultBlock;
        this.deepslateState = deepslateState;
    }

    @Override
    public BlockState sample(int x, int y, int z) {
        if (!((Boolean)CavesAndCliffsConfig.generateDeepslateLayer.get()).booleanValue()) {
            return this.defaultBlock;
        }
        if (y < (Integer)CavesAndCliffsConfig.maxDeepslateHeight.get() - 2) {
            return this.deepslateState;
        }
        if (y > (Integer)CavesAndCliffsConfig.maxDeepslateHeight.get()) {
            return this.defaultBlock;
        }
        double chance = MathUtils.lerpFromProgress(y, -8.0, 0.0, 1.0, 0.0);
        SeedRandomUtils.setDeepslateSeed(this.random, this.seed, x, y, z);
        return (double)this.random.nextFloat() < chance ? this.deepslateState : this.defaultBlock;
    }
}

