/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import java.util.stream.IntStream;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.ImprovedNoiseGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;

public class InterpolatedNoiseGenerator {
    private OctavesNoiseGenerator lowerInterpolatedNoise;
    private OctavesNoiseGenerator upperInterpolatedNoise;
    private OctavesNoiseGenerator interpolationNoise;

    public InterpolatedNoiseGenerator(OctavesNoiseGenerator lowerInterpolatedNoise, OctavesNoiseGenerator upperInterpolatedNoise, OctavesNoiseGenerator interpolationNoise) {
        this.lowerInterpolatedNoise = lowerInterpolatedNoise;
        this.upperInterpolatedNoise = upperInterpolatedNoise;
        this.interpolationNoise = interpolationNoise;
    }

    public InterpolatedNoiseGenerator(SharedSeedRandom random) {
        this(new OctavesNoiseGenerator(random, IntStream.rangeClosed(-15, 0)), new OctavesNoiseGenerator(random, IntStream.rangeClosed(-15, 0)), new OctavesNoiseGenerator(random, IntStream.rangeClosed(-7, 0)));
    }

    public double sample(int x, int y, int z, double horizontalScale, double verticalScale, double horizontalStretch, double verticalStretch) {
        double lower = 0.0;
        double upper = 0.0;
        double interpolation = 0.0;
        double yMax = 1.0;
        for (int index = 0; index < 16; ++index) {
            ImprovedNoiseGenerator interpolationNoise;
            ImprovedNoiseGenerator upperNoise;
            double xIn = OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalScale * yMax));
            double yIn = OctavesNoiseGenerator.func_215461_a((double)((double)y * verticalScale * yMax));
            double zIn = OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalScale * yMax));
            double yScale = verticalScale * yMax;
            ImprovedNoiseGenerator lowerNoise = this.lowerInterpolatedNoise.func_215463_a(index);
            if (lowerNoise != null) {
                lower += lowerNoise.func_215456_a(xIn, yIn, zIn, yScale, (double)y * yScale) / yMax;
            }
            if ((upperNoise = this.upperInterpolatedNoise.func_215463_a(index)) != null) {
                upper += upperNoise.func_215456_a(xIn, yIn, zIn, yScale, (double)y * yScale) / yMax;
            }
            if (index < 8 && (interpolationNoise = this.interpolationNoise.func_215463_a(index)) != null) {
                interpolation += interpolationNoise.func_215456_a(OctavesNoiseGenerator.func_215461_a((double)((double)x * horizontalStretch * yMax)), OctavesNoiseGenerator.func_215461_a((double)((double)y * verticalStretch * yMax)), OctavesNoiseGenerator.func_215461_a((double)((double)z * horizontalStretch * yMax)), verticalStretch * yMax, (double)y * verticalStretch * yMax) / yMax;
            }
            yMax /= 2.0;
        }
        return MathHelper.func_151238_b((double)(lower / 512.0), (double)(upper / 512.0), (double)((interpolation / 10.0 + 1.0) / 2.0));
    }
}

