/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import com.blackgear.cavesandcliffs.common.world.biome.provider.BiomeCoords;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.AquiferSampler;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.BaseStoneSource;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.Beardifier;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.DeepslateStoneSource;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.InterpolatedNoiseGenerator;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.NoiseCaveSampler;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.NoiseColumnSampler;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.NoiseInterpolator;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.NoodleCavifier;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.OreVeinifier;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.VerticalBlockSample;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.WeightSampler;
import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.api.util.HeightLimitReader;
import com.blackgear.cavesandcliffs.core.registries.other.utils.NoiseGenUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.SeedRandomUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.MaxMinNoiseMixer;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.world.StructureSpawnManager;

public class NoiseBasedChunkGenerator
extends ChunkGenerator {
    public static final Codec<NoiseBasedChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeProvider.field_235202_a_.fieldOf("biome_source").forGetter(generator -> generator.field_222542_c), (App)Codec.LONG.fieldOf("seed").stable().forGetter(generator -> generator.seed), (App)DimensionSettings.field_236098_b_.fieldOf("settings").forGetter(generator -> generator.field_222543_d)).apply((Applicative)instance, instance.stable(NoiseBasedChunkGenerator::new)));
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private static final BlockState[] EMPTY = new BlockState[0];
    private final int verticalNoiseGranularity;
    private final int horizontalNoiseGranularity;
    private final int noiseSizeX;
    private final int noiseSizeY;
    private final int noiseSizeZ;
    private final INoiseGenerator surfaceDepthNoise;
    private final MaxMinNoiseMixer edgeDensityNoise;
    private final MaxMinNoiseMixer waterLevelNoise;
    private final MaxMinNoiseMixer lavaNoise;
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    private final long seed;
    protected final Supplier<DimensionSettings> field_222543_d;
    private final int worldHeight;
    private final NoiseColumnSampler noiseColumnSampler;
    private final BaseStoneSource deepslateSource;
    private final OreVeinifier oreVeinifier;
    private final NoodleCavifier noodleCavifier;

    public NoiseBasedChunkGenerator(BiomeProvider biomeProvider, long seed, Supplier<DimensionSettings> settings) {
        this(biomeProvider, biomeProvider, seed, settings);
    }

    private NoiseBasedChunkGenerator(BiomeProvider populationSource, BiomeProvider biomeProvider, long seed, Supplier<DimensionSettings> settings) {
        super(populationSource, biomeProvider, settings.get().func_236108_a_(), seed);
        SimplexNoiseGenerator simplexNoiseGenerator;
        this.seed = seed;
        DimensionSettings dimensionSettings = settings.get();
        this.field_222543_d = settings;
        NoiseSettings noiseSettings = dimensionSettings.func_236113_b_();
        this.worldHeight = HeightLimitReader.getHeight();
        this.verticalNoiseGranularity = BiomeCoords.toBlock(noiseSettings.func_236175_f_());
        this.horizontalNoiseGranularity = BiomeCoords.toBlock(noiseSettings.func_236174_e_());
        this.defaultBlock = dimensionSettings.func_236115_c_();
        this.defaultFluid = dimensionSettings.func_236116_d_();
        this.noiseSizeX = 16 / this.horizontalNoiseGranularity;
        this.noiseSizeY = HeightLimitReader.getHeight() / this.verticalNoiseGranularity;
        this.noiseSizeZ = 16 / this.horizontalNoiseGranularity;
        SharedSeedRandom sharedSeed = new SharedSeedRandom(seed);
        InterpolatedNoiseGenerator interpolatedNoiseGenerator = new InterpolatedNoiseGenerator(sharedSeed);
        this.surfaceDepthNoise = noiseSettings.func_236178_i_() ? new PerlinNoiseGenerator(sharedSeed, IntStream.rangeClosed(-3, 0)) : new OctavesNoiseGenerator(sharedSeed, IntStream.rangeClosed(-3, 0));
        sharedSeed.func_202423_a(2620);
        OctavesNoiseGenerator octavesNoiseGenerator = new OctavesNoiseGenerator(sharedSeed, IntStream.rangeClosed(-15, 0));
        if (noiseSettings.func_236180_k_()) {
            SharedSeedRandom seedRandom = new SharedSeedRandom(seed);
            seedRandom.func_202423_a(17292);
            simplexNoiseGenerator = new SimplexNoiseGenerator((Random)seedRandom);
        } else {
            simplexNoiseGenerator = null;
        }
        this.edgeDensityNoise = NoiseGenUtils.create(new SharedSeedRandom(sharedSeed.nextLong()), -3, 1.0);
        this.waterLevelNoise = NoiseGenUtils.create(new SharedSeedRandom(sharedSeed.nextLong()), -3, 1.0, 0.0, 2.0);
        this.lavaNoise = NoiseGenUtils.create(new SharedSeedRandom(sharedSeed.nextLong()), -1, 1.0, 0.0);
        WeightSampler noiseModifier = (Boolean)CavesAndCliffsConfig.generateNoiseCaves.get() != false ? new NoiseCaveSampler(sharedSeed, HeightLimitReader.getBottomY() / this.verticalNoiseGranularity) : WeightSampler.DEFAULT;
        this.noiseColumnSampler = new NoiseColumnSampler(populationSource, this.horizontalNoiseGranularity, this.verticalNoiseGranularity, this.noiseSizeY, noiseSettings, interpolatedNoiseGenerator, simplexNoiseGenerator, octavesNoiseGenerator, noiseModifier);
        this.deepslateSource = new DeepslateStoneSource(seed, this.defaultBlock, ((Block)CCBBlocks.DEEPSLATE.get()).func_176223_P());
        this.oreVeinifier = new OreVeinifier(seed, this.defaultBlock, this.horizontalNoiseGranularity, this.verticalNoiseGranularity, HeightLimitReader.getBottomY());
        this.noodleCavifier = new NoodleCavifier(seed);
    }

    private boolean hasAquifers() {
        return (Boolean)CavesAndCliffsConfig.generateAquifers.get();
    }

    protected Codec<? extends ChunkGenerator> func_230347_a_() {
        return CODEC;
    }

    public ChunkGenerator func_230349_a_(long seed) {
        return new NoiseBasedChunkGenerator(this.field_222542_c.func_230320_a_(seed), seed, this.field_222543_d);
    }

    private double[] sampleNoiseColumn(int x, int z, int minY, int noiseSizeY) {
        double[] noise = new double[noiseSizeY + 1];
        this.sampleNoiseColumn(noise, x, z, minY, noiseSizeY);
        return noise;
    }

    private void sampleNoiseColumn(double[] noise, int x, int z, int minY, int noiseSizeY) {
        NoiseSettings settings = this.field_222543_d.get().func_236113_b_();
        this.noiseColumnSampler.sampleNoiseColumn(noise, x, z, settings, this.func_230356_f_(), minY, noiseSizeY);
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        int i = HeightLimitReader.getBottomY();
        int j = Math.min(HeightLimitReader.getBottomY() + HeightLimitReader.getTopY(), HeightLimitReader.getTopY());
        int k = MathHelper.func_76137_a((int)i, (int)this.verticalNoiseGranularity);
        int l = MathHelper.func_76137_a((int)(j - i), (int)this.verticalNoiseGranularity);
        return l <= 0 ? HeightLimitReader.getBottomY() : this.sampleHeightmap(x, z, null, heightmapType.func_222684_d(), k, l).orElse(HeightLimitReader.getBottomY());
    }

    public IBlockReader func_230348_a_(int x, int z) {
        int i = HeightLimitReader.getBottomY();
        int j = Math.min(HeightLimitReader.getBottomY() + HeightLimitReader.getTopY(), HeightLimitReader.getTopY());
        int k = MathHelper.func_76137_a((int)i, (int)this.verticalNoiseGranularity);
        int l = MathHelper.func_76137_a((int)(j - i), (int)this.verticalNoiseGranularity);
        if (l <= 0) {
            return new VerticalBlockSample(i, EMPTY);
        }
        BlockState[] states = new BlockState[l * this.verticalNoiseGranularity];
        this.sampleHeightmap(x, z, states, null, k, l);
        return new VerticalBlockSample(i, states);
    }

    private OptionalInt sampleHeightmap(int x, int z, @Nullable BlockState[] states, @Nullable Predicate<BlockState> predicate, int minY, int noiseSizeY) {
        int xSection = SectionPos.func_218159_a((int)x);
        int zSection = SectionPos.func_218159_a((int)z);
        int xDiv = Math.floorDiv(x, this.horizontalNoiseGranularity);
        int zDiv = Math.floorDiv(z, this.horizontalNoiseGranularity);
        int xMod = Math.floorMod(x, this.horizontalNoiseGranularity);
        int zMod = Math.floorMod(z, this.horizontalNoiseGranularity);
        double deltaY = (double)xMod / (double)this.horizontalNoiseGranularity;
        double deltaZ = (double)zMod / (double)this.horizontalNoiseGranularity;
        double[][] noiseData = new double[][]{this.sampleNoiseColumn(xDiv, zDiv, minY, noiseSizeY), this.sampleNoiseColumn(xDiv, zDiv + 1, minY, noiseSizeY), this.sampleNoiseColumn(xDiv + 1, zDiv, minY, noiseSizeY), this.sampleNoiseColumn(xDiv + 1, zDiv + 1, minY, noiseSizeY)};
        AquiferSampler aquifer = this.getAquifer(minY, noiseSizeY, new ChunkPos(xSection, zSection));
        for (int noiseY = this.noiseSizeY - 1; noiseY >= 0; --noiseY) {
            double x0z0y0 = noiseData[0][noiseY];
            double x0z1y0 = noiseData[1][noiseY];
            double x1z0y0 = noiseData[2][noiseY];
            double x1z1y0 = noiseData[3][noiseY];
            double x0z0y1 = noiseData[0][noiseY + 1];
            double x0z1y1 = noiseData[1][noiseY + 1];
            double x1z0y1 = noiseData[2][noiseY + 1];
            double x1z1y1 = noiseData[3][noiseY + 1];
            for (int radius = this.verticalNoiseGranularity - 1; radius >= 0; --radius) {
                double deltaX = (double)radius / (double)this.verticalNoiseGranularity;
                double noise = MathHelper.func_219807_a((double)deltaX, (double)deltaY, (double)deltaZ, (double)x0z0y0, (double)x0z0y1, (double)x1z0y0, (double)x1z0y1, (double)x0z1y0, (double)x0z1y1, (double)x1z1y0, (double)x1z1y1);
                int y = noiseY * this.verticalNoiseGranularity + radius;
                int height = y + minY * this.verticalNoiseGranularity;
                BlockState state = this.getBlockState(Beardifier.INSTANCE, aquifer, this.deepslateSource, WeightSampler.DEFAULT, x, height, z, noise);
                if (states != null) {
                    states[y] = state;
                }
                if (predicate == null || !predicate.test(state)) continue;
                return OptionalInt.of(height + 1);
            }
        }
        return OptionalInt.empty();
    }

    private AquiferSampler getAquifer(int minY, int noiseSizeY, ChunkPos pos) {
        return !this.hasAquifers() ? AquiferSampler.createDisabled(this.func_230356_f_(), this.defaultFluid) : AquiferSampler.create(pos, this.edgeDensityNoise, this.waterLevelNoise, this.lavaNoise, this.field_222543_d.get(), minY * this.verticalNoiseGranularity, noiseSizeY * this.verticalNoiseGranularity);
    }

    protected BlockState getBlockState(Beardifier structures, AquiferSampler aquiferSampler, BaseStoneSource source, WeightSampler noiseModifier, int x, int y, int z, double noise) {
        double density = MathHelper.func_151237_a((double)(noise / 200.0), (double)-1.0, (double)1.0);
        density = density / 2.0 - density * density * density / 24.0;
        density = noiseModifier.sample(density, x, y, z);
        return aquiferSampler.apply(source, x, y, z, density += structures.getWeight(x, y, z));
    }

    public void func_225551_a_(WorldGenRegion region, IChunk chunk) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int xChunk = chunkPos.field_77276_a;
        int zChunk = chunkPos.field_77275_b;
        SharedSeedRandom seedRandom = new SharedSeedRandom();
        seedRandom.func_202422_a(xChunk, zChunk);
        ChunkPos pos = chunk.func_76632_l();
        int xStart = pos.func_180334_c();
        int zStart = pos.func_180333_d();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int xEnd = 0; xEnd < 16; ++xEnd) {
            for (int zEnd = 0; zEnd < 16; ++zEnd) {
                int x = xStart + xEnd;
                int z = zStart + zEnd;
                int y = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, xEnd, zEnd) + 1;
                double noise = this.surfaceDepthNoise.func_215460_a((double)x * 0.0625, (double)z * 0.0625, 0.0625, (double)xEnd * 0.0625) * 15.0;
                region.func_226691_t_((BlockPos)mutable.func_181079_c(xStart + xEnd, y, zStart + zEnd)).func_206854_a((Random)seedRandom, chunk, x, z, y, noise, this.defaultBlock, this.defaultFluid, this.func_230356_f_(), region.func_72905_C());
            }
        }
        this.makeBedrock(chunk, (Random)seedRandom);
    }

    private void makeBedrock(IChunk chunkIn, Random rand) {
        boolean flag1;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int i = chunkIn.func_76632_l().func_180334_c();
        int j = chunkIn.func_76632_l().func_180333_d();
        DimensionSettings dimensionsettings = this.field_222543_d.get();
        int k = dimensionsettings.func_236118_f_();
        int l = this.worldHeight - 1 - dimensionsettings.func_236117_e_();
        boolean flag = l + 4 >= 0 && l < this.worldHeight;
        boolean bl = flag1 = k + 4 >= 0 && k < this.worldHeight;
        if (flag || flag1) {
            for (BlockPos blockpos : BlockPos.func_191531_b((int)i, (int)0, (int)j, (int)(i + 15), (int)0, (int)(j + 15))) {
                if (flag) {
                    for (int j1 = 0; j1 < 5; ++j1) {
                        if (j1 > rand.nextInt(5)) continue;
                        chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), l - j1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                    }
                }
                if (!flag1) continue;
                for (int k1 = 4; k1 >= 0; --k1) {
                    if (k1 > rand.nextInt(5)) continue;
                    chunkIn.func_177436_a((BlockPos)blockpos$mutable.func_181079_c(blockpos.func_177958_n(), k + k1, blockpos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
                }
            }
        }
    }

    public void func_230352_b_(IWorld world, StructureManager manager, IChunk chunkIn) {
        ChunkPrimer chunkPrimer = (ChunkPrimer)chunkIn;
        int i = HeightLimitReader.getBottomY();
        int j = Math.min(HeightLimitReader.getBottomY() + HeightLimitReader.getHeight(), HeightLimitReader.getTopY());
        int k = MathHelper.func_76137_a((int)i, (int)this.verticalNoiseGranularity);
        int l = MathHelper.func_76137_a((int)(j - i), (int)this.verticalNoiseGranularity);
        if (l > 0) {
            int m = HeightLimitReader.getSectionIndex(l * this.verticalNoiseGranularity - 1 + i);
            int n = HeightLimitReader.getSectionIndex(i);
            HashSet chunkSet = Sets.newHashSet();
            for (int o = m; o >= n; --o) {
                ChunkSection chunkSection = chunkPrimer.func_217332_a(o);
                chunkSection.func_222635_a();
                chunkSet.add(chunkSection);
            }
            this.populateNoise(manager, chunkIn, k, l);
            for (ChunkSection chunkSection : chunkSet) {
                chunkSection.func_222637_b();
            }
        }
    }

    private void populateNoise(StructureManager manager, IChunk chunk, int minY, int height) {
        Heightmap heightmap = chunk.func_217303_b(Heightmap.Type.OCEAN_FLOOR_WG);
        Heightmap heightmap2 = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE_WG);
        ChunkPos chunkPos = chunk.func_76632_l();
        int k = chunkPos.func_180334_c();
        int l = chunkPos.func_180333_d();
        Beardifier beardifier = new Beardifier(manager, chunk);
        AquiferSampler aquifer = this.getAquifer(minY, height, chunkPos);
        NoiseInterpolator noiseInterpolator = new NoiseInterpolator(this.noiseSizeX, height, this.noiseSizeZ, chunkPos, minY, this::sampleNoiseColumn);
        ArrayList list = Lists.newArrayList((Object[])new NoiseInterpolator[]{noiseInterpolator});
        Consumer<NoiseInterpolator> consumer = list::add;
        DoubleFunction<BaseStoneSource> doubleFunction = this.createBaseStoneSource(minY, chunkPos, consumer);
        DoubleFunction<WeightSampler> doubleFunction2 = this.createCaveNoiseModifier(minY, chunkPos, consumer);
        list.forEach(NoiseInterpolator::sampleStartNoise);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        ChunkPrimer chunkIn = (ChunkPrimer)chunk;
        for (int m = 0; m < this.noiseSizeX; ++m) {
            int finalM = m;
            list.forEach(noiseInterpolatorx -> noiseInterpolatorx.sampleEndNoise(finalM));
            for (int o = 0; o < this.noiseSizeZ; ++o) {
                ChunkSection chunkSection = chunkIn.func_217332_a(HeightLimitReader.countVerticalSections() - 1);
                for (int p = height - 1; p >= 0; --p) {
                    int finalP = p;
                    int finalO = o;
                    list.forEach(noiseInterpolatorx -> noiseInterpolatorx.sampleNoiseCorners(finalP, finalO));
                    for (int s = this.verticalNoiseGranularity - 1; s >= 0; --s) {
                        int t = (minY + p) * this.verticalNoiseGranularity + s;
                        int u = t & 0xF;
                        int v = HeightLimitReader.getSectionIndex(t);
                        if (HeightLimitReader.getSectionIndex(chunkSection.func_222632_g()) != v) {
                            chunkSection = chunkIn.func_217332_a(v);
                        }
                        double d = (double)s / (double)this.verticalNoiseGranularity;
                        list.forEach(noiseInterpolatorx -> noiseInterpolatorx.sampleNoiseY(d));
                        for (int w = 0; w < this.horizontalNoiseGranularity; ++w) {
                            int x = k + m * this.horizontalNoiseGranularity + w;
                            int y = x & 0xF;
                            double e = (double)w / (double)this.horizontalNoiseGranularity;
                            list.forEach(noiseInterpolatorx -> noiseInterpolatorx.sampleNoiseX(e));
                            for (int z = 0; z < this.horizontalNoiseGranularity; ++z) {
                                int aa = l + o * this.horizontalNoiseGranularity + z;
                                int ab = aa & 0xF;
                                double f = (double)z / (double)this.horizontalNoiseGranularity;
                                double g = noiseInterpolator.sampleNoise(f);
                                BlockState blockState = this.getBlockState(beardifier, aquifer, doubleFunction.apply(f), doubleFunction2.apply(f), x, t, aa, g);
                                if (blockState == AIR) continue;
                                if (blockState.func_185906_d() != 0) {
                                    mutable.func_181079_c(x, t, aa);
                                    chunkIn.func_201637_h((BlockPos)mutable);
                                }
                                chunkSection.func_177484_a(y, u, ab, blockState, false);
                                heightmap.func_202270_a(y, t, ab, blockState);
                                heightmap2.func_202270_a(y, t, ab, blockState);
                                if (!aquifer.needsFluidTick() || blockState.func_204520_s().func_206888_e()) continue;
                                mutable.func_181079_c(x, t, aa);
                                chunk.func_212247_j().func_205360_a((BlockPos)mutable, (Object)blockState.func_204520_s().func_206886_c(), 0);
                            }
                        }
                    }
                }
            }
            list.forEach(NoiseInterpolator::swapBuffers);
        }
    }

    private DoubleFunction<WeightSampler> createCaveNoiseModifier(int minY, ChunkPos chunkPos, Consumer<NoiseInterpolator> consumer) {
        if (!((Boolean)CavesAndCliffsConfig.generateNoodleCaves.get()).booleanValue()) {
            return noise -> WeightSampler.DEFAULT;
        }
        NoodleCaveNoiseModifier noodleCaveNoiseModifier = new NoodleCaveNoiseModifier(chunkPos, minY);
        noodleCaveNoiseModifier.listInterpolators(consumer);
        return noodleCaveNoiseModifier::prepare;
    }

    private DoubleFunction<BaseStoneSource> createBaseStoneSource(int minY, ChunkPos chunkPos, Consumer<NoiseInterpolator> consumer) {
        if (!((Boolean)CavesAndCliffsConfig.generateOreVeins.get()).booleanValue()) {
            return source -> this.deepslateSource;
        }
        OreVeinNoiseSource oreVeinNoiseSource = new OreVeinNoiseSource(chunkPos, minY, this.seed + 1L);
        oreVeinNoiseSource.listInterpolators(consumer);
        BaseStoneSource stoneSource = (x, y, z) -> {
            BlockState state = oreVeinNoiseSource.sample(x, y, z);
            return state != this.defaultBlock ? state : this.deepslateSource.sample(x, y, z);
        };
        return factorZ -> {
            oreVeinNoiseSource.prepare(factorZ);
            return stoneSource;
        };
    }

    public int func_230355_e_() {
        return this.worldHeight;
    }

    public int func_230356_f_() {
        return this.field_222543_d.get().func_236119_g_();
    }

    public int getMinimumY() {
        return HeightLimitReader.getBottomY();
    }

    public List<MobSpawnInfo.Spawners> func_230353_a_(Biome p_230353_1_, StructureManager p_230353_2_, EntityClassification p_230353_3_, BlockPos p_230353_4_) {
        List spawns = StructureSpawnManager.getStructureSpawns((StructureManager)p_230353_2_, (EntityClassification)p_230353_3_, (BlockPos)p_230353_4_);
        if (spawns != null) {
            return spawns;
        }
        return super.func_230353_a_(p_230353_1_, p_230353_2_, p_230353_3_, p_230353_4_);
    }

    public void func_230354_a_(WorldGenRegion region) {
        if (!this.field_222543_d.get().func_236120_h_()) {
            int x = region.func_201679_a();
            int z = region.func_201680_b();
            Biome biome = region.func_226691_t_(new ChunkPos(x, z).func_206849_h());
            SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
            sharedSeedRandom.func_202424_a(region.func_72905_C(), x << 4, z << 4);
            WorldEntitySpawner.func_77191_a((IServerWorld)region, (Biome)biome, (int)x, (int)z, (Random)sharedSeedRandom);
        }
    }

    class OreVeinNoiseSource
    implements BaseStoneSource {
        private final NoiseInterpolator veininess;
        private final NoiseInterpolator veinA;
        private final NoiseInterpolator veinB;
        private double factorZ;
        private final long seed;
        private final SharedSeedRandom seedRandom = new SharedSeedRandom();

        public OreVeinNoiseSource(ChunkPos chunkPos, int minY, long seed) {
            int xSize = NoiseBasedChunkGenerator.this.noiseSizeX;
            int ySize = NoiseBasedChunkGenerator.this.noiseSizeY;
            int zSize = NoiseBasedChunkGenerator.this.noiseSizeZ;
            OreVeinifier oreVeinifier = NoiseBasedChunkGenerator.this.oreVeinifier;
            this.veininess = new NoiseInterpolator(xSize, ySize, zSize, chunkPos, minY, oreVeinifier::fillVeininessNoiseColumn);
            xSize = NoiseBasedChunkGenerator.this.noiseSizeX;
            ySize = NoiseBasedChunkGenerator.this.noiseSizeY;
            zSize = NoiseBasedChunkGenerator.this.noiseSizeZ;
            oreVeinifier = NoiseBasedChunkGenerator.this.oreVeinifier;
            this.veinA = new NoiseInterpolator(xSize, ySize, zSize, chunkPos, minY, oreVeinifier::fillNoiseColumnA);
            xSize = NoiseBasedChunkGenerator.this.noiseSizeX;
            ySize = NoiseBasedChunkGenerator.this.noiseSizeY;
            zSize = NoiseBasedChunkGenerator.this.noiseSizeZ;
            oreVeinifier = NoiseBasedChunkGenerator.this.oreVeinifier;
            this.veinB = new NoiseInterpolator(xSize, ySize, zSize, chunkPos, minY, oreVeinifier::fillNoiseColumnB);
            this.seed = seed;
        }

        public void listInterpolators(Consumer<NoiseInterpolator> consumer) {
            consumer.accept(this.veininess);
            consumer.accept(this.veinA);
            consumer.accept(this.veinB);
        }

        public void prepare(double factorZ) {
            this.factorZ = factorZ;
        }

        @Override
        public BlockState sample(int x, int y, int z) {
            double veininess = this.veininess.sampleNoise(this.factorZ);
            double veinA = this.veinA.sampleNoise(this.factorZ);
            double veinB = this.veinB.sampleNoise(this.factorZ);
            SeedRandomUtils.setDeepslateSeed(this.seedRandom, this.seed, x, y, z);
            return NoiseBasedChunkGenerator.this.oreVeinifier.oreVeinify(this.seedRandom, x, y, z, veininess, veinA, veinB);
        }
    }

    class NoodleCaveNoiseModifier
    implements WeightSampler {
        private final NoiseInterpolator toggle;
        private final NoiseInterpolator thickness;
        private final NoiseInterpolator ridgeA;
        private final NoiseInterpolator ridgeB;
        private double factorZ;

        public NoodleCaveNoiseModifier(ChunkPos chunkPos, int minY) {
            int xSize = NoiseBasedChunkGenerator.this.noiseSizeX;
            int ySize = NoiseBasedChunkGenerator.this.noiseSizeY;
            int zSize = NoiseBasedChunkGenerator.this.noiseSizeZ;
            NoodleCavifier noodleCavifier = NoiseBasedChunkGenerator.this.noodleCavifier;
            this.toggle = new NoiseInterpolator(xSize, ySize, zSize, chunkPos, minY, noodleCavifier::fillToggleNoiseColumn);
            xSize = NoiseBasedChunkGenerator.this.noiseSizeX;
            ySize = NoiseBasedChunkGenerator.this.noiseSizeY;
            zSize = NoiseBasedChunkGenerator.this.noiseSizeZ;
            noodleCavifier = NoiseBasedChunkGenerator.this.noodleCavifier;
            this.thickness = new NoiseInterpolator(xSize, ySize, zSize, chunkPos, minY, noodleCavifier::fillThicknessNoiseColumn);
            xSize = NoiseBasedChunkGenerator.this.noiseSizeX;
            ySize = NoiseBasedChunkGenerator.this.noiseSizeY;
            zSize = NoiseBasedChunkGenerator.this.noiseSizeZ;
            noodleCavifier = NoiseBasedChunkGenerator.this.noodleCavifier;
            this.ridgeA = new NoiseInterpolator(xSize, ySize, zSize, chunkPos, minY, noodleCavifier::fillRidgeANoiseColumn);
            xSize = NoiseBasedChunkGenerator.this.noiseSizeX;
            ySize = NoiseBasedChunkGenerator.this.noiseSizeY;
            zSize = NoiseBasedChunkGenerator.this.noiseSizeZ;
            noodleCavifier = NoiseBasedChunkGenerator.this.noodleCavifier;
            this.ridgeB = new NoiseInterpolator(xSize, ySize, zSize, chunkPos, minY, noodleCavifier::fillRidgeBNoiseColumn);
        }

        public WeightSampler prepare(double factorZ) {
            this.factorZ = factorZ;
            return this;
        }

        @Override
        public double sample(double weight, int x, int y, int z) {
            double toggle = this.toggle.sampleNoise(this.factorZ);
            double thickness = this.thickness.sampleNoise(this.factorZ);
            double ridgeA = this.ridgeA.sampleNoise(this.factorZ);
            double ridgeB = this.ridgeB.sampleNoise(this.factorZ);
            return NoiseBasedChunkGenerator.this.noodleCavifier.noodleCavify(weight, x, y, z, toggle, thickness, ridgeA, ridgeB, NoiseBasedChunkGenerator.this.getMinimumY());
        }

        public void listInterpolators(Consumer<NoiseInterpolator> consumer) {
            consumer.accept(this.toggle);
            consumer.accept(this.thickness);
            consumer.accept(this.ridgeA);
            consumer.accept(this.ridgeB);
        }
    }
}

