/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import com.blackgear.cavesandcliffs.common.world.gen.chunk.WeightSampler;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.NoiseGenUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.NoiseHelper;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.gen.MaxMinNoiseMixer;

public class NoiseCaveSampler
implements WeightSampler {
    private final int minY;
    private final MaxMinNoiseMixer terrainAdditionNoise;
    private final MaxMinNoiseMixer pillarNoise;
    private final MaxMinNoiseMixer pillarFalloffNoise;
    private final MaxMinNoiseMixer pillarScaleNoise;
    private final MaxMinNoiseMixer scaledCaveScaleNoise;
    private final MaxMinNoiseMixer horizontalCaveNoise;
    private final MaxMinNoiseMixer caveScaleNoise;
    private final MaxMinNoiseMixer caveFalloffNoise;
    private final MaxMinNoiseMixer tunnelNoise1;
    private final MaxMinNoiseMixer tunnelNoise2;
    private final MaxMinNoiseMixer tunnelScaleNoise;
    private final MaxMinNoiseMixer tunnelFalloffNoise;
    private final MaxMinNoiseMixer offsetNoise;
    private final MaxMinNoiseMixer offsetScaleNoise;
    private final MaxMinNoiseMixer caveEntranceNoise;
    private final MaxMinNoiseMixer caveDensityNoise;

    public NoiseCaveSampler(SharedSeedRandom random, int minY) {
        this.minY = minY;
        this.pillarNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -7, 1.0, 1.0);
        this.pillarFalloffNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 1.0);
        this.pillarScaleNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 1.0);
        this.scaledCaveScaleNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -7, 1.0);
        this.horizontalCaveNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 1.0);
        this.caveScaleNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -11, 1.0);
        this.caveFalloffNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -11, 1.0);
        this.tunnelNoise1 = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -7, 1.0);
        this.tunnelNoise2 = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -7, 1.0);
        this.tunnelScaleNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -11, 1.0);
        this.tunnelFalloffNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 1.0);
        this.offsetNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -5, 1.0);
        this.offsetScaleNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 1.0);
        this.caveEntranceNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -7, 0.4, 0.5, 1.0);
        this.terrainAdditionNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 1.0);
        this.caveDensityNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 0.5, 1.0, 2.0, 1.0, 2.0, 1.0, 0.0, 2.0, 0.0);
    }

    @Override
    public double sample(double weight, int x, int y, int z) {
        boolean bl = weight < 170.0;
        double d = this.getTunnelOffsetNoise(z, x, y);
        double e = this.getTunnelNoise(z, x, y);
        if (bl) {
            return Math.min(weight, (e + d) * 128.0 * 5.0);
        }
        double f = this.caveDensityNoise.func_237211_a_((double)z, (double)x / 1.5, (double)y);
        double g = MathHelper.func_151237_a((double)(f + 0.25), (double)-1.0, (double)1.0);
        double h = (float)(30 - x) / 8.0f;
        double i = g + MathHelper.func_151238_b((double)0.5, (double)0.0, (double)h);
        double j = this.getTerrainAdditionNoise(z, x, y);
        double k = this.getCaveNoise(z, x, y);
        double l = i + j;
        double m = Math.min(l, Math.min(e, k) + d);
        double n = Math.max(m, this.getPillarNoise(z, x, y));
        return 128.0 * MathHelper.func_151237_a((double)n, (double)-1.0, (double)1.0);
    }

    private double getPillarNoise(int x, int y, int z) {
        double f = NoiseHelper.lerpFromProgress(this.pillarFalloffNoise, x, y, z, 0.0, 2.0);
        double i = NoiseHelper.lerpFromProgress(this.pillarScaleNoise, x, y, z, 0.0, 1.1);
        i = Math.pow(i, 3.0);
        double l = this.pillarNoise.func_237211_a_((double)x * 25.0, (double)y * 0.3, (double)z * 25.0);
        return (l = i * (l * 2.0 - f)) > 0.03 ? l : Double.NEGATIVE_INFINITY;
    }

    private double getTerrainAdditionNoise(int x, int y, int z) {
        double d = this.terrainAdditionNoise.func_237211_a_((double)x, (double)(y * 8), (double)z);
        return MathUtils.square(d) * 4.0;
    }

    private double getTunnelNoise(int x, int y, int z) {
        double d = this.tunnelScaleNoise.func_237211_a_((double)(x * 2), (double)y, (double)(z * 2));
        double e = CaveScaler.scaleTunnels(d);
        double h = NoiseHelper.lerpFromProgress(this.tunnelFalloffNoise, x, y, z, 0.065, 0.088);
        double i = NoiseCaveSampler.sample(this.tunnelNoise1, x, y, z, e);
        double j = Math.abs(e * i) - h;
        double k = NoiseCaveSampler.sample(this.tunnelNoise2, x, y, z, e);
        double l = Math.abs(e * k) - h;
        return NoiseCaveSampler.clamp(Math.max(j, l));
    }

    private double getCaveNoise(int x, int y, int z) {
        double d = this.caveScaleNoise.func_237211_a_((double)(x * 2), (double)y, (double)(z * 2));
        double e = CaveScaler.scaleCaves(d);
        double h = NoiseHelper.lerpFromProgress(this.caveFalloffNoise, x * 2, y, z * 2, 0.6, 1.3);
        double i = NoiseCaveSampler.sample(this.scaledCaveScaleNoise, x, y, z, e);
        double k = Math.abs(e * i) - 0.083 * h;
        double n = NoiseHelper.lerpFromProgress(this.horizontalCaveNoise, x, 0.0, z, this.minY, 8.0);
        double o = Math.abs(n - (double)y / 8.0) - h;
        o = o * o * o;
        return NoiseCaveSampler.clamp(Math.max(o, k));
    }

    private double getTunnelOffsetNoise(int x, int y, int z) {
        double d = NoiseHelper.lerpFromProgress(this.offsetScaleNoise, x, y, z, 0.0, 0.1);
        return (0.4 - Math.abs(this.offsetNoise.func_237211_a_((double)x, (double)y, (double)z))) * d;
    }

    private static double clamp(double value) {
        return MathHelper.func_151237_a((double)value, (double)-1.0, (double)1.0);
    }

    private static double sample(MaxMinNoiseMixer sampler, double x, double y, double z, double scale) {
        return sampler.func_237211_a_(x / scale, y / scale, z / scale);
    }

    static final class CaveScaler {
        CaveScaler() {
        }

        private static double scaleCaves(double value) {
            if (value < -0.75) {
                return 0.5;
            }
            if (value < -0.5) {
                return 0.75;
            }
            if (value < 0.5) {
                return 1.0;
            }
            return value < 0.75 ? 2.0 : 3.0;
        }

        private static double scaleTunnels(double value) {
            if (value < -0.5) {
                return 0.75;
            }
            if (value < 0.0) {
                return 1.0;
            }
            return value < 0.5 ? 1.5 : 2.0;
        }
    }
}

