/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import com.blackgear.cavesandcliffs.common.world.gen.chunk.InterpolatedNoiseGenerator;
import com.blackgear.cavesandcliffs.common.world.gen.chunk.WeightSampler;
import com.blackgear.cavesandcliffs.core.registries.api.util.HeightLimitReader;
import javax.annotation.Nullable;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.SimplexNoiseGenerator;
import net.minecraft.world.gen.settings.NoiseSettings;

public class NoiseColumnSampler {
    private static final float[] BIOME_WEIGHT_TABLE = (float[])Util.func_200696_a((Object)new float[25], array -> {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                float weight;
                array[x + 2 + (z + 2) * 5] = weight = 10.0f / MathHelper.func_76129_c((float)((float)(x * x + z * z) + 0.2f));
            }
        }
    });
    private final BiomeProvider biomeProvider;
    private final int horizontalNoiseGranularity;
    private final int verticalNoiseGranularity;
    private final int noiseSizeY;
    private final InterpolatedNoiseGenerator noise;
    @Nullable
    private final SimplexNoiseGenerator islandNoise;
    private final OctavesNoiseGenerator densityNoise;
    private final double topSlideTarget;
    private final double topSlideSize;
    private final double topSlideOffset;
    private final double bottomSlideTarget;
    private final double bottomSlideSize;
    private final double bottomSlideOffset;
    private final double densityFactor;
    private final double densityOffset;
    private final WeightSampler noiseModifier;

    public NoiseColumnSampler(BiomeProvider biomeProvider, int horizontalNoiseGranularity, int verticalNoiseGranularity, int noiseSizeY, NoiseSettings settings, InterpolatedNoiseGenerator noise, SimplexNoiseGenerator islandNoise, OctavesNoiseGenerator densityNoise, WeightSampler noiseModifier) {
        this.biomeProvider = biomeProvider;
        this.horizontalNoiseGranularity = horizontalNoiseGranularity;
        this.verticalNoiseGranularity = verticalNoiseGranularity;
        this.noiseSizeY = noiseSizeY;
        this.noise = noise;
        this.islandNoise = islandNoise;
        this.densityNoise = densityNoise;
        this.topSlideTarget = settings.func_236172_c_().func_236186_a_();
        this.topSlideSize = settings.func_236172_c_().func_236188_b_();
        this.topSlideOffset = settings.func_236172_c_().func_236189_c_();
        this.bottomSlideTarget = settings.func_236173_d_().func_236186_a_();
        this.bottomSlideSize = settings.func_236173_d_().func_236188_b_();
        this.bottomSlideOffset = settings.func_236173_d_().func_236189_c_();
        this.densityFactor = settings.func_236176_g_();
        this.densityOffset = settings.func_236177_h_();
        this.noiseModifier = noiseModifier;
    }

    public void sampleNoiseColumn(double[] buffer, int x, int z, NoiseSettings config, int seaLevel, int minY, int noiseSizeY) {
        double density;
        double scale;
        double depth;
        if (this.islandNoise != null) {
            depth = EndBiomeProvider.func_235317_a_((SimplexNoiseGenerator)this.islandNoise, (int)x, (int)z) - 8.0f;
            scale = depth > 0.0 ? 0.25 : 1.0;
        } else {
            float xIn = 0.0f;
            float yIn = 0.0f;
            float zIn = 0.0f;
            float depthNoise = this.biomeProvider.func_225526_b_(x, seaLevel, z).func_185355_j();
            for (int xArea = -2; xArea <= 2; ++xArea) {
                for (int zArea = -2; zArea <= 2; ++zArea) {
                    float modScale;
                    float modDepth;
                    Biome biome = this.biomeProvider.func_225526_b_(x + xArea, seaLevel, z + zArea);
                    float biomeDepth = biome.func_185355_j();
                    float biomeScale = biome.func_185360_m();
                    if (config.func_236181_l_() && biomeDepth > 0.0f) {
                        modDepth = 1.0f + biomeDepth * 2.0f;
                        modScale = 1.0f + biomeScale * 4.0f;
                    } else {
                        modDepth = biomeDepth;
                        modScale = biomeScale;
                    }
                    float u = biomeDepth > depthNoise ? 0.5f : 1.0f;
                    float v = u * BIOME_WEIGHT_TABLE[xArea + 2 + (zArea + 2) * 5] / (modDepth + 2.0f);
                    xIn += modScale * v;
                    yIn += modDepth * v;
                    zIn += v;
                }
            }
            float w = yIn / zIn;
            float y = xIn / zIn;
            density = w * 0.5f - 0.125f;
            double ab = y * 0.9f + 0.1f;
            depth = density * 0.265625;
            scale = 96.0 / ab;
        }
        double xzScale = 684.412 * config.func_236171_b_().func_236151_a_();
        double yScale = 684.412 * config.func_236171_b_().func_236153_b_();
        double xzFactor = xzScale / config.func_236171_b_().func_236154_c_();
        double yFactor = yScale / config.func_236171_b_().func_236155_d_();
        density = config.func_236179_j_() ? this.getDensityNoise(x, z) : 0.0;
        for (int height = 0; height <= noiseSizeY; ++height) {
            int topHeight = height + minY;
            double sample = this.noise.sample(x, topHeight, z, xzScale, yScale, xzFactor, yFactor);
            double offset = this.getOffset(topHeight, depth, scale, density) + sample;
            offset = this.noiseModifier.sample(offset, topHeight * this.verticalNoiseGranularity, z * this.horizontalNoiseGranularity, x * this.horizontalNoiseGranularity);
            buffer[height] = offset = this.applySlides(offset, topHeight);
        }
    }

    private double getOffset(int y, double depth, double scale, double randomDensityOffset) {
        double f;
        double d = 1.0 - (double)y * 2.0 / 32.0 + randomDensityOffset;
        double e = d * this.densityFactor + this.densityOffset;
        return f * (double)((f = (e + depth) * scale) > 0.0 ? 4 : 1);
    }

    private double applySlides(double noise, int y) {
        double e;
        int i = MathHelper.func_76137_a((int)HeightLimitReader.getBottomY(), (int)this.verticalNoiseGranularity);
        int j = y - i;
        if (this.topSlideSize > 0.0) {
            e = ((double)(this.noiseSizeY - j) - this.topSlideOffset) / this.topSlideSize;
            noise = MathHelper.func_151238_b((double)this.topSlideTarget, (double)noise, (double)e);
        }
        if (this.bottomSlideSize > 0.0) {
            e = ((double)j - this.bottomSlideOffset) / this.bottomSlideSize;
            noise = MathHelper.func_151238_b((double)this.bottomSlideTarget, (double)noise, (double)e);
        }
        return noise;
    }

    private double getDensityNoise(int x, int z) {
        double d = this.densityNoise.func_215462_a((double)(x * 200), 10.0, (double)(z * 200), 1.0, 0.0, true);
        double f = d < 0.0 ? -d * 0.3 : d;
        double g = f * 24.575625 - 2.0;
        return g < 0.0 ? g * 0.009486607142857142 : Math.min(g, 1.0) * 0.006640625;
    }
}

