/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;

public class NoiseInterpolator {
    private double[][] startNoiseBuffer;
    private double[][] endNoiseBuffer;
    private final int sizeY;
    private final int sizeZ;
    private final int minY;
    private final ColumnSampler columnSampler;
    private double x0y0z0;
    private double x0y0z1;
    private double x1y0z0;
    private double x1y0z1;
    private double x0y1z0;
    private double x0y1z1;
    private double x1y1z0;
    private double x1y1z1;
    private double x0z0;
    private double x1z0;
    private double x0z1;
    private double x1z1;
    private double z0;
    private double z1;
    private final int startX;
    private final int startZ;

    public NoiseInterpolator(int sizeX, int sizeY, int sizeZ, ChunkPos chunkPos, int minY, ColumnSampler columnSampler) {
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.minY = minY;
        this.columnSampler = columnSampler;
        this.startNoiseBuffer = NoiseInterpolator.createBuffer(sizeY, sizeZ);
        this.endNoiseBuffer = NoiseInterpolator.createBuffer(sizeY, sizeZ);
        this.startX = chunkPos.field_77276_a * sizeX;
        this.startZ = chunkPos.field_77275_b * sizeZ;
    }

    private static double[][] createBuffer(int sizeY, int sizeZ) {
        int i = sizeZ + 1;
        int j = sizeY + 1;
        double[][] ds = new double[i][j];
        for (int k = 0; k < i; ++k) {
            ds[k] = new double[j];
        }
        return ds;
    }

    public void sampleStartNoise() {
        this.sampleNoise(this.startNoiseBuffer, this.startX);
    }

    public void sampleEndNoise(int x) {
        this.sampleNoise(this.endNoiseBuffer, this.startX + x + 1);
    }

    private void sampleNoise(double[][] buffer, int noiseX) {
        for (int i = 0; i < this.sizeZ + 1; ++i) {
            int j = this.startZ + i;
            this.columnSampler.fillNoiseColumn(buffer[i], noiseX, j, this.minY, this.sizeY);
        }
    }

    public void sampleNoiseCorners(int noiseY, int noiseZ) {
        this.x0y0z0 = this.startNoiseBuffer[noiseZ][noiseY];
        this.x0y0z1 = this.startNoiseBuffer[noiseZ + 1][noiseY];
        this.x1y0z0 = this.endNoiseBuffer[noiseZ][noiseY];
        this.x1y0z1 = this.endNoiseBuffer[noiseZ + 1][noiseY];
        this.x0y1z0 = this.startNoiseBuffer[noiseZ][noiseY + 1];
        this.x0y1z1 = this.startNoiseBuffer[noiseZ + 1][noiseY + 1];
        this.x1y1z0 = this.endNoiseBuffer[noiseZ][noiseY + 1];
        this.x1y1z1 = this.endNoiseBuffer[noiseZ + 1][noiseY + 1];
    }

    public void sampleNoiseY(double deltaY) {
        this.x0z0 = MathHelper.func_219803_d((double)deltaY, (double)this.x0y0z0, (double)this.x0y1z0);
        this.x1z0 = MathHelper.func_219803_d((double)deltaY, (double)this.x1y0z0, (double)this.x1y1z0);
        this.x0z1 = MathHelper.func_219803_d((double)deltaY, (double)this.x0y0z1, (double)this.x0y1z1);
        this.x1z1 = MathHelper.func_219803_d((double)deltaY, (double)this.x1y0z1, (double)this.x1y1z1);
    }

    public void sampleNoiseX(double deltaX) {
        this.z0 = MathHelper.func_219803_d((double)deltaX, (double)this.x0z0, (double)this.x1z0);
        this.z1 = MathHelper.func_219803_d((double)deltaX, (double)this.x0z1, (double)this.x1z1);
    }

    public double sampleNoise(double deltaZ) {
        return MathHelper.func_219803_d((double)deltaZ, (double)this.z0, (double)this.z1);
    }

    public void swapBuffers() {
        double[][] ds = this.startNoiseBuffer;
        this.startNoiseBuffer = this.endNoiseBuffer;
        this.endNoiseBuffer = ds;
    }

    public static interface ColumnSampler {
        public void fillNoiseColumn(double[] var1, int var2, int var3, int var4, int var5);
    }
}

