/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.NoiseGenUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.NoiseHelper;
import java.util.Random;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.gen.MaxMinNoiseMixer;

public class NoodleCavifier {
    private final MaxMinNoiseMixer toggleNoise;
    private final MaxMinNoiseMixer thicknessNoise;
    private final MaxMinNoiseMixer noodleANoise;
    private final MaxMinNoiseMixer noodleBNoise;

    public NoodleCavifier(long seed) {
        Random random = new Random(seed);
        this.toggleNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 1.0);
        this.thicknessNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 1.0);
        this.noodleANoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -7, 1.0);
        this.noodleBNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -7, 1.0);
    }

    public void fillToggleNoiseColumn(double[] buffer, int i, int j, int k, int l) {
        this.fillNoiseColumn(buffer, i, j, k, l, this.toggleNoise, 1.0);
    }

    public void fillThicknessNoiseColumn(double[] buffer, int i, int j, int k, int l) {
        this.fillNoiseColumn(buffer, i, j, k, l, this.thicknessNoise, 1.0);
    }

    public void fillRidgeANoiseColumn(double[] buffer, int i, int j, int k, int l) {
        this.fillNoiseColumn(buffer, i, j, k, l, this.noodleANoise, 2.6666666666666665, 2.6666666666666665);
    }

    public void fillRidgeBNoiseColumn(double[] buffer, int i, int j, int k, int l) {
        this.fillNoiseColumn(buffer, i, j, k, l, this.noodleBNoise, 2.6666666666666665, 2.6666666666666665);
    }

    public void fillNoiseColumn(double[] buffer, int i, int j, int k, int l, MaxMinNoiseMixer noiseColumn, double d) {
        this.fillNoiseColumn(buffer, i, j, k, l, noiseColumn, d, d);
    }

    public void fillNoiseColumn(double[] ds, int i, int j, int k, int l, MaxMinNoiseMixer noiseColumn, double d, double e) {
        for (int o = 0; o < l; ++o) {
            int p = o + k;
            int q = i * 4;
            int r = p * 8;
            int s = j * 4;
            double g = r < 108 ? NoiseHelper.lerpFromProgress(noiseColumn, (double)q * d, (double)r * e, (double)s * d, -1.0, 1.0) : 1.0;
            ds[o] = g;
        }
    }

    public double noodleCavify(double d, int i, int j, int k, double e, double f, double g, double h, int l) {
        if (j <= 100 && j >= l + 4) {
            if (d < 0.0) {
                return d;
            }
            if (e < 0.0) {
                return d;
            }
            double o = MathUtils.clampedLerpFromProgress(f, -1.0, 1.0, 0.05, 0.07);
            double p = Math.abs(1.5 * g) - o;
            double q = Math.abs(1.5 * h) - o;
            double r = Math.max(p, q);
            return Math.min(d, r);
        }
        return d;
    }
}

