/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.chunk;

import com.blackgear.cavesandcliffs.core.CavesAndCliffsConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.NoiseGenUtils;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.gen.MaxMinNoiseMixer;

public class OreVeinifier {
    private final int veinMaxY;
    private final int veinMinY;
    private final BlockState normalBlock;
    private final MaxMinNoiseMixer veininessNoise;
    private final MaxMinNoiseMixer veinANoise;
    private final MaxMinNoiseMixer veinBNoise;
    private final MaxMinNoiseMixer gapNoise;
    private final int cellWidth;
    private final int cellHeight;

    public OreVeinifier(long seed, BlockState normalBlock, int x, int y, int z) {
        Random random = new Random(seed);
        this.normalBlock = normalBlock;
        this.veininessNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -8, 1.0);
        this.veinANoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -7, 1.0);
        this.veinBNoise = NoiseGenUtils.create(new SharedSeedRandom(random.nextLong()), -7, 1.0);
        this.gapNoise = NoiseGenUtils.create(new SharedSeedRandom(0L), -5, 1.0);
        this.cellWidth = x;
        this.cellHeight = y;
        this.veinMaxY = Stream.of(VeinType.values()).mapToInt(veinType -> ((VeinType)veinType).maxY).max().orElse(z);
        this.veinMinY = Stream.of(VeinType.values()).mapToInt(veinType -> ((VeinType)veinType).minY).min().orElse(z);
    }

    public void fillVeininessNoiseColumn(double[] buffer, int x, int z, int y, int chance) {
        this.fillNoiseColumn(buffer, x, z, this.veininessNoise, 1.5, y, chance);
    }

    public void fillNoiseColumnA(double[] buffer, int x, int z, int y, int chance) {
        this.fillNoiseColumn(buffer, x, z, this.veinANoise, 4.0, y, chance);
    }

    public void fillNoiseColumnB(double[] buffer, int x, int z, int y, int chance) {
        this.fillNoiseColumn(buffer, x, z, this.veinBNoise, 4.0, y, chance);
    }

    public void fillNoiseColumn(double[] buffer, int x, int z, MaxMinNoiseMixer noiseColumn, double radius, int y, int chance) {
        for (int density = 0; density < chance; ++density) {
            int size = density + y;
            int xIn = x * this.cellWidth;
            int yIn = size * this.cellHeight;
            int zIn = z * this.cellWidth;
            double noise = yIn >= this.veinMinY && yIn <= this.veinMaxY ? noiseColumn.func_237211_a_((double)xIn * radius, (double)yIn * radius, (double)zIn * radius) : 0.0;
            buffer[size] = noise;
        }
    }

    public BlockState oreVeinify(SharedSeedRandom random, int x, int y, int z, double minY, double veinA, double veinB) {
        BlockState normalBlock = this.normalBlock;
        VeinType veinType = this.getVeinType(minY, y);
        if (veinType == null) {
            return normalBlock;
        }
        if (random.nextFloat() > 0.7f) {
            return normalBlock;
        }
        if (this.isVein(veinA, veinB)) {
            double density = MathUtils.clampedLerpFromProgress(Math.abs(minY), 0.5, 0.6f, 0.1f, 0.3f);
            if ((double)random.nextFloat() < density && this.gapNoise.func_237211_a_((double)x, (double)y, (double)z) > (double)-0.3f) {
                return random.nextFloat() < 0.2f ? veinType.rawOreBlock : veinType.ore;
            }
            return veinType.filter;
        }
        return normalBlock;
    }

    private boolean isVein(double x, double z) {
        double zDistance;
        double xDistance = Math.abs(x) - (double)0.08f;
        return Math.max(xDistance, zDistance = Math.abs(z) - (double)0.08f) < 0.0;
    }

    @Nullable
    private VeinType getVeinType(double minY, int noiseSizeY) {
        VeinType veinType = minY > (double)((Integer)CavesAndCliffsConfig.maxDeepslateHeight.get()).intValue() ? VeinType.COPPER : VeinType.IRON;
        int veinMaxY = veinType.maxY - noiseSizeY;
        int veinMinY = noiseSizeY - veinType.minY;
        if (veinMinY >= 0 && veinMaxY >= 0) {
            int totalHeight = Math.min(veinMaxY, veinMinY);
            double density = MathUtils.clampedLerpFromProgress(totalHeight, 0.0, 20.0, -0.2, 0.0);
            return Math.abs(minY) + density < 0.5 ? null : veinType;
        }
        return null;
    }

    static enum VeinType {
        COPPER(((Block)CCBBlocks.COPPER_ORE.get()).func_176223_P(), ((Block)CCBBlocks.RAW_COPPER_BLOCK.get()).func_176223_P(), Blocks.field_196650_c.func_176223_P(), (Integer)CavesAndCliffsConfig.maxDeepslateHeight.get(), 50),
        IRON(((Block)CCBBlocks.DEEPSLATE_IRON_ORE.get()).func_176223_P(), ((Block)CCBBlocks.RAW_IRON_BLOCK.get()).func_176223_P(), ((Block)CCBBlocks.TUFF.get()).func_176223_P(), 0, (Integer)CavesAndCliffsConfig.maxDeepslateHeight.get() - 2);

        private final BlockState ore;
        private final BlockState rawOreBlock;
        private final BlockState filter;
        private final int minY;
        private final int maxY;

        private VeinType(BlockState ore, BlockState rawOreBlock, BlockState filter, int minY, int maxY) {
            this.ore = ore;
            this.rawOreBlock = rawOreBlock;
            this.filter = filter;
            this.minY = minY;
            this.maxY = maxY;
        }
    }
}

