/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.blocks.BuddingAmethystBlock;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeBlockSettings;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeCrackSettings;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeLayerSettings;
import com.blackgear.cavesandcliffs.common.world.gen.MaxMinNoiseMixer;
import com.blackgear.cavesandcliffs.common.world.gen.features.config.GeodeConfig;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class AltGeodeFeature
extends Feature<GeodeConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public AltGeodeFeature(Codec<GeodeConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, GeodeConfig config) {
        int minGenOffset = config.minGenOffset;
        int maxGenOffset = config.maxGenOffset;
        LinkedList generationPoints = Lists.newLinkedList();
        int distributionPoints = config.distributionPoints.get(rand);
        SharedSeedRandom seedRandom = new SharedSeedRandom(worldIn.func_72905_C());
        MaxMinNoiseMixer noiseMixer = MaxMinNoiseMixer.create(seedRandom, -4, 1.0);
        LinkedList crackPoints = Lists.newLinkedList();
        double wallDistanceDistributionPoints = (double)distributionPoints / (double)config.outerWallDistance.getMax();
        GeodeLayerSettings geodeLayerSettings = config.geodeLayerSettings;
        GeodeBlockSettings geodeBlockSettings = config.geodeBlockSettings;
        GeodeCrackSettings geodeCrackSettings = config.geodeCrackSettings;
        double filling = 1.0 / Math.sqrt(geodeLayerSettings.filling);
        double innerLayer = 1.0 / Math.sqrt(geodeLayerSettings.innerLayer + wallDistanceDistributionPoints);
        double middleLayer = 1.0 / Math.sqrt(geodeLayerSettings.middleLayer + wallDistanceDistributionPoints);
        double outerLayer = 1.0 / Math.sqrt(geodeLayerSettings.outerLayer + wallDistanceDistributionPoints);
        double crack = 1.0 / Math.sqrt(geodeCrackSettings.baseCrackSize + rand.nextDouble() / 2.0 + (distributionPoints > 3 ? wallDistanceDistributionPoints : 0.0));
        boolean generateCrack = (double)rand.nextFloat() < geodeCrackSettings.generateCrackChance;
        int threshold = 0;
        for (int points = 0; points < distributionPoints; ++points) {
            int zOffset;
            int yOffset;
            int xOffset = config.outerWallDistance.get(rand);
            BlockPos crackPos = pos.func_177982_a(xOffset, yOffset = config.outerWallDistance.get(rand), zOffset = config.outerWallDistance.get(rand));
            BlockState state = worldIn.func_180495_p(crackPos);
            if ((state.func_196958_f() || state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150353_l) && ++threshold > config.invalidBlocksThreshold) {
                return false;
            }
            generationPoints.add(Pair.of((Object)crackPos, (Object)config.pointOffset.get(rand)));
        }
        if (generateCrack) {
            int crackType = rand.nextInt(4);
            int crackDistance = distributionPoints * 2 + 1;
            if (crackType == 0) {
                crackPoints.add(pos.func_177982_a(crackDistance, 7, 0));
                crackPoints.add(pos.func_177982_a(crackDistance, 5, 0));
                crackPoints.add(pos.func_177982_a(crackDistance, 1, 0));
            } else if (crackType == 1) {
                crackPoints.add(pos.func_177982_a(0, 7, crackDistance));
                crackPoints.add(pos.func_177982_a(0, 5, crackDistance));
                crackPoints.add(pos.func_177982_a(0, 1, crackDistance));
            } else if (crackType == 2) {
                crackPoints.add(pos.func_177982_a(crackDistance, 7, crackDistance));
                crackPoints.add(pos.func_177982_a(crackDistance, 5, crackDistance));
                crackPoints.add(pos.func_177982_a(crackDistance, 1, crackDistance));
            } else {
                crackPoints.add(pos.func_177982_a(0, 7, 0));
                crackPoints.add(pos.func_177982_a(0, 5, 0));
                crackPoints.add(pos.func_177982_a(0, 1, 0));
            }
        }
        ArrayList crystalPlacements = Lists.newArrayList();
        Iterator<BlockPos> positions = BlockPosUtils.betweenClosed(pos.func_177982_a(minGenOffset, minGenOffset, minGenOffset), pos.func_177982_a(maxGenOffset, maxGenOffset, maxGenOffset)).iterator();
        while (true) {
            if (!positions.hasNext()) {
                List<BlockState> innerPlacements = geodeBlockSettings.innerPlacements;
                block2: for (BlockPos placementPos : crystalPlacements) {
                    BlockState placementState = innerPlacements.get(rand.nextInt(innerPlacements.size()));
                    for (Direction direction : DIRECTIONS) {
                        if (placementState.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
                            placementState = (BlockState)placementState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction);
                        }
                        BlockPos offsettedPlacementPos = placementPos.func_177972_a(direction);
                        BlockState offsetState = worldIn.func_180495_p(offsettedPlacementPos);
                        if (placementState.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                            placementState = (BlockState)placementState.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(offsetState.func_204520_s().func_206889_d()));
                        }
                        if (!BuddingAmethystBlock.canClusterGrowAtState(offsetState)) continue;
                        worldIn.func_180501_a(offsettedPlacementPos, placementState, 2);
                        continue block2;
                    }
                }
                return true;
            }
            BlockPos currentPos = positions.next();
            double noiseValue = noiseMixer.getValue(currentPos.func_177958_n(), currentPos.func_177956_o(), currentPos.func_177952_p()) * config.noiseMultiplier;
            double generationDistance = 0.0;
            double crackDistance = 0.0;
            for (Pair generationPoint : generationPoints) {
                generationDistance += MathHelper.func_181161_i((double)(currentPos.func_177951_i((Vector3i)generationPoint.getFirst()) + (double)((Integer)generationPoint.getSecond()).intValue())) + noiseValue;
            }
            for (BlockPos crackPos : crackPoints) {
                crackDistance += MathHelper.func_181161_i((double)(currentPos.func_177951_i((Vector3i)crackPos) + (double)geodeCrackSettings.crackPointOffset)) + noiseValue;
            }
            if (generationDistance < outerLayer) continue;
            if (generateCrack && crackDistance >= crack && generationDistance < filling) {
                if (!worldIn.func_204610_c(currentPos).func_206888_e()) continue;
                worldIn.func_180501_a(currentPos, Blocks.field_150350_a.func_176223_P(), 2);
                continue;
            }
            if (generationDistance >= filling) {
                worldIn.func_180501_a(currentPos, geodeBlockSettings.fillingProvider.func_225574_a_(rand, currentPos), 2);
                continue;
            }
            if (generationDistance >= innerLayer) {
                boolean useAlternateInnerLayer;
                boolean bl = useAlternateInnerLayer = (double)rand.nextFloat() < config.useAlternateLayer0Chance;
                if (useAlternateInnerLayer) {
                    worldIn.func_180501_a(currentPos, geodeBlockSettings.alternateInnerLayerProvider.func_225574_a_(rand, currentPos), 2);
                } else {
                    worldIn.func_180501_a(currentPos, geodeBlockSettings.innerLayerProvider.func_225574_a_(rand, currentPos), 2);
                }
                if (config.placementsRequireLayer0Alternate && !useAlternateInnerLayer || !((double)rand.nextFloat() < config.usePotentialPlacementsChance)) continue;
                crystalPlacements.add(currentPos.func_185334_h());
                continue;
            }
            if (generationDistance >= middleLayer) {
                worldIn.func_180501_a(currentPos, geodeBlockSettings.middleLayerProvider.func_225574_a_(rand, currentPos), 2);
                continue;
            }
            if (!(generationDistance >= outerLayer)) continue;
            worldIn.func_180501_a(currentPos, geodeBlockSettings.outerLayerProvider.func_225574_a_(rand, currentPos), 2);
        }
    }
}

