/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.utils.math.ClampedNormalFloatProvider;
import com.blackgear.cavesandcliffs.common.world.gen.Column;
import com.blackgear.cavesandcliffs.common.world.gen.features.DripstoneUtils;
import com.blackgear.cavesandcliffs.common.world.gen.features.config.DripstoneClusterConfig;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;

public class DripstoneClusterFeature
extends Feature<DripstoneClusterConfig> {
    public DripstoneClusterFeature(Codec<DripstoneClusterConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, DripstoneClusterConfig config) {
        if (!DripstoneUtils.canGenerate((IWorld)worldIn, pos)) {
            return false;
        }
        int height = config.height.get(rand);
        float wetness = config.wetness.get(rand);
        float density = config.density.get(rand);
        int xRadius = config.radius.get(rand);
        int zRadius = config.radius.get(rand);
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                double chance = this.getChanceOfStalagmiteOrStalactite(xRadius, zRadius, x, z, config);
                BlockPos blockPos = pos.func_177982_a(x, 0, z);
                this.placeColumn((IWorld)worldIn, rand, blockPos, x, z, wetness, chance, height, density, config);
            }
        }
        return true;
    }

    private void placeColumn(IWorld worldIn, Random rand, BlockPos pos, int x, int z, float wetness, double chance, int height, float density, DripstoneClusterConfig config) {
        Optional<Column> optionalColumn = Column.scan((IWorldGenerationReader)worldIn, pos, config.floorToCeilingSearchRange, DripstoneUtils::canGenerate, DripstoneUtils::canReplaceOrLava);
        if (optionalColumn.isPresent()) {
            OptionalInt ceiling = optionalColumn.get().getCeiling();
            OptionalInt columnFloor = optionalColumn.get().getFloor();
            if (ceiling.isPresent() || columnFloor.isPresent()) {
                boolean shouldMerge;
                int stalagmiteThickness;
                int stalactiteThickness;
                boolean placeOnFloor;
                int dripstoneHeight;
                int dripstoneLayerThickness;
                boolean placeOnCeiling;
                Column column;
                boolean shouldPlacePool;
                boolean bl = shouldPlacePool = rand.nextFloat() < wetness;
                if (shouldPlacePool && columnFloor.isPresent() && this.canPlacePool(worldIn, BlockPosUtils.atY(pos, columnFloor.getAsInt()))) {
                    int floorHeight = columnFloor.getAsInt();
                    column = optionalColumn.get().withFloor(OptionalInt.of(floorHeight - 1));
                    worldIn.func_180501_a(BlockPosUtils.atY(pos, floorHeight), Blocks.field_150355_j.func_176223_P(), 2);
                } else {
                    column = optionalColumn.get();
                }
                OptionalInt floor = column.getFloor();
                boolean bl2 = placeOnCeiling = rand.nextDouble() < chance;
                if (ceiling.isPresent() && placeOnCeiling && !this.isLava(worldIn, BlockPosUtils.atY(pos, ceiling.getAsInt()))) {
                    dripstoneLayerThickness = config.dripstoneBlockLayerThickness.get(rand);
                    this.replaceBlocksWithDripstoneBlocks(worldIn, BlockPosUtils.atY(pos, ceiling.getAsInt()), dripstoneLayerThickness, Direction.UP);
                    int pillarLength = floor.isPresent() ? Math.min(height, ceiling.getAsInt() - floor.getAsInt()) : height;
                    dripstoneHeight = this.getDripstoneHeight(rand, x, z, density, pillarLength, config);
                } else {
                    dripstoneHeight = 0;
                }
                boolean bl3 = placeOnFloor = rand.nextDouble() < chance;
                if (floor.isPresent() && placeOnFloor && !this.isLava(worldIn, BlockPosUtils.atY(pos, floor.getAsInt()))) {
                    stalactiteThickness = config.dripstoneBlockLayerThickness.get(rand);
                    this.replaceBlocksWithDripstoneBlocks(worldIn, BlockPosUtils.atY(pos, floor.getAsInt()), stalactiteThickness, Direction.DOWN);
                    dripstoneLayerThickness = Math.max(0, dripstoneHeight + MathUtils.nextBetween(rand, -config.maxStalagmiteStalactiteHeightDiff, config.maxStalagmiteStalactiteHeightDiff));
                } else {
                    dripstoneLayerThickness = 0;
                }
                if (ceiling.isPresent() && floor.isPresent() && ceiling.getAsInt() - dripstoneHeight <= floor.getAsInt() + dripstoneLayerThickness) {
                    int floorY = floor.getAsInt();
                    int ceilingY = ceiling.getAsInt();
                    int minLength = Math.max(ceilingY - dripstoneHeight, floorY + 1);
                    int maxLength = Math.min(floorY + dripstoneLayerThickness, ceilingY - 1);
                    int DripstoneSizeRange = MathUtils.nextBetween(rand, minLength, maxLength + 1);
                    int DripstoneSize = DripstoneSizeRange - 1;
                    stalactiteThickness = ceilingY - DripstoneSizeRange;
                    stalagmiteThickness = DripstoneSize - floorY;
                } else {
                    stalactiteThickness = dripstoneHeight;
                    stalagmiteThickness = dripstoneLayerThickness;
                }
                boolean bl4 = shouldMerge = rand.nextBoolean() && stalactiteThickness > 0 && stalagmiteThickness > 0 && column.getHeight().isPresent() && stalactiteThickness + stalagmiteThickness == column.getHeight().getAsInt();
                if (ceiling.isPresent()) {
                    DripstoneUtils.generatePointedDripstone(worldIn, BlockPosUtils.atY(pos, ceiling.getAsInt() - 1), Direction.DOWN, stalactiteThickness, shouldMerge);
                }
                if (floor.isPresent()) {
                    DripstoneUtils.generatePointedDripstone(worldIn, BlockPosUtils.atY(pos, floor.getAsInt() + 1), Direction.UP, stalagmiteThickness, shouldMerge);
                }
            }
        }
    }

    private boolean isLava(IWorld worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150353_l;
    }

    private int getDripstoneHeight(Random rand, int x, int z, float density, int length, DripstoneClusterConfig config) {
        if (rand.nextFloat() > density) {
            return 0;
        }
        int radius = Math.abs(x) + Math.abs(z);
        float height = (float)MathUtils.clampedLerpFromProgress(radius, 0.0, config.maxDistanceFromCenterAffectingHeightBias, (double)length / 2.0, 0.0);
        return (int)DripstoneClusterFeature.randomBetweenBiased(rand, 0.0f, length, height, config.heightDeviation);
    }

    private boolean canPlacePool(IWorld worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() != Blocks.field_150355_j && state.func_177230_c() != CCBBlocks.DRIPSTONE_BLOCK.get() && state.func_177230_c() != CCBBlocks.POINTED_DRIPSTONE.get()) {
            Direction direction;
            Iterator directionIterator = Direction.Plane.HORIZONTAL.iterator();
            do {
                if (directionIterator.hasNext()) continue;
                return this.canBeAdjacentToWater(worldIn, pos.func_177977_b());
            } while (this.canBeAdjacentToWater(worldIn, pos.func_177972_a(direction = (Direction)directionIterator.next())));
        }
        return false;
    }

    private boolean canBeAdjacentToWater(IWorld worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        return state.func_235714_a_((ITag)BlockTags.field_242172_aH) || state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    private void replaceBlocksWithDripstoneBlocks(IWorld worldIn, BlockPos pos, int range, Direction direction) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int area = 0; area < range; ++area) {
            if (!DripstoneUtils.generateDripstoneBlock(worldIn, (BlockPos)mutable)) {
                return;
            }
            mutable.func_189536_c(direction);
        }
    }

    private double getChanceOfStalagmiteOrStalactite(int xRadius, int zRadius, int xIn, int zIn, DripstoneClusterConfig config) {
        int x = xRadius - Math.abs(xIn);
        int z = zRadius - Math.abs(zIn);
        int radius = Math.min(x, z);
        return MathUtils.clampedLerpFromProgress(radius, 0.0, config.maxDistanceFromEdgeAffectingChanceOfDripstoneColumn, config.chanceOfDripstoneColumnAtMaxDistanceFromCenter, 1.0);
    }

    private static float randomBetweenBiased(Random rand, float min, float max, float mean, float deviation) {
        return ClampedNormalFloatProvider.get(rand, mean, deviation, min, max);
    }
}

