/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.blocks.PointedDripstoneBlock;
import com.blackgear.cavesandcliffs.common.blocks.state.DripstoneThickness;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.tags.CCBBlockTags;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class DripstoneUtils {
    protected static double scaleHeightFromRadius(double radius, double scale, double heightScale, double bluntness) {
        if (radius < bluntness) {
            radius = bluntness;
        }
        double i = radius / scale * 0.384;
        double j = 0.75 * Math.pow(i, 1.3333333333333333);
        double k = Math.pow(i, 0.6666666666666666);
        double l = 0.3333333333333333 * Math.log(i);
        double m = heightScale * (j - k - l);
        m = Math.max(m, 0.0);
        return m / 0.384 * scale;
    }

    protected static boolean canGenerateBase(IWorld worldIn, BlockPos pos, int height) {
        if (DripstoneUtils.canGenerateOrLava(worldIn, pos)) {
            return false;
        }
        float radius = 6.0f / (float)height;
        for (float i = 0.0f; i < (float)Math.PI * 2; i += radius) {
            int z;
            int x = (int)(Math.cos(i) * (double)height);
            if (!DripstoneUtils.canGenerateOrLava(worldIn, pos.func_177982_a(x, 0, z = (int)(Math.sin(i) * (double)height)))) continue;
            return false;
        }
        return true;
    }

    protected static boolean canGenerate(IWorld worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, DripstoneUtils::canGenerate);
    }

    protected static boolean canGenerateOrLava(IWorld worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, DripstoneUtils::canGenerateOrLava);
    }

    protected static void getDripstoneThickness(Direction direction, int height, boolean merge, Consumer<BlockState> callback) {
        if (height >= 3) {
            callback.accept(DripstoneUtils.getState(direction, DripstoneThickness.BASE));
            for (int i = 0; i < height - 3; ++i) {
                callback.accept(DripstoneUtils.getState(direction, DripstoneThickness.MIDDLE));
            }
        }
        if (height >= 2) {
            callback.accept(DripstoneUtils.getState(direction, DripstoneThickness.FRUSTUM));
        }
        if (height >= 1) {
            callback.accept(DripstoneUtils.getState(direction, merge ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void generatePointedDripstone(IWorld worldIn, BlockPos pos, Direction direction, int height, boolean merge) {
        BlockPos.Mutable mutablePos = pos.func_239590_i_();
        DripstoneUtils.getDripstoneThickness(direction, height, merge, state -> {
            if (state.func_203425_a((Block)CCBBlocks.POINTED_DRIPSTONE.get())) {
                state = (BlockState)state.func_206870_a((Property)PointedDripstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.func_201671_F((BlockPos)mutablePos)));
            }
            worldIn.func_180501_a((BlockPos)mutablePos, state, 2);
            mutablePos.func_189536_c(direction);
        });
    }

    protected static boolean generateDripstoneBlock(IWorld worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_235714_a_(CCBBlockTags.DRIPSTONE_REPLACEABLE)) {
            worldIn.func_180501_a(pos, ((Block)CCBBlocks.DRIPSTONE_BLOCK.get()).func_176223_P(), 2);
            return true;
        }
        return false;
    }

    private static BlockState getState(Direction direction, DripstoneThickness thickness) {
        return (BlockState)((BlockState)((Block)CCBBlocks.POINTED_DRIPSTONE.get()).func_176223_P().func_206870_a((Property)PointedDripstoneBlock.TIP_DIRECTION, (Comparable)direction)).func_206870_a(PointedDripstoneBlock.THICKNESS, (Comparable)((Object)thickness));
    }

    public static boolean canReplaceOrLava(BlockState state) {
        return DripstoneUtils.canReplace(state) || state.func_203425_a(Blocks.field_150353_l);
    }

    public static boolean canReplace(BlockState state) {
        return state.func_203425_a((Block)CCBBlocks.DRIPSTONE_BLOCK.get()) || state.func_235714_a_(CCBBlockTags.DRIPSTONE_REPLACEABLE);
    }

    public static boolean canGenerate(BlockState state) {
        return state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j);
    }

    public static boolean canGenerateOrLava(BlockState state) {
        return state.func_196958_f() || state.func_203425_a(Blocks.field_150355_j) || state.func_203425_a(Blocks.field_150353_l);
    }
}

