/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.blocks.BuddingAmethystBlock;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeBlockSettings;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeCrackSettings;
import com.blackgear.cavesandcliffs.common.world.gen.GeodeLayerSettings;
import com.blackgear.cavesandcliffs.common.world.gen.MaxMinNoiseMixer;
import com.blackgear.cavesandcliffs.common.world.gen.features.config.GeodeConfig;
import com.blackgear.cavesandcliffs.core.registries.other.utils.Utils;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class GeodeFeature
extends Feature<GeodeConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public GeodeFeature(Codec<GeodeConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader structureWorldAccess, ChunkGenerator generator, Random random, BlockPos blockPos, GeodeConfig geodeFeatureConfig) {
        int s;
        int r;
        int i = geodeFeatureConfig.minGenOffset;
        int j = geodeFeatureConfig.maxGenOffset;
        LinkedList list = Lists.newLinkedList();
        int k = geodeFeatureConfig.distributionPoints.get(random);
        SharedSeedRandom chunkRandom = new SharedSeedRandom(structureWorldAccess.func_72905_C());
        MaxMinNoiseMixer doublePerlinNoiseSampler = MaxMinNoiseMixer.create(chunkRandom, -4, 1.0);
        LinkedList list2 = Lists.newLinkedList();
        double d = (double)k / (double)geodeFeatureConfig.outerWallDistance.getMax();
        GeodeLayerSettings geodeLayerThicknessConfig = geodeFeatureConfig.geodeLayerSettings;
        GeodeBlockSettings geodeLayerConfig = geodeFeatureConfig.geodeBlockSettings;
        GeodeCrackSettings geodeCrackConfig = geodeFeatureConfig.geodeCrackSettings;
        double e = 1.0 / Math.sqrt(geodeLayerThicknessConfig.filling);
        double f = 1.0 / Math.sqrt(geodeLayerThicknessConfig.innerLayer + d);
        double g = 1.0 / Math.sqrt(geodeLayerThicknessConfig.middleLayer + d);
        double h = 1.0 / Math.sqrt(geodeLayerThicknessConfig.outerLayer + d);
        double l = 1.0 / Math.sqrt(geodeCrackConfig.baseCrackSize + random.nextDouble() / 2.0 + (k > 3 ? d : 0.0));
        boolean bl = (double)random.nextFloat() < geodeCrackConfig.generateCrackChance;
        int m = 0;
        for (r = 0; r < k; ++r) {
            int q;
            int p;
            s = geodeFeatureConfig.outerWallDistance.get(random);
            BlockPos blockPos2 = blockPos.func_177982_a(s, p = geodeFeatureConfig.outerWallDistance.get(random), q = geodeFeatureConfig.outerWallDistance.get(random));
            BlockState blockState = structureWorldAccess.func_180495_p(blockPos2);
            if ((blockState.func_196958_f() || blockState.func_203425_a(Blocks.field_150355_j) || blockState.func_203425_a(Blocks.field_150353_l)) && ++m > geodeFeatureConfig.invalidBlocksThreshold) {
                return false;
            }
            list.add(Pair.of((Object)blockPos2, (Object)geodeFeatureConfig.pointOffset.get(random)));
        }
        if (bl) {
            r = random.nextInt(4);
            s = k * 2 + 1;
            if (r == 0) {
                list2.add(blockPos.func_177982_a(s, 7, 0));
                list2.add(blockPos.func_177982_a(s, 5, 0));
                list2.add(blockPos.func_177982_a(s, 1, 0));
            } else if (r == 1) {
                list2.add(blockPos.func_177982_a(0, 7, s));
                list2.add(blockPos.func_177982_a(0, 5, s));
                list2.add(blockPos.func_177982_a(0, 1, s));
            } else if (r == 2) {
                list2.add(blockPos.func_177982_a(s, 7, s));
                list2.add(blockPos.func_177982_a(s, 5, s));
                list2.add(blockPos.func_177982_a(s, 1, s));
            } else {
                list2.add(blockPos.func_177982_a(0, 7, 0));
                list2.add(blockPos.func_177982_a(0, 5, 0));
                list2.add(blockPos.func_177982_a(0, 1, 0));
            }
        }
        ArrayList list3 = Lists.newArrayList();
        Iterator var42 = BlockPos.func_218278_a((BlockPos)blockPos.func_177982_a(i, i, i), (BlockPos)blockPos.func_177982_a(j, j, j)).iterator();
        while (true) {
            if (!var42.hasNext()) {
                List<BlockState> list4 = geodeLayerConfig.innerPlacements;
                block2: for (BlockPos blockPos5 : list3) {
                    BlockState blockState2 = Utils.getRandom(list4, random);
                    for (Direction direction : DIRECTIONS) {
                        if (blockState2.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
                            blockState2 = (BlockState)blockState2.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction);
                        }
                        BlockPos blockPos6 = blockPos5.func_177972_a(direction);
                        BlockState blockState3 = structureWorldAccess.func_180495_p(blockPos6);
                        if (blockState2.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
                            blockState2 = (BlockState)blockState2.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(blockState3.func_204520_s().func_206889_d()));
                        }
                        if (!BuddingAmethystBlock.canClusterGrowAtState(blockState3)) continue;
                        structureWorldAccess.func_180501_a(blockPos6, blockState2, 2);
                        continue block2;
                    }
                }
                return true;
            }
            BlockPos blockPos3 = (BlockPos)var42.next();
            double t = doublePerlinNoiseSampler.getValue(blockPos3.func_177958_n(), blockPos3.func_177956_o(), blockPos3.func_177952_p()) * geodeFeatureConfig.noiseMultiplier;
            double u = 0.0;
            double v = 0.0;
            for (Pair pair : list) {
                u += MathHelper.func_181161_i((double)(blockPos3.func_177951_i((Vector3i)pair.getFirst()) + (double)((Integer)pair.getSecond()).intValue())) + t;
            }
            for (BlockPos blockPos4 : list2) {
                v += MathHelper.func_181161_i((double)(blockPos3.func_177951_i((Vector3i)blockPos4) + (double)geodeCrackConfig.crackPointOffset)) + t;
            }
            if (u < h) continue;
            if (bl && v >= l && u < e) {
                if (!structureWorldAccess.func_204610_c(blockPos3).func_206888_e()) continue;
                structureWorldAccess.func_180501_a(blockPos3, Blocks.field_150350_a.func_176223_P(), 2);
                continue;
            }
            if (u >= e) {
                structureWorldAccess.func_180501_a(blockPos3, geodeLayerConfig.fillingProvider.func_225574_a_(random, blockPos3), 2);
                continue;
            }
            if (u >= f) {
                boolean bl2;
                boolean bl3 = bl2 = (double)random.nextFloat() < geodeFeatureConfig.useAlternateLayer0Chance;
                if (bl2) {
                    structureWorldAccess.func_180501_a(blockPos3, geodeLayerConfig.alternateInnerLayerProvider.func_225574_a_(random, blockPos3), 2);
                } else {
                    structureWorldAccess.func_180501_a(blockPos3, geodeLayerConfig.innerLayerProvider.func_225574_a_(random, blockPos3), 2);
                }
                if (geodeFeatureConfig.placementsRequireLayer0Alternate && !bl2 || !((double)random.nextFloat() < geodeFeatureConfig.usePotentialPlacementsChance)) continue;
                list3.add(blockPos3.func_185334_h());
                continue;
            }
            if (u >= g) {
                structureWorldAccess.func_180501_a(blockPos3, geodeLayerConfig.middleLayerProvider.func_225574_a_(random, blockPos3), 2);
                continue;
            }
            if (!(u >= h)) continue;
            structureWorldAccess.func_180501_a(blockPos3, geodeLayerConfig.outerLayerProvider.func_225574_a_(random, blockPos3), 2);
        }
    }
}

