/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.world.gen.features.config.RootSystemConfig;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeature;

public class RootSystemFeature
extends Feature<RootSystemConfig> {
    public RootSystemFeature(Codec<RootSystemConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, RootSystemConfig config) {
        if (!worldIn.func_180495_p(pos).func_196958_f()) {
            return false;
        }
        BlockPos.Mutable blockPos = pos.func_239590_i_();
        if (this.placeDirtAndTree(worldIn, generator, config, rand, blockPos, pos)) {
            this.placeRoots((IWorld)worldIn, config, rand, pos, blockPos);
        }
        return true;
    }

    private boolean spaceForTree(IWorld worldIn, RootSystemConfig config, BlockPos pos) {
        BlockPos.Mutable blockPos = pos.func_239590_i_();
        for (int space = 0; space <= config.requiredVerticalSpaceForTree; ++space) {
            blockPos.func_189536_c(Direction.UP);
            if (worldIn.func_175623_d((BlockPos)blockPos) || worldIn.func_204610_c((BlockPos)blockPos).func_206884_a((ITag)FluidTags.field_206959_a)) continue;
            return false;
        }
        return true;
    }

    private boolean placeDirtAndTree(ISeedReader worldIn, ChunkGenerator generator, RootSystemConfig config, Random rand, BlockPos.Mutable blockPos, BlockPos pos) {
        int x = pos.func_177958_n();
        int z = pos.func_177952_p();
        for (int height = 0; height < config.rootColumnMaxHeight; ++height) {
            blockPos.func_189536_c(Direction.UP);
            if (this.validTreePos((IWorld)worldIn, (BlockPos)blockPos)) {
                if (!this.spaceForTree((IWorld)worldIn, config, (BlockPos)blockPos)) continue;
                BlockPos below = blockPos.func_177977_b();
                if (worldIn.func_204610_c(below).func_206884_a((ITag)FluidTags.field_206960_b) || !worldIn.func_180495_p(below).func_185904_a().func_76220_a()) {
                    return false;
                }
                if (!this.tryPlaceAzaleaTree(worldIn, generator, config, rand, (BlockPos)blockPos)) continue;
                return true;
            }
            this.placeRootedDirt((IWorld)worldIn, config, rand, x, z, blockPos);
        }
        return false;
    }

    private boolean tryPlaceAzaleaTree(ISeedReader worldIn, ChunkGenerator generator, RootSystemConfig config, Random rand, BlockPos pos) {
        return config.treeFeature.get().func_242765_a(worldIn, generator, rand, pos);
    }

    private void placeRootedDirt(IWorld worldIn, RootSystemConfig config, Random rand, int x, int z, BlockPos.Mutable pos) {
        int radius = config.rootRadius;
        ITag tag = BlockTags.func_199896_a().func_199910_a(config.rootReplaceable);
        Predicate<BlockState> statePredicate = tag == null ? state -> true : state -> state.func_235714_a_(tag);
        for (int attempts = 0; attempts < config.rootPlacementAttempts; ++attempts) {
            BlockPosUtils.setAndOffset(pos, (Vector3i)pos, rand.nextInt(radius) - rand.nextInt(radius), 0, rand.nextInt(radius) - rand.nextInt(radius));
            if (statePredicate.test(worldIn.func_180495_p((BlockPos)pos))) {
                worldIn.func_180501_a((BlockPos)pos, config.rootStateProvider.func_225574_a_(rand, (BlockPos)pos), 2);
            }
            pos.func_223471_o(x);
            pos.func_223472_q(z);
        }
    }

    private void placeRoots(IWorld worldIn, RootSystemConfig config, Random rand, BlockPos pos, BlockPos.Mutable blockPos) {
        int radius = config.rootRadius;
        int verticalSpan = config.hangingRootsVerticalSpan;
        for (int attempts = 0; attempts < config.hangingRootPlacementAttempts; ++attempts) {
            BlockPosUtils.setAndOffset(blockPos, (Vector3i)pos, rand.nextInt(radius) - rand.nextInt(radius), rand.nextInt(verticalSpan) - rand.nextInt(verticalSpan), rand.nextInt(radius) - rand.nextInt(radius));
            if (!worldIn.func_175623_d((BlockPos)blockPos) || !worldIn.func_180495_p(blockPos.func_177984_a()).func_185904_a().func_76220_a()) continue;
            worldIn.func_180501_a((BlockPos)blockPos, config.hangingRootStateProvider.func_225574_a_(rand, (BlockPos)blockPos), 2);
        }
    }

    private boolean validTreePos(IWorld worldIn, BlockPos pos) {
        return TreeFeature.func_236412_d_((IWorldGenerationBaseReader)worldIn, (BlockPos)pos) || TreeFeature.func_236404_a_((IWorldGenerationBaseReader)worldIn, (BlockPos)pos) || TreeFeature.func_236416_f_((IWorldGenerationBaseReader)worldIn, (BlockPos)pos);
    }
}

