/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.world.gen.features.DripstoneUtils;
import com.blackgear.cavesandcliffs.common.world.gen.features.config.SmallDripstoneConfig;
import com.blackgear.cavesandcliffs.core.registries.other.utils.MathUtils;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class SmallDripstoneFeature
extends Feature<SmallDripstoneConfig> {
    public SmallDripstoneFeature(Codec<SmallDripstoneConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, SmallDripstoneConfig config) {
        if (!DripstoneUtils.canGenerate((IWorld)worldIn, pos)) {
            return false;
        }
        int placements = MathUtils.nextBetween(rand, 1, config.maxPlacements);
        boolean shouldPlace = false;
        for (int index = 0; index < placements; ++index) {
            BlockPos offset = SmallDripstoneFeature.randomPos(rand, pos, config);
            if (!SmallDripstoneFeature.searchAndTryToPlaceDripstone((IWorld)worldIn, rand, offset, config)) continue;
            shouldPlace = true;
        }
        return shouldPlace;
    }

    private static boolean searchAndTryToPlaceDripstone(IWorld worldIn, Random rand, BlockPos pos, SmallDripstoneConfig config) {
        Direction randomDirection = Direction.func_239631_a_((Random)rand);
        Direction facingDirection = rand.nextBoolean() ? Direction.UP : Direction.DOWN;
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int index = 0; index < config.emptySpaceSearchRadius; ++index) {
            if (!DripstoneUtils.canGenerate(worldIn, (BlockPos)mutable)) {
                return false;
            }
            if (SmallDripstoneFeature.generateDripstone(worldIn, rand, (BlockPos)mutable, facingDirection, config)) {
                return true;
            }
            if (SmallDripstoneFeature.generateDripstone(worldIn, rand, (BlockPos)mutable, facingDirection.func_176734_d(), config)) {
                return true;
            }
            mutable.func_189536_c(randomDirection);
        }
        return false;
    }

    private static boolean generateDripstone(IWorld worldIn, Random rand, BlockPos pos, Direction direction, SmallDripstoneConfig config) {
        if (!DripstoneUtils.canGenerate(worldIn, pos)) {
            return false;
        }
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState state = worldIn.func_180495_p(blockPos);
        if (!DripstoneUtils.canReplace(state)) {
            return false;
        }
        SmallDripstoneFeature.createPatchOfDripstoneBlocks(worldIn, rand, blockPos);
        int height = rand.nextFloat() < config.chanceOfTallerDripstone && DripstoneUtils.canGenerate(worldIn, pos.func_177972_a(direction)) ? 2 : 1;
        DripstoneUtils.generatePointedDripstone(worldIn, pos, direction, height, false);
        return true;
    }

    private static void createPatchOfDripstoneBlocks(IWorld worldIn, Random rand, BlockPos pos) {
        DripstoneUtils.generateDripstoneBlock(worldIn, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (rand.nextFloat() < 0.3f) continue;
            BlockPos firstPos = pos.func_177972_a(direction);
            DripstoneUtils.generateDripstoneBlock(worldIn, firstPos);
            if (rand.nextBoolean()) continue;
            BlockPos secondPos = firstPos.func_177972_a(Direction.func_239631_a_((Random)rand));
            DripstoneUtils.generateDripstoneBlock(worldIn, secondPos);
            if (rand.nextBoolean()) continue;
            BlockPos thirdPos = secondPos.func_177972_a(Direction.func_239631_a_((Random)rand));
            DripstoneUtils.generateDripstoneBlock(worldIn, thirdPos);
        }
    }

    private static BlockPos randomPos(Random rand, BlockPos pos, SmallDripstoneConfig config) {
        return pos.func_177982_a(MathUtils.nextBetween(rand, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin), MathUtils.nextBetween(rand, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin), MathUtils.nextBetween(rand, -config.maxOffsetFromOrigin, config.maxOffsetFromOrigin));
    }
}

