/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features;

import com.blackgear.cavesandcliffs.common.world.gen.features.config.VegetationPatchConfig;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;

public class VegetationPatchFeature
extends Feature<VegetationPatchConfig> {
    public VegetationPatchFeature(Codec<VegetationPatchConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, VegetationPatchConfig config) {
        Predicate<BlockState> replaceableTags = VegetationPatchFeature.getReplaceableTag(config);
        int xRadius = config.xzRadius.get(rand) + 1;
        int zRadius = config.xzRadius.get(rand) + 1;
        Set<BlockPos> groundPatch = this.placeGroundPatch((IWorld)worldIn, config, rand, pos, replaceableTags, xRadius, zRadius);
        this.distributeVegetation(generator, worldIn, config, rand, groundPatch, xRadius, zRadius);
        return !groundPatch.isEmpty();
    }

    protected Set<BlockPos> placeGroundPatch(IWorld worldIn, VegetationPatchConfig configIn, Random rand, BlockPos pos, Predicate<BlockState> statePredicate, int xIn, int zIn) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        BlockPos.Mutable mutated = mutable.func_239590_i_();
        Direction surfaceDirection = configIn.surface.getDirection();
        Direction oppositeSurface = surfaceDirection.func_176734_d();
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int x = -xIn; x <= xIn; ++x) {
            boolean inXRange = x == -xIn || x == xIn;
            for (int z = -zIn; z <= zIn; ++z) {
                int y;
                boolean inSingleRange;
                boolean inZRange = z == -zIn || z == zIn;
                boolean inAnyRange = inXRange || inZRange;
                boolean inTotalRange = inXRange && inZRange;
                boolean bl = inSingleRange = inAnyRange && !inTotalRange;
                if (inTotalRange || inSingleRange && (configIn.extraEdgeColumnChance == 0.0f || !(rand.nextFloat() <= configIn.extraEdgeColumnChance))) continue;
                BlockPosUtils.setAndOffset(mutable, (Vector3i)pos, x, 0, z);
                for (y = 0; worldIn.func_217375_a((BlockPos)mutable, AbstractBlock.AbstractBlockState::func_196958_f) && y < configIn.verticalRange; ++y) {
                    mutable.func_189536_c(surfaceDirection);
                }
                for (y = 0; worldIn.func_217375_a((BlockPos)mutable, state -> !state.func_196958_f()) && y < configIn.verticalRange; ++y) {
                    mutable.func_189536_c(oppositeSurface);
                }
                BlockPosUtils.setAndOffset(mutated, (Vector3i)mutable, configIn.surface.getDirection());
                BlockState state2 = worldIn.func_180495_p((BlockPos)mutated);
                if (!worldIn.func_175623_d((BlockPos)mutable) || !state2.func_224755_d((IBlockReader)worldIn, (BlockPos)mutated, configIn.surface.getDirection().func_176734_d())) continue;
                int depth = configIn.depth.get(rand) + (configIn.extraBottomBlockChance > 0.0f && rand.nextFloat() < configIn.extraBottomBlockChance ? 1 : 0);
                BlockPos immutable = mutated.func_185334_h();
                boolean canPlaceOnGround = this.placeGround(worldIn, configIn, statePredicate, rand, mutated, depth);
                if (!canPlaceOnGround) continue;
                positions.add(immutable);
            }
        }
        return positions;
    }

    protected void distributeVegetation(ChunkGenerator generator, ISeedReader worldIn, VegetationPatchConfig configIn, Random rand, Set<BlockPos> positions, int x, int z) {
        for (BlockPos pos : positions) {
            if (!(configIn.vegetationChance > 0.0f) || !(rand.nextFloat() < configIn.vegetationChance)) continue;
            this.placeVegetation(worldIn, configIn, generator, rand, pos);
        }
    }

    protected boolean placeVegetation(ISeedReader worldIn, VegetationPatchConfig configIn, ChunkGenerator generator, Random rand, BlockPos pos) {
        return configIn.vegetationFeature.get().func_242765_a(worldIn, generator, rand, pos.func_177972_a(configIn.surface.getDirection().func_176734_d()));
    }

    protected boolean placeGround(IWorld worldIn, VegetationPatchConfig configIn, Predicate<BlockState> statePredicate, Random rand, BlockPos.Mutable pos, int height) {
        for (int y = 0; y < height; ++y) {
            if (!statePredicate.test(worldIn.func_180495_p((BlockPos)pos))) {
                return y != 0;
            }
            worldIn.func_180501_a((BlockPos)pos, configIn.groundState.func_225574_a_(rand, (BlockPos)pos), 2);
            pos.func_189536_c(configIn.surface.getDirection());
        }
        return true;
    }

    private static Predicate<BlockState> getReplaceableTag(VegetationPatchConfig configIn) {
        ITag tag = BlockTags.func_199896_a().func_199910_a(configIn.replaceable);
        return tag == null ? block -> true : block -> block.func_235714_a_(tag);
    }
}

