/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features.structure;

import com.blackgear.cavesandcliffs.common.world.gen.features.structure.CCBStructurePiece;
import com.blackgear.cavesandcliffs.common.world.gen.features.structure.MineshaftStructure;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.api.util.HeightLimitReader;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.RailBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.ChestMinecartEntity;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.RailShape;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MineshaftPieces {
    private static Piece createRandomShaftPiece(List<StructurePiece> pieces, Random rand, int x, int y, int z, @Nullable Direction direction, int chainLength, MineshaftStructure.Type type) {
        int chance = rand.nextInt(100);
        if (chance >= 80) {
            MutableBoundingBox boundingBox = Cross.findCrossing(pieces, rand, x, y, z, direction);
            if (boundingBox != null) {
                return new Cross(chainLength, boundingBox, direction, type);
            }
        } else if (chance >= 70) {
            MutableBoundingBox boundingBox = Stairs.findStairs(pieces, rand, x, y, z, direction);
            if (boundingBox != null) {
                return new Stairs(chainLength, boundingBox, direction, type);
            }
        } else {
            MutableBoundingBox boundingBox = Corridor.findCorridorSize(pieces, rand, x, y, z, direction);
            if (boundingBox != null) {
                return new Corridor(chainLength, rand, boundingBox, direction, type);
            }
        }
        return null;
    }

    private static Piece generateAndAddPiece(StructurePiece start, List<StructurePiece> pieces, Random rand, int x, int y, int z, Direction direction, int chainLength) {
        if (chainLength > 8) {
            return null;
        }
        if (Math.abs(x - start.func_74874_b().field_78897_a) <= 80 && Math.abs(z - start.func_74874_b().field_78896_c) <= 80) {
            MineshaftStructure.Type type = ((Piece)start).mineShaftType;
            Piece piece = MineshaftPieces.createRandomShaftPiece(pieces, rand, x, y, z, direction, chainLength + 1, type);
            if (piece != null) {
                pieces.add(piece);
                piece.func_74861_a(start, pieces, rand);
            }
            return piece;
        }
        return null;
    }

    static abstract class Piece
    extends CCBStructurePiece {
        protected MineshaftStructure.Type mineShaftType;

        public Piece(IStructurePieceType structurePieceTypeIn, int componentTypeIn, MineshaftStructure.Type typeIn) {
            super(structurePieceTypeIn, componentTypeIn);
            this.mineShaftType = typeIn;
        }

        public Piece(IStructurePieceType structurePieceTypeIn, CompoundNBT nbt) {
            super(structurePieceTypeIn, nbt);
            this.mineShaftType = MineshaftStructure.Type.byId(nbt.func_74762_e("MST"));
        }

        @Override
        protected boolean canAddBlock(ISeedReader worldIn, int x, int y, int z, MutableBoundingBox boundingBox) {
            BlockState state = this.func_175807_a((IBlockReader)worldIn, x, y, z, boundingBox);
            return !state.func_203425_a(this.mineShaftType.getPlanks().func_177230_c()) && !state.func_203425_a(this.mineShaftType.getLog().func_177230_c()) && !state.func_203425_a(this.mineShaftType.getFence().func_177230_c()) && !state.func_203425_a(Blocks.field_235341_dI_);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            tagCompound.func_74768_a("MST", this.mineShaftType.ordinal());
        }

        protected boolean isSupportingBox(IBlockReader blockReaderIn, MutableBoundingBox boundsIn, int xStartIn, int xEndIn, int p_189918_5_, int zIn) {
            for (int i = xStartIn; i <= xEndIn; ++i) {
                if (!this.func_175807_a(blockReaderIn, i, p_189918_5_ + 1, zIn, boundsIn).func_196958_f()) continue;
                return false;
            }
            return true;
        }

        protected void setPlanksBlock(ISeedReader world, MutableBoundingBox boundingBox, BlockState state, int x, int y, int z) {
            BlockPos.Mutable pos;
            BlockState blockState;
            if (this.func_189916_b((IWorldReader)world, x, y, z, boundingBox) && ((blockState = world.func_180495_p((BlockPos)(pos = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z))))).func_196958_f() || blockState.func_203425_a(Blocks.field_235341_dI_))) {
                world.func_180501_a((BlockPos)pos, state, 2);
            }
        }
    }

    public static class Room
    extends Piece {
        private final List<MutableBoundingBox> connectedRooms = Lists.newLinkedList();

        public Room(int chainLength, Random rand, int x, int z, MineshaftStructure.Type typeIn) {
            super(IStructurePieceType.field_214782_c, chainLength, typeIn);
            this.mineShaftType = typeIn;
            this.field_74887_e = new MutableBoundingBox(x, 50, z, x + 7 + rand.nextInt(6), 54 + rand.nextInt(6), z + 7 + rand.nextInt(6));
        }

        public Room(TemplateManager templateManagerIn, CompoundNBT compound) {
            super(IStructurePieceType.field_214782_c, compound);
            ListNBT listnbt = compound.func_150295_c("Entrances", 11);
            for (int i = 0; i < listnbt.size(); ++i) {
                this.connectedRooms.add(new MutableBoundingBox(listnbt.func_150306_c(i)));
            }
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            MutableBoundingBox boundingBox;
            Piece piece;
            int width;
            int chainLength = this.func_74877_c();
            int height = this.field_74887_e.func_78882_c() - 3 - 1;
            if (height <= 0) {
                height = 1;
            }
            for (width = 0; width < this.field_74887_e.func_78883_b() && (width += rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); width += 4) {
                piece = MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + width, this.field_74887_e.field_78895_b + rand.nextInt(height) + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                if (piece == null) continue;
                boundingBox = piece.func_74874_b();
                this.connectedRooms.add(new MutableBoundingBox(boundingBox.field_78897_a, boundingBox.field_78895_b, this.field_74887_e.field_78896_c, boundingBox.field_78893_d, boundingBox.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (width = 0; width < this.field_74887_e.func_78883_b() && (width += rand.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); width += 4) {
                piece = MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a + width, this.field_74887_e.field_78895_b + rand.nextInt(height) + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                if (piece == null) continue;
                boundingBox = piece.func_74874_b();
                this.connectedRooms.add(new MutableBoundingBox(boundingBox.field_78897_a, boundingBox.field_78895_b, this.field_74887_e.field_78892_f - 1, boundingBox.field_78893_d, boundingBox.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (width = 0; width < this.field_74887_e.func_78880_d() && (width += rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); width += 4) {
                piece = MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + rand.nextInt(height) + 1, this.field_74887_e.field_78896_c + width, Direction.WEST, chainLength);
                if (piece == null) continue;
                boundingBox = piece.func_74874_b();
                this.connectedRooms.add(new MutableBoundingBox(this.field_74887_e.field_78897_a, boundingBox.field_78895_b, boundingBox.field_78896_c, this.field_74887_e.field_78897_a + 1, boundingBox.field_78894_e, boundingBox.field_78892_f));
            }
            for (width = 0; width < this.field_74887_e.func_78880_d() && (width += rand.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); width += 4) {
                piece = MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + rand.nextInt(height) + 1, this.field_74887_e.field_78896_c + width, Direction.EAST, chainLength);
                if (piece == null) continue;
                boundingBox = piece.func_74874_b();
                this.connectedRooms.add(new MutableBoundingBox(this.field_74887_e.field_78893_d - 1, boundingBox.field_78895_b, boundingBox.field_78896_c, this.field_74887_e.field_78893_d, boundingBox.field_78894_e, boundingBox.field_78892_f));
            }
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structure, ChunkGenerator generator, Random rand, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
            if (this.func_74860_a((IBlockReader)world, boundingBox)) {
                return false;
            }
            this.func_175804_a(world, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, Blocks.field_150346_d.func_176223_P(), field_202556_l, true);
            this.func_175804_a(world, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
            for (MutableBoundingBox mutableBoundingBox : this.connectedRooms) {
                this.func_175804_a(world, boundingBox, mutableBoundingBox.field_78897_a, mutableBoundingBox.field_78894_e - 2, mutableBoundingBox.field_78896_c, mutableBoundingBox.field_78893_d, mutableBoundingBox.field_78894_e, mutableBoundingBox.field_78892_f, field_202556_l, field_202556_l, false);
            }
            this.func_180777_a(world, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, false);
            return true;
        }

        public void func_181138_a(int x, int y, int z) {
            super.func_181138_a(x, y, z);
            for (MutableBoundingBox mutableboundingbox : this.connectedRooms) {
                mutableboundingbox.func_78886_a(x, y, z);
            }
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            ListNBT listnbt = new ListNBT();
            for (MutableBoundingBox mutableboundingbox : this.connectedRooms) {
                listnbt.add((Object)mutableboundingbox.func_151535_h());
            }
            tagCompound.func_218657_a("Entrances", (INBT)listnbt);
        }
    }

    public static class Corridor
    extends Piece {
        private final boolean hasRails;
        private final boolean hasSpiders;
        private boolean spawnerPlaced;
        private final int sectionCount;

        public Corridor(TemplateManager template, CompoundNBT compound) {
            super(IStructurePieceType.field_214780_a, compound);
            this.hasRails = compound.func_74767_n("hr");
            this.hasSpiders = compound.func_74767_n("sc");
            this.spawnerPlaced = compound.func_74767_n("hps");
            this.sectionCount = compound.func_74762_e("Num");
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("hr", this.hasRails);
            tagCompound.func_74757_a("sc", this.hasSpiders);
            tagCompound.func_74757_a("hps", this.spawnerPlaced);
            tagCompound.func_74768_a("Num", this.sectionCount);
        }

        public Corridor(int chainLength, Random rand, MutableBoundingBox boundingBox, Direction direction, MineshaftStructure.Type type) {
            super(IStructurePieceType.field_214780_a, chainLength, type);
            this.func_186164_a(direction);
            this.field_74887_e = boundingBox;
            this.hasRails = rand.nextInt(3) == 0;
            this.hasSpiders = !this.hasRails && rand.nextInt(23) == 0;
            this.sectionCount = this.func_186165_e().func_176740_k() == Direction.Axis.Z ? boundingBox.func_78880_d() / 5 : boundingBox.func_78883_b() / 5;
        }

        public static MutableBoundingBox findCorridorSize(List<StructurePiece> pieces, Random rand, int x, int y, int z, Direction direction) {
            for (int i = rand.nextInt(3) + 2; i > 0; --i) {
                MutableBoundingBox boundingBox;
                int j = i * 5;
                switch (direction) {
                    default: {
                        boundingBox = new MutableBoundingBox(0, 0, -(j - 1), 2, 2, 0);
                        break;
                    }
                    case SOUTH: {
                        boundingBox = new MutableBoundingBox(0, 0, 0, 2, 2, j - 1);
                        break;
                    }
                    case WEST: {
                        boundingBox = new MutableBoundingBox(-(j - 1), 0, 0, 0, 2, 2);
                        break;
                    }
                    case EAST: {
                        boundingBox = new MutableBoundingBox(0, 0, 0, j - 1, 2, 2);
                    }
                }
                boundingBox.func_78886_a(x, y, z);
                if (StructurePiece.func_74883_a(pieces, (MutableBoundingBox)boundingBox) != null) continue;
                return boundingBox;
            }
            return null;
        }

        public void func_74861_a(StructurePiece componentIn, List<StructurePiece> listIn, Random rand) {
            block24: {
                int chainLength = this.func_74877_c();
                int chance = rand.nextInt(4);
                Direction direction = this.func_186165_e();
                if (direction != null) {
                    switch (direction) {
                        default: {
                            if (chance <= 1) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, direction, chainLength);
                                break;
                            }
                            if (chance == 2) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.WEST, chainLength);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, Direction.EAST, chainLength);
                            break;
                        }
                        case SOUTH: {
                            if (chance <= 1) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, direction, chainLength);
                                break;
                            }
                            if (chance == 2) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.WEST, chainLength);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f - 3, Direction.EAST, chainLength);
                            break;
                        }
                        case WEST: {
                            if (chance <= 1) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, direction, chainLength);
                                break;
                            }
                            if (chance == 2) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                            break;
                        }
                        case EAST: {
                            if (chance <= 1) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c, direction, chainLength);
                                break;
                            }
                            if (chance == 2) {
                                MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                                break;
                            }
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + rand.nextInt(3), this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                        }
                    }
                }
                if (chainLength >= 8) break block24;
                if (direction != Direction.NORTH && direction != Direction.SOUTH) {
                    int y = this.field_74887_e.field_78897_a + 3;
                    while (y + 3 <= this.field_74887_e.field_78893_d) {
                        int chainChance = rand.nextInt(5);
                        if (chainChance == 0) {
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, y, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength + 1);
                        } else if (chainChance == 1) {
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, y, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength + 1);
                        }
                        y += 5;
                    }
                } else {
                    int y = this.field_74887_e.field_78896_c + 3;
                    while (y + 3 <= this.field_74887_e.field_78892_f) {
                        int chainChance = rand.nextInt(5);
                        if (chainChance == 0) {
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, y, Direction.WEST, chainLength + 1);
                        } else if (chainChance == 1) {
                            MineshaftPieces.generateAndAddPiece(componentIn, listIn, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, y, Direction.EAST, chainLength + 1);
                        }
                        y += 5;
                    }
                }
            }
        }

        protected boolean func_186167_a(ISeedReader worldIn, MutableBoundingBox boundingBox, Random randomIn, int x, int y, int z, ResourceLocation loot) {
            BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (boundingBox.func_175898_b((Vector3i)pos) && worldIn.func_180495_p(pos).func_196958_f() && !worldIn.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                BlockState blockstate = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)(randomIn.nextBoolean() ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST));
                this.func_175811_a(worldIn, blockstate, x, y, z, boundingBox);
                ChestMinecartEntity minecart = new ChestMinecartEntity((World)worldIn.func_201672_e(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                minecart.func_184289_a(loot, randomIn.nextLong());
                worldIn.func_217376_c((Entity)minecart);
                return true;
            }
            return false;
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structure, ChunkGenerator generator, Random rand, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
            int z;
            int x;
            if (this.func_74860_a((IBlockReader)world, boundingBox)) {
                return false;
            }
            int length = this.sectionCount * 5 - 1;
            BlockState state = this.mineShaftType.getPlanks();
            this.func_175804_a(world, boundingBox, 0, 0, 0, 2, 1, length, field_202556_l, field_202556_l, false);
            this.func_189914_a(world, boundingBox, rand, 0.8f, 0, 2, 0, 2, 2, length, field_202556_l, field_202556_l, false, false);
            if (this.hasSpiders) {
                this.func_189914_a(world, boundingBox, rand, 0.6f, 0, 0, 0, 2, 1, length, Blocks.field_196553_aF.func_176223_P(), field_202556_l, false, true);
            }
            for (x = 0; x < this.sectionCount; ++x) {
                int zIn;
                z = 2 + x * 5;
                this.placeSupport(world, boundingBox, 0, 0, z, 2, 2, rand);
                this.placeCobWeb(world, boundingBox, rand, 0.1f, 0, 2, z - 1);
                this.placeCobWeb(world, boundingBox, rand, 0.1f, 2, 2, z - 1);
                this.placeCobWeb(world, boundingBox, rand, 0.1f, 0, 2, z + 1);
                this.placeCobWeb(world, boundingBox, rand, 0.1f, 2, 2, z + 1);
                this.placeCobWeb(world, boundingBox, rand, 0.05f, 0, 2, z - 2);
                this.placeCobWeb(world, boundingBox, rand, 0.05f, 2, 2, z - 2);
                this.placeCobWeb(world, boundingBox, rand, 0.05f, 0, 2, z + 2);
                this.placeCobWeb(world, boundingBox, rand, 0.05f, 2, 2, z + 2);
                if (rand.nextInt(100) == 0) {
                    this.func_186167_a(world, boundingBox, rand, 2, 0, z - 1, LootTables.field_186424_f);
                }
                if (rand.nextInt(100) == 0) {
                    this.func_186167_a(world, boundingBox, rand, 0, 0, z + 1, LootTables.field_186424_f);
                }
                if (!this.hasSpiders || this.spawnerPlaced) continue;
                int yIn = this.func_74862_a(0);
                int offset = z - 1 + rand.nextInt(3);
                int xIn = this.func_74865_a(1, offset);
                BlockPos blockpos = new BlockPos(xIn, yIn, zIn = this.func_74873_b(1, offset));
                if (!boundingBox.func_175898_b((Vector3i)blockpos) || !this.func_189916_b((IWorldReader)world, 1, 0, offset, boundingBox)) continue;
                this.spawnerPlaced = true;
                world.func_180501_a(blockpos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileEntity = world.func_175625_s(blockpos);
                if (!(tileEntity instanceof MobSpawnerTileEntity)) continue;
                ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(EntityType.field_200794_h);
            }
            for (x = 0; x <= 2; ++x) {
                for (z = 0; z <= length; ++z) {
                    this.setPlanksBlock(world, boundingBox, state, x, -1, z);
                }
            }
            this.fillSupportBeam(world, boundingBox, 0, -1, 2);
            if (this.sectionCount > 1) {
                z = length - 2;
                this.fillSupportBeam(world, boundingBox, 0, -1, z);
            }
            if (this.hasRails) {
                BlockState railState = (BlockState)Blocks.field_150448_aq.func_176223_P().func_206870_a((Property)RailBlock.field_176565_b, (Comparable)RailShape.NORTH_SOUTH);
                for (int zIn = 0; zIn <= length; ++zIn) {
                    BlockState posState = this.func_175807_a((IBlockReader)world, 1, -1, zIn, boundingBox);
                    if (posState.func_196958_f() || !posState.func_200015_d((IBlockReader)world, new BlockPos(this.func_74865_a(1, zIn), this.func_74862_a(-1), this.func_74873_b(1, zIn)))) continue;
                    float chance = this.func_189916_b((IWorldReader)world, 1, 0, zIn, boundingBox) ? 0.7f : 0.9f;
                    this.func_175809_a(world, boundingBox, rand, chance, 1, 0, zIn, railState);
                }
            }
            return true;
        }

        private void fillSupportBeam(ISeedReader world, MutableBoundingBox boundingBox, int x, int y, int z) {
            BlockState logState = this.mineShaftType.getLog();
            BlockState plankState = this.mineShaftType.getPlanks();
            if (this.func_175807_a((IBlockReader)world, x, y, z, boundingBox).func_203425_a(plankState.func_177230_c())) {
                this.fillPillarDownOrChainUp(world, logState, x, y, z, boundingBox);
            }
            if (this.func_175807_a((IBlockReader)world, x + 2, y, z, boundingBox).func_203425_a(plankState.func_177230_c())) {
                this.fillPillarDownOrChainUp(world, logState, x + 2, y, z, boundingBox);
            }
        }

        protected void func_175808_b(ISeedReader world, BlockState state, int x, int y, int z, MutableBoundingBox boundingBox) {
            BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (boundingBox.func_175898_b((Vector3i)mutable)) {
                int height = mutable.func_177956_o();
                while (this.canReplace(world.func_180495_p((BlockPos)mutable)) && mutable.func_177956_o() > HeightLimitReader.getBottomY() + 1) {
                    mutable.func_189536_c(Direction.DOWN);
                }
                if (this.isNotRailOrLava(world.func_180495_p((BlockPos)mutable))) {
                    while (mutable.func_177956_o() < height) {
                        mutable.func_189536_c(Direction.UP);
                        world.func_180501_a((BlockPos)mutable, state, 3);
                    }
                }
            }
        }

        protected void fillPillarDownOrChainUp(ISeedReader world, BlockState state, int x, int y, int z, MutableBoundingBox boundingBox) {
            BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (boundingBox.func_175898_b((Vector3i)mutable)) {
                int height = mutable.func_177956_o();
                int length = 1;
                boolean canPlacePillars = true;
                boolean canPlaceChains = true;
                while (canPlaceChains || canPlacePillars) {
                    boolean canReplace;
                    BlockState blockState;
                    if (canPlacePillars) {
                        mutable.func_185336_p(height - length);
                        blockState = world.func_180495_p((BlockPos)mutable);
                        boolean bl = canReplace = this.canReplace(blockState) && !blockState.func_203425_a(Blocks.field_150353_l);
                        if (!canReplace && this.isNotRailOrLava(blockState)) {
                            Corridor.fillColumnBetween(world, state, mutable, height - length + 1, height);
                            return;
                        }
                        boolean bl2 = canPlacePillars = length <= 20 && canReplace && mutable.func_177956_o() > HeightLimitReader.getBottomY() + 1;
                    }
                    if (canPlaceChains) {
                        mutable.func_185336_p(height + length);
                        blockState = world.func_180495_p((BlockPos)mutable);
                        canReplace = this.canReplace(blockState);
                        if (!canReplace && this.canHangChainBelow((IWorldReader)world, (BlockPos)mutable, blockState)) {
                            world.func_180501_a((BlockPos)Corridor.setY(mutable, height + 1), this.mineShaftType.getFence(), 2);
                            Corridor.fillColumnBetween(world, Blocks.field_235341_dI_.func_176223_P(), mutable, height + 2, height + length);
                            return;
                        }
                        canPlaceChains = length <= 50 && canReplace && mutable.func_177956_o() < HeightLimitReader.getTopY() - 1;
                    }
                    ++length;
                }
            }
        }

        private boolean canReplace(BlockState state) {
            return state.func_196958_f() || state.func_185904_a().func_76224_d() || state.func_203425_a((Block)CCBBlocks.GLOW_LICHEN.get()) || state.func_203425_a(Blocks.field_203198_aQ) || state.func_203425_a(Blocks.field_203199_aR);
        }

        private static BlockPos.Mutable setY(BlockPos.Mutable pos, int y) {
            pos.func_185336_p(y);
            return pos;
        }

        private static void fillColumnBetween(ISeedReader worldIn, BlockState state, BlockPos.Mutable pos, int x, int z) {
            for (int y = x; y < z; ++y) {
                worldIn.func_180501_a((BlockPos)Corridor.setY(pos, y), state, 2);
            }
        }

        private boolean isNotRailOrLava(BlockState state) {
            return !state.func_203425_a(Blocks.field_150448_aq) && !state.func_203425_a(Blocks.field_150353_l);
        }

        private boolean canHangChainBelow(IWorldReader world, BlockPos pos, BlockState state) {
            return Block.func_220055_a((IWorldReader)world, (BlockPos)pos, (Direction)Direction.DOWN) && !(state.func_177230_c() instanceof FallingBlock);
        }

        private void placeSupport(ISeedReader world, MutableBoundingBox boundingBox, int minX, int minY, int z, int maxY, int maxX, Random rand) {
            if (this.isSupportingBox((IBlockReader)world, boundingBox, minX, maxX, maxY, z)) {
                BlockState plankState = this.mineShaftType.getPlanks();
                BlockState fenceState = this.mineShaftType.getFence();
                this.func_175804_a(world, boundingBox, minX, minY, z, minX, maxY - 1, z, (BlockState)fenceState.func_206870_a((Property)FenceBlock.field_196414_y, (Comparable)Boolean.valueOf(true)), field_202556_l, false);
                this.func_175804_a(world, boundingBox, maxX, minY, z, maxX, maxY - 1, z, (BlockState)fenceState.func_206870_a((Property)FenceBlock.field_196411_b, (Comparable)Boolean.valueOf(true)), field_202556_l, false);
                if (rand.nextInt(4) == 0) {
                    this.func_175804_a(world, boundingBox, minX, maxY, z, minX, maxY, z, plankState, field_202556_l, false);
                    this.func_175804_a(world, boundingBox, maxX, maxY, z, maxX, maxY, z, plankState, field_202556_l, false);
                } else {
                    this.func_175804_a(world, boundingBox, minX, maxY, z, maxX, maxY, z, plankState, field_202556_l, false);
                    this.func_175809_a(world, boundingBox, rand, 0.05f, minX + 1, maxY, z - 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH));
                    this.func_175809_a(world, boundingBox, rand, 0.05f, minX + 1, maxY, z + 1, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH));
                }
            }
        }

        private void placeCobWeb(ISeedReader world, MutableBoundingBox boundingBox, Random rand, float threshold, int x, int y, int z) {
            if (this.func_189916_b((IWorldReader)world, x, y, z, boundingBox) && rand.nextFloat() < threshold && this.hasSturdyNeighbours(world, boundingBox, x, y, z, 2)) {
                this.func_175811_a(world, Blocks.field_196553_aF.func_176223_P(), x, y, z, boundingBox);
            }
        }

        private boolean hasSturdyNeighbours(ISeedReader world, MutableBoundingBox boundingBox, int x, int y, int z, int chance) {
            BlockPos.Mutable mutable = new BlockPos.Mutable(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            int length = 0;
            for (Direction direction : Direction.values()) {
                mutable.func_189536_c(direction);
                if (boundingBox.func_175898_b((Vector3i)mutable) && world.func_180495_p((BlockPos)mutable).func_224755_d((IBlockReader)world, (BlockPos)mutable, direction.func_176734_d()) && ++length >= chance) {
                    return true;
                }
                mutable.func_189536_c(direction.func_176734_d());
            }
            return false;
        }
    }

    public static class Cross
    extends Piece {
        private final Direction corridorDirection;
        private final boolean isMultipleFloors;

        public Cross(TemplateManager template, CompoundNBT nbt) {
            super(IStructurePieceType.field_214781_b, nbt);
            this.isMultipleFloors = nbt.func_74767_n("tf");
            this.corridorDirection = Direction.func_176731_b((int)nbt.func_74762_e("D"));
        }

        @Override
        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74757_a("tf", this.isMultipleFloors);
            tagCompound.func_74768_a("D", this.corridorDirection.func_176736_b());
        }

        public Cross(int chainLength, MutableBoundingBox boundingBox, @Nullable Direction direction, MineshaftStructure.Type type) {
            super(IStructurePieceType.field_214781_b, chainLength, type);
            this.corridorDirection = direction;
            this.field_74887_e = boundingBox;
            this.isMultipleFloors = boundingBox.func_78882_c() > 3;
        }

        public static MutableBoundingBox findCrossing(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction facing) {
            MutableBoundingBox boundingBox;
            int yMax = rand.nextInt(4) == 0 ? 6 : 2;
            switch (facing) {
                default: {
                    boundingBox = new MutableBoundingBox(-1, 0, -4, 3, yMax, 0);
                    break;
                }
                case SOUTH: {
                    boundingBox = new MutableBoundingBox(-1, 0, 0, 3, yMax, 4);
                    break;
                }
                case WEST: {
                    boundingBox = new MutableBoundingBox(-4, 0, -1, 0, yMax, 3);
                    break;
                }
                case EAST: {
                    boundingBox = new MutableBoundingBox(0, 0, -1, 4, yMax, 3);
                }
            }
            boundingBox.func_78886_a(x, y, z);
            return StructurePiece.func_74883_a(listIn, (MutableBoundingBox)boundingBox) != null ? null : boundingBox;
        }

        public void func_74861_a(StructurePiece start, List<StructurePiece> pieces, Random rand) {
            int chainLength = this.func_74877_c();
            switch (this.corridorDirection) {
                default: {
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, chainLength);
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, chainLength);
                    break;
                }
                case SOUTH: {
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, chainLength);
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, chainLength);
                    break;
                }
                case WEST: {
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.WEST, chainLength);
                    break;
                }
                case EAST: {
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, Direction.EAST, chainLength);
                }
            }
            if (this.isMultipleFloors) {
                if (rand.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                }
                if (rand.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.WEST, chainLength);
                }
                if (rand.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, Direction.EAST, chainLength);
                }
                if (rand.nextBoolean()) {
                    MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                }
            }
        }

        public boolean func_230383_a_(ISeedReader worldIn, StructureManager structure, ChunkGenerator generator, Random rand, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
            if (this.func_74860_a((IBlockReader)worldIn, boundingBox)) {
                return false;
            }
            BlockState plankState = this.mineShaftType.getPlanks();
            if (this.isMultipleFloors) {
                this.func_175804_a(worldIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            } else {
                this.func_175804_a(worldIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, field_202556_l, field_202556_l, false);
                this.func_175804_a(worldIn, boundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, field_202556_l, field_202556_l, false);
            }
            this.placeSupportPillar(worldIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(worldIn, boundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(worldIn, boundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(worldIn, boundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            int y = this.field_74887_e.field_78895_b - 1;
            for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
                for (int z = this.field_74887_e.field_78896_c; z <= this.field_74887_e.field_78892_f; ++z) {
                    this.setPlanksBlock(worldIn, boundingBox, plankState, x, y, z);
                }
            }
            return true;
        }

        private void placeSupportPillar(ISeedReader world, MutableBoundingBox boundingBox, int x, int minY, int z, int maxY) {
            if (!this.func_175807_a((IBlockReader)world, x, maxY + 1, z, boundingBox).func_196958_f()) {
                this.func_175804_a(world, boundingBox, x, minY, z, x, maxY, z, this.mineShaftType.getPlanks(), field_202556_l, false);
            }
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs(int chainLength, MutableBoundingBox boundingBox, Direction direction, MineshaftStructure.Type type) {
            super(IStructurePieceType.field_214783_d, chainLength, type);
            this.func_186164_a(direction);
            this.field_74887_e = boundingBox;
        }

        public Stairs(TemplateManager template, CompoundNBT compound) {
            super(IStructurePieceType.field_214783_d, compound);
        }

        public static MutableBoundingBox findStairs(List<StructurePiece> listIn, Random rand, int x, int y, int z, Direction direction) {
            MutableBoundingBox boundingBox;
            switch (direction) {
                default: {
                    boundingBox = new MutableBoundingBox(0, -5, -8, 2, 2, 0);
                    break;
                }
                case SOUTH: {
                    boundingBox = new MutableBoundingBox(0, -5, 0, 2, 2, 8);
                    break;
                }
                case WEST: {
                    boundingBox = new MutableBoundingBox(-8, -5, 0, 0, 2, 2);
                    break;
                }
                case EAST: {
                    boundingBox = new MutableBoundingBox(0, -5, 0, 8, 2, 2);
                }
            }
            boundingBox.func_78886_a(x, y, z);
            StructurePiece.func_74883_a(listIn, (MutableBoundingBox)boundingBox);
            return null;
        }

        public void func_74861_a(StructurePiece start, List<StructurePiece> pieces, Random rand) {
            int chainLength = this.func_74877_c();
            Direction direction = this.func_186165_e();
            if (direction != null) {
                switch (direction) {
                    default: {
                        MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, Direction.NORTH, chainLength);
                        break;
                    }
                    case SOUTH: {
                        MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, Direction.SOUTH, chainLength);
                        break;
                    }
                    case WEST: {
                        MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.WEST, chainLength);
                        break;
                    }
                    case EAST: {
                        MineshaftPieces.generateAndAddPiece(start, pieces, rand, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, Direction.EAST, chainLength);
                    }
                }
            }
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager structure, ChunkGenerator generator, Random rand, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
            if (this.func_74860_a((IBlockReader)world, boundingBox)) {
                return false;
            }
            this.func_175804_a(world, boundingBox, 0, 5, 0, 2, 7, 1, field_202556_l, field_202556_l, false);
            this.func_175804_a(world, boundingBox, 0, 0, 7, 2, 2, 8, field_202556_l, field_202556_l, false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(world, boundingBox, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }
}

