/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.features.structure;

import com.blackgear.cavesandcliffs.common.world.gen.features.structure.MineshaftConfig;
import com.blackgear.cavesandcliffs.common.world.gen.features.structure.MineshaftPieces;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class MineshaftStructure
extends Structure<MineshaftConfig> {
    public MineshaftStructure(Codec<MineshaftConfig> config) {
        super(config);
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider provider, long seed, SharedSeedRandom seedRandom, int x, int z, Biome biome, ChunkPos chunkPos, MineshaftConfig config) {
        seedRandom.func_202425_c(seed, x, z);
        double chance = config.probability;
        return seedRandom.nextDouble() < chance;
    }

    public Structure.IStartFactory<MineshaftConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_DECORATION;
    }

    public static enum Type implements IStringSerializable
    {
        NORMAL("normal", Blocks.field_196617_K, Blocks.field_196662_n, Blocks.field_180407_aO),
        MESA("mesa", Blocks.field_196623_P, Blocks.field_196672_s, Blocks.field_180406_aS);

        public static final Codec<Type> CODEC;
        private static final Map<String, Type> BY_NAME;
        private final String name;
        private final BlockState log;
        private final BlockState planks;
        private final BlockState fence;

        private Type(String nameIn, Block log, Block planks, Block fence) {
            this.name = nameIn;
            this.log = log.func_176223_P();
            this.planks = planks.func_176223_P();
            this.fence = fence.func_176223_P();
        }

        public String getName() {
            return this.name;
        }

        private static Type byName(String p_214715_0_) {
            return BY_NAME.get(p_214715_0_);
        }

        public static Type byId(int id) {
            return id >= 0 && id < Type.values().length ? Type.values()[id] : NORMAL;
        }

        public BlockState getLog() {
            return this.log;
        }

        public BlockState getPlanks() {
            return this.planks;
        }

        public BlockState getFence() {
            return this.fence;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            CODEC = IStringSerializable.func_233023_a_(Type::values, Type::byName);
            BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getName, name -> name));
        }
    }

    public static class Start
    extends StructureStart<MineshaftConfig> {
        public Start(Structure<MineshaftConfig> structure, int x, int z, MutableBoundingBox boundingBox, int height, long seed) {
            super(structure, x, z, boundingBox, height, seed);
        }

        public void func_230364_a_(DynamicRegistries registries, ChunkGenerator generator, TemplateManager manager, int x, int z, Biome biome, MineshaftConfig config) {
            MineshaftPieces.Room room = new MineshaftPieces.Room(0, (Random)this.field_214631_d, (x << 4) + 2, (z << 4) + 2, config.type);
            this.field_75075_a.add(room);
            room.func_74861_a(room, this.field_75075_a, (Random)this.field_214631_d);
            this.func_202500_a();
            if (config.type == Type.MESA) {
                MutableBoundingBox boundingBox = this.func_75071_a();
                int y = generator.func_230356_f_() - boundingBox.field_78894_e + boundingBox.func_78882_c() / 2 - -5;
                this.func_75071_a().func_78886_a(0, y, 0);
                for (StructurePiece structurepiece : this.field_75075_a) {
                    structurepiece.func_181138_a(0, y, 0);
                }
            } else {
                this.func_214628_a(generator.func_230356_f_(), (Random)this.field_214631_d, 10);
            }
        }
    }
}

