/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.foliage;

import com.blackgear.cavesandcliffs.core.registries.CCBFoliagePlacerType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;

public class RandomSpreadFoliagePlacer
extends FoliagePlacer {
    public static final Codec<RandomSpreadFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> RandomSpreadFoliagePlacer.func_242830_b((RecordCodecBuilder.Instance)instance).and(instance.group((App)FeatureSpread.func_242254_a((int)1, (int)512, (int)8).fieldOf("foliage_height").forGetter(foliagePlacer -> foliagePlacer.foliageHeight), (App)Codec.intRange((int)0, (int)256).fieldOf("leaf_placement_attempts").forGetter(foliagePlacer -> foliagePlacer.leafPlacementAttempts))).apply((Applicative)instance, RandomSpreadFoliagePlacer::new));
    private final FeatureSpread foliageHeight;
    private final int leafPlacementAttempts;

    public RandomSpreadFoliagePlacer(FeatureSpread radius, FeatureSpread offset, FeatureSpread foliageHeight, int leafPlacementAttempts) {
        super(radius, offset);
        this.foliageHeight = foliageHeight;
        this.leafPlacementAttempts = leafPlacementAttempts;
    }

    protected FoliagePlacerType<?> func_230371_a_() {
        return (FoliagePlacerType)CCBFoliagePlacerType.RANDOM_SPREAD_FOLIAGE_PLACER.get();
    }

    protected void func_230372_a_(IWorldGenerationReader world, Random rand, BaseTreeFeatureConfig config, int treeHeight, FoliagePlacer.Foliage foliage, int radius, int offset, Set<BlockPos> positions, int range, MutableBoundingBox boundingBox) {
        BlockPos pos = foliage.func_236763_a_();
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int attempts = 0; attempts < this.leafPlacementAttempts; ++attempts) {
            mutable.func_239621_a_((Vector3i)pos, rand.nextInt(offset) - rand.nextInt(offset), rand.nextInt(radius) - rand.nextInt(radius), rand.nextInt(offset) - rand.nextInt(offset));
            RandomSpreadFoliagePlacer.placeFoliageBlock(world, rand, (BlockPos)mutable, config);
        }
    }

    protected static void placeFoliageBlock(IWorldGenerationReader world, Random rand, BlockPos pos, BaseTreeFeatureConfig config) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            world.func_180501_a(pos, config.field_227369_n_.func_225574_a_(rand, pos), 19);
        }
    }

    public int func_230374_a_(Random rand, int trunkHeight, BaseTreeFeatureConfig config) {
        return this.foliageHeight.func_242259_a(rand);
    }

    protected boolean func_230373_a_(Random rand, int dx, int y, int dz, int radius, boolean giantTrunk) {
        return false;
    }
}

