/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.common.world.gen.trunkplacer;

import com.blackgear.cavesandcliffs.common.utils.ExtraCodecs;
import com.blackgear.cavesandcliffs.common.utils.math.IntProvider;
import com.blackgear.cavesandcliffs.core.registries.CCBTrunkPlacerType;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;

public class BendingTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<BendingTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> BendingTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)instance).and(instance.group((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("min_height_for_leaves", (Object)1).forGetter(bendingTrunkPlacer -> bendingTrunkPlacer.minHeightForLeaves), (App)IntProvider.createValidatingCodec(1, 64).fieldOf("bend_length").forGetter(bendingTrunkPlacer -> bendingTrunkPlacer.bendLength))).apply((Applicative)instance, BendingTrunkPlacer::new));
    private final int minHeightForLeaves;
    private final IntProvider bendLength;

    public BendingTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, int minHeightForLeaves, IntProvider bendLength) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.minHeightForLeaves = minHeightForLeaves;
        this.bendLength = bendLength;
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return CCBTrunkPlacerType.BENDING_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader worldIn, Random rand, int treeHeight, BlockPos pos, Set<BlockPos> positions, MutableBoundingBox boundingBox, BaseTreeFeatureConfig config) {
        int bendLength;
        Direction direction = Direction.Plane.HORIZONTAL.func_179518_a(rand);
        int height = treeHeight - 1;
        BlockPos.Mutable mutable = pos.func_239590_i_();
        BlockPos blockPos = mutable.func_177977_b();
        BendingTrunkPlacer.func_236909_a_((IWorldGenerationReader)worldIn, (BlockPos)blockPos);
        ArrayList list = Lists.newArrayList();
        for (bendLength = 0; bendLength <= height; ++bendLength) {
            if (bendLength + 1 >= height + rand.nextInt(2)) {
                mutable.func_189536_c(direction);
            }
            if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)worldIn, (BlockPos)mutable)) {
                BendingTrunkPlacer.func_236911_a_((IWorldGenerationReader)worldIn, (Random)rand, (BlockPos)mutable, positions, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)config);
            }
            if (bendLength >= this.minHeightForLeaves) {
                list.add(new FoliagePlacer.Foliage(mutable.func_185334_h(), 0, false));
            }
            mutable.func_189536_c(Direction.UP);
        }
        bendLength = this.bendLength.get(rand);
        for (int curvature = 0; curvature <= bendLength; ++curvature) {
            if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)worldIn, (BlockPos)mutable)) {
                BendingTrunkPlacer.func_236911_a_((IWorldGenerationReader)worldIn, (Random)rand, (BlockPos)mutable, positions, (MutableBoundingBox)boundingBox, (BaseTreeFeatureConfig)config);
            }
            list.add(new FoliagePlacer.Foliage(mutable.func_185334_h(), 0, false));
            mutable.func_189536_c(direction);
        }
        return list;
    }
}

