/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries;

import com.blackgear.cavesandcliffs.core.CavesAndCliffs;
import com.blackgear.cavesandcliffs.core.registries.api.util.CCBRegistries;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cavesandcliffs", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CCBBiomes {
    public static final CCBRegistries HELPER = CavesAndCliffs.REGISTRIES;
    public static final RegistryObject<Biome> LUSH_CAVES = HELPER.registerBiome("lush_caves", CCBBiomes::makeLushCaves);
    public static final RegistryObject<Biome> DRIPSTONE_CAVES = HELPER.registerBiome("dripstone_caves", CCBBiomes::makeDripstoneCaves);

    public static Biome makeLushCaves() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.NONE).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(0.5f).func_205417_d(0.5f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.5f)).func_235238_a_()).func_242458_a(spawnSettings.func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    public static Biome makeDripstoneCaves() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244178_j);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.RAIN).func_205419_a(Biome.Category.NONE).func_205421_a(0.125f).func_205420_b(0.05f).func_205414_c(0.8f).func_205417_d(0.4f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.8f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawnSettings.func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    public static Biome makeLoftyPeaks() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        DefaultBiomeFeatures.func_243737_c((MobSpawnInfo.Builder)spawnSettings);
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder().func_242517_a(ConfiguredSurfaceBuilders.field_244181_m);
        DefaultBiomeFeatures.func_243738_d((BiomeGenerationSettings.Builder)generationSettings);
        return new Biome.Builder().func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.EXTREME_HILLS).func_205421_a(1.06f).func_205420_b(0.75f).func_205414_c(0.2f).func_205417_d(0.6f).func_235097_a_(new BiomeAmbience.Builder().func_235246_b_(4159204).func_235248_c_(329011).func_235239_a_(12638463).func_242539_d(CCBBiomes.getSkyColorWithTemperatureModifier(0.8f)).func_235243_a_(MoodSoundAmbience.field_235027_b_).func_235238_a_()).func_242458_a(spawnSettings.func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    private static int getSkyColorWithTemperatureModifier(float temperature) {
        float modifier = temperature / 3.0f;
        modifier = MathHelper.func_76131_a((float)modifier, (float)-1.0f, (float)1.0f);
        return MathHelper.func_181758_c((float)(0.62222224f - modifier * 0.05f), (float)(0.5f + modifier * 0.1f), (float)1.0f);
    }
}

