/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries;

import com.blackgear.cavesandcliffs.common.world.gen.features.structure.MineshaftConfig;
import com.blackgear.cavesandcliffs.common.world.gen.features.structure.MineshaftStructure;
import com.blackgear.cavesandcliffs.core.CavesAndCliffs;
import com.blackgear.cavesandcliffs.core.compatibility.ModCompatibility;
import com.blackgear.cavesandcliffs.core.registries.CCBConfiguredStructures;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CCBStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"cavesandcliffs");
    public static final RegistryObject<Structure<MineshaftConfig>> MINESHAFT = CCBStructures.registerStructure("mineshaft", () -> new MineshaftStructure(MineshaftConfig.CODEC));

    public static void bootstrap() {
        STRUCTURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CCBStructures::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, CCBStructures::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(CCBStructures::addDimensionalSpacing);
    }

    private static <S extends Structure<?>> RegistryObject<S> registerStructure(String key, Supplier<? extends S> structure) {
        return STRUCTURES.register(key, structure);
    }

    public static <S extends Structure<?>> void setupMapSpacingAndLand(S structure, StructureSeparationSettings separationSettings) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)separationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, separationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().field_236193_d_ = tempMap;
            } else {
                structureMap.put(structure, separationSettings);
            }
        });
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> CCBStructures.setupMapSpacingAndLand((Structure)MINESHAFT.get(), new StructureSeparationSettings(1, 0, 593751784)));
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld world = (ServerWorld)event.getWorld();
            try {
                Method getCodecMethod = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
                ResourceLocation location = Registry.field_239690_aB_.func_177774_c((Object)((Codec)getCodecMethod.invoke((Object)world.func_72863_F().field_186029_c, new Object[0])));
                if (location != null && location.func_110624_b().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception exception) {
                CavesAndCliffs.LOGGER.error("Was unable to check if " + world.func_234923_W_().func_240901_a_() + " is using Terraforged's ChunkGenerator");
            }
            if (world.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && world.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            HashMap<IForgeRegistryEntry, Object> tempMap = new HashMap<IForgeRegistryEntry, Object>(world.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            tempMap.put(MINESHAFT.get(), DimensionStructuresSettings.field_236191_b_.get((Object)MINESHAFT.get()));
            world.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        boolean found = false;
        for (Supplier structure2 : event.getGeneration().getStructures()) {
            if (((StructureFeature)structure2.get()).field_236268_b_ != Structure.field_236367_c_) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        if (ModCompatibility.isBetterMineshaftsInstalled()) {
            return;
        }
        event.getGeneration().getStructures().removeIf(structure -> ((StructureFeature)structure.get()).field_236268_b_ == Structure.field_236367_c_);
        if (event.getCategory() == Biome.Category.MESA) {
            event.getGeneration().getStructures().add(() -> CCBConfiguredStructures.MINESHAFT_BADLANDS);
        }
        if (event.getCategory() != Biome.Category.MESA) {
            event.getGeneration().getStructures().add(() -> CCBConfiguredStructures.MINESHAFT);
        }
    }
}

