/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.other.utils;

import com.google.common.collect.AbstractIterator;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class BlockPosUtils {
    public static BlockPos.Mutable setAndOffset(BlockPos.Mutable pos, Vector3i vec3i, Direction direction) {
        return pos.func_181079_c(vec3i.func_177958_n() + direction.func_82601_c(), vec3i.func_177956_o() + direction.func_96559_d(), vec3i.func_177952_p() + direction.func_82599_e());
    }

    public static BlockPos set(BlockPos.Mutable mutable, Vector3i pos, int x, int y, int z) {
        return mutable.func_177982_a(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
    }

    public static void setAndOffset(BlockPos.Mutable pos, Vector3i vec3i, int x, int y, int z) {
        pos.func_181079_c(vec3i.func_177958_n() + x, vec3i.func_177956_o() + y, vec3i.func_177952_p() + z);
    }

    public static BlockPos atY(BlockPos pos, int yIn) {
        return new BlockPos.Mutable(pos.func_177958_n(), yIn, pos.func_177952_p());
    }

    public static Iterable<BlockPos> betweenClosed(BlockPos start, BlockPos end) {
        return BlockPosUtils.betweenClosed(Math.min(start.func_177958_n(), end.func_177958_n()), Math.min(start.func_177956_o(), end.func_177956_o()), Math.min(start.func_177952_p(), end.func_177952_p()), Math.max(start.func_177958_n(), end.func_177958_n()), Math.max(start.func_177956_o(), end.func_177956_o()), Math.max(start.func_177952_p(), end.func_177952_p()));
    }

    public static Iterable<BlockPos> iterateRandomly(Random rand, int count, BlockPos around, int range) {
        return BlockPos.func_239585_a_((Random)rand, (int)count, (int)(around.func_177958_n() - range), (int)(around.func_177956_o() - range), (int)(around.func_177952_p() - range), (int)(around.func_177958_n() + range), (int)(around.func_177956_o() + range), (int)(around.func_177952_p() + range));
    }

    public static Iterable<BlockPos> betweenClosed(final int x1, final int y1, final int z1, int x2, int y2, int z2) {
        final int x = x2 - x1 + 1;
        final int y = y2 - y1 + 1;
        int z = z2 - z1 + 1;
        final int radius = x * y * z;
        return () -> new AbstractIterator<BlockPos>(){
            private final BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            private int totalAmount;

            protected BlockPos computeNext() {
                if (this.totalAmount == radius) {
                    return (BlockPos)this.endOfData();
                }
                int i1 = this.totalAmount % x;
                int j1 = this.totalAmount / x;
                int k1 = j1 % y;
                int l1 = j1 / y;
                ++this.totalAmount;
                return this.mutablePos.func_181079_c(x1 + i1, y1 + k1, z1 + l1);
            }
        };
    }

    public static Iterable<BlockPos> withinManhattan(BlockPos pos, int xWidth, final int yHeight, final int zWidth) {
        final int radius = xWidth + yHeight + zWidth;
        final int getX = pos.func_177958_n();
        final int getY = pos.func_177956_o();
        final int getZ = pos.func_177952_p();
        return () -> new AbstractIterator<BlockPos>(){
            private final BlockPos.Mutable coordinateIterator = new BlockPos.Mutable();
            private int currentDepth;
            private int maxX;
            private int maxY;
            private int x;
            private int y;
            private boolean zMirror;

            protected BlockPos computeNext() {
                if (this.zMirror) {
                    this.zMirror = false;
                    this.coordinateIterator.func_223472_q(getZ - (this.coordinateIterator.func_177952_p() - getZ));
                    return this.coordinateIterator;
                }
                BlockPos.Mutable blockPos = null;
                while (blockPos == null) {
                    if (this.y > this.maxY) {
                        ++this.x;
                        if (this.x > this.maxX) {
                            ++this.currentDepth;
                            if (this.currentDepth > radius) {
                                return (BlockPos)this.endOfData();
                            }
                            this.maxX = Math.min(getX, this.currentDepth);
                            this.x = -this.maxX;
                        }
                        this.maxY = Math.min(yHeight, this.currentDepth - Math.abs(this.x));
                        this.y = -this.maxY;
                    }
                    int x = this.x;
                    int y = this.y;
                    int z = this.currentDepth - Math.abs(x) - Math.abs(y);
                    if (z <= zWidth) {
                        this.zMirror = z != 0;
                        blockPos = this.coordinateIterator.func_181079_c(getX + x, getY + y, getZ + z);
                    }
                    ++this.y;
                }
                return blockPos;
            }
        };
    }
}

