/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.other.utils;

import com.blackgear.cavesandcliffs.common.blocks.SimpleBlock;
import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class BlockUtils {
    public static ImmutableMap<BlockState, VoxelShape> getShapeForEachState(Block block, Function<BlockState, VoxelShape> function) {
        return (ImmutableMap)block.func_176194_O().func_177619_a().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), function));
    }

    public static boolean isIn(BlockState state, ITag.INamedTag<Block> tag, Predicate<BlockState> predicate) {
        return state.func_235714_a_(tag) && predicate.test(state);
    }

    public static BlockState getStateWithProperties(Block block, BlockState state) {
        BlockState blockState = block.func_176223_P();
        for (Property property : state.func_177230_c().func_176194_O().func_177623_d()) {
            if (!blockState.func_235901_b_(property)) continue;
            blockState = BlockUtils.copyProperty(state, blockState, property);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState state, BlockState defaultState, Property<T> property) {
        return (BlockState)defaultState.func_206870_a(property, state.func_177229_b(property));
    }

    public static void setFlammable(Block blockIn, int encouragement, int flammability) {
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        fire.func_180686_a(blockIn, encouragement, flammability);
    }

    public static void setCompostable(IItemProvider item, float chance) {
        ComposterBlock.field_220299_b.put((Object)item.func_199767_j(), chance);
    }

    public static void setHurtEntities(FallingBlockEntity fallingBlock, float fallHurtAmount, int fallHurtMax) {
        fallingBlock.func_145806_a(true);
        fallingBlock.field_145816_i = fallHurtAmount;
        fallingBlock.field_145815_h = fallHurtMax;
    }

    public static Vector3d getOffset(BlockState state, IBlockReader reader, BlockPos pos) {
        Block block = state.func_177230_c();
        AbstractBlock.OffsetType offsetType = block.func_176218_Q();
        if (offsetType == AbstractBlock.OffsetType.NONE) {
            return Vector3d.field_186680_a;
        }
        long coordinateRandom = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
        float offset = block instanceof SimpleBlock ? ((SimpleBlock)block).getMaxModelOffset() : 0.25f;
        double x = MathHelper.func_151237_a((double)(((double)((float)(coordinateRandom & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-offset), (double)offset);
        double y = offsetType == AbstractBlock.OffsetType.XYZ ? ((double)((float)(coordinateRandom >> 4 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0;
        double z = MathHelper.func_151237_a((double)(((double)((float)(coordinateRandom >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-offset), (double)offset);
        return new Vector3d(x, y, z);
    }
}

