/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.other.utils;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;

public class DirectionUtils {
    public static final Codec<Direction> CODEC = IStringSerializable.func_233023_a_(Direction::values, Direction::func_176739_a);
    private static final Vector3i directionVec = Direction.UP.func_176730_m();

    public static boolean isFacingAngle(float angle) {
        float i = angle * 0.17453292f;
        float j = -MathHelper.func_76126_a((float)i);
        float k = MathHelper.func_76134_b((float)i);
        return (float)directionVec.func_177958_n() * j + (float)directionVec.func_177952_p() * k > 0.0f;
    }

    public static Direction getFacingAxis(Entity entity, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return DirectionUtils.isFacingAngle(entity.func_195046_g(1.0f)) ? Direction.EAST : Direction.WEST;
            }
            case Z: {
                return DirectionUtils.isFacingAngle(entity.func_195046_g(1.0f)) ? Direction.SOUTH : Direction.NORTH;
            }
        }
        return entity.func_195046_g(1.0f) < 0.0f ? Direction.UP : Direction.DOWN;
    }

    public static Stream<Direction> streamPlane(Direction.Plane plane) {
        return Arrays.stream(plane.field_209387_c);
    }
}

