/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.other.utils;

import com.blackgear.cavesandcliffs.common.utils.math.UniformIntProvider;
import com.blackgear.cavesandcliffs.core.registries.other.utils.Vec3dUtils;
import java.util.Random;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class ParticleUtils {
    public static void spawnParticlesOnBlockFaces(World worldIn, BlockPos pos, IParticleData particleData, UniformIntProvider particleSpread) {
        for (Direction direction : Direction.values()) {
            int spread = particleSpread.get(worldIn.field_73012_v);
            for (int i = 0; i < spread; ++i) {
                ParticleUtils.spawnParticleOnFace(worldIn, pos, direction, particleData);
            }
        }
    }

    public static void spawnParticlesAlongAxis(Direction.Axis axis, World worldIn, BlockPos pos, double speed, IParticleData particleData, UniformIntProvider particleSpread) {
        Vector3d vector = Vec3dUtils.atCenterOf((Vector3i)pos);
        boolean xAxis = axis == Direction.Axis.X;
        boolean yAxis = axis == Direction.Axis.Y;
        boolean zAxis = axis == Direction.Axis.Z;
        int spread = particleSpread.get(worldIn.field_73012_v);
        for (int i = 0; i < spread; ++i) {
            double x = vector.field_72450_a + MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-1.0, (double)1.0) * (xAxis ? 0.5 : speed);
            double y = vector.field_72448_b + MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-1.0, (double)1.0) * (yAxis ? 0.5 : speed);
            double z = vector.field_72449_c + MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-1.0, (double)1.0) * (zAxis ? 0.5 : speed);
            double xMotion = xAxis ? MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
            double yMotion = yAxis ? MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
            double zMotion = zAxis ? MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
            worldIn.func_195594_a(particleData, x, y, z, xMotion, yMotion, zMotion);
        }
    }

    public static void spawnParticleOnFace(World worldIn, BlockPos pos, Direction direction, IParticleData particleData) {
        Vector3d vector = Vec3dUtils.atCenterOf((Vector3i)pos);
        int xOffset = direction.func_82601_c();
        int yOffset = direction.func_96559_d();
        int zOffset = direction.func_82599_e();
        double x = vector.field_72450_a + (xOffset == 0 ? MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-0.5, (double)0.5) : (double)xOffset * 0.55);
        double y = vector.field_72448_b + (yOffset == 0 ? MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-0.5, (double)0.5) : (double)yOffset * 0.55);
        double z = vector.field_72449_c + (zOffset == 0 ? MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-0.5, (double)0.5) : (double)zOffset * 0.55);
        double xMotion = xOffset == 0 ? MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
        double yMotion = yOffset == 0 ? MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
        double zMotion = zOffset == 0 ? MathHelper.func_82716_a((Random)worldIn.field_73012_v, (double)-1.0, (double)1.0) : 0.0;
        worldIn.func_195594_a(particleData, x, y, z, xMotion, yMotion, zMotion);
    }
}

