/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.core.registries.other.utils;

import com.blackgear.cavesandcliffs.common.utils.math.UniformIntProvider;
import com.blackgear.cavesandcliffs.core.registries.CCBParticleTypes;
import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import com.blackgear.cavesandcliffs.core.registries.other.utils.ParticleUtils;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.particles.IParticleData;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;

public class WorldUtils {
    public static void syncWorldEvent(World worldIn, int event, BlockPos pos, int value) {
        switch (event) {
            case 3002: {
                if (value >= 0 && value < Direction.Axis.values().length) {
                    ParticleUtils.spawnParticlesAlongAxis(Direction.Axis.values()[value], worldIn, pos, 0.125, (IParticleData)CCBParticleTypes.ELECTRIC_SPARK.get(), UniformIntProvider.create(10, 19));
                    break;
                }
                ParticleUtils.spawnParticlesOnBlockFaces(worldIn, pos, (IParticleData)CCBParticleTypes.ELECTRIC_SPARK.get(), UniformIntProvider.create(3, 5));
                break;
            }
            case 3003: {
                ParticleUtils.spawnParticlesOnBlockFaces(worldIn, pos, (IParticleData)CCBParticleTypes.WAX_ON.get(), UniformIntProvider.create(3, 5));
                worldIn.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.ITEM_HONEYCOMB_WAX_ON.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case 3004: {
                ParticleUtils.spawnParticlesOnBlockFaces(worldIn, pos, (IParticleData)CCBParticleTypes.WAX_OFF.get(), UniformIntProvider.create(3, 5));
                break;
            }
            case 3005: {
                ParticleUtils.spawnParticlesOnBlockFaces(worldIn, pos, (IParticleData)CCBParticleTypes.SCRAPE.get(), UniformIntProvider.create(3, 5));
            }
        }
    }

    public static boolean canSpawnUnderground(EntityType<? extends LivingEntity> entityType, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return pos.func_177956_o() < worldIn.func_181545_F() && pos.func_177956_o() < worldIn.func_201676_a(Heightmap.Type.OCEAN_FLOOR, pos.func_177958_n(), pos.func_177952_p()) && WorldUtils.hasNoLight(worldIn, pos) && WorldUtils.hasStoneFloor(pos, worldIn);
    }

    public static boolean hasStoneFloor(BlockPos pos, IServerWorld worldIn) {
        BlockPos.Mutable mutable = pos.func_239590_i_();
        for (int distance = 0; distance < 5; ++distance) {
            mutable.func_189536_c(Direction.DOWN);
            BlockState state = worldIn.func_180495_p((BlockPos)mutable);
            if (state.func_235714_a_((ITag)BlockTags.field_242172_aH)) {
                return true;
            }
            if (state.func_203425_a(Blocks.field_150355_j)) continue;
            return false;
        }
        return false;
    }

    public static boolean hasNoLight(IServerWorld worldIn, BlockPos pos) {
        int light = worldIn.func_201672_e().func_72911_I() ? worldIn.func_205049_d(pos, 10) : worldIn.func_201696_r(pos);
        return light == 0;
    }
}

