/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.core.common.entity;

import com.blackgear.cavesandcliffs.common.blocks.IFallable;
import com.blackgear.cavesandcliffs.core.registries.api.common.CCBDamageSources;
import java.util.function.Predicate;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin
extends Entity {
    @Shadow
    public boolean field_145813_c;
    @Shadow
    private BlockState field_175132_d;
    @Shadow
    public CompoundNBT field_145810_d;
    @Shadow
    private boolean field_145808_f;
    @Shadow
    public int field_145812_b;
    @Shadow
    private boolean field_145809_g;
    @Shadow
    public float field_145816_i;
    @Shadow
    public int field_145815_h;

    public FallingBlockEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo info) {
        if (this.field_175132_d.func_196958_f()) {
            this.func_70106_y();
        } else {
            BlockPos pos;
            Block block = this.field_175132_d.func_177230_c();
            if (this.field_145812_b++ == 0) {
                pos = this.func_233580_cy_();
                if (this.field_70170_p.func_180495_p(pos).func_203425_a(block)) {
                    this.field_70170_p.func_217377_a(pos, false);
                } else if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (!this.field_70170_p.field_72995_K) {
                BlockRayTraceResult blockraytraceresult;
                pos = this.func_233580_cy_();
                boolean isConcrete = this.field_175132_d.func_177230_c() instanceof ConcretePowderBlock;
                boolean isInWater = isConcrete && this.field_70170_p.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
                double squaredMotion = this.func_213322_ci().func_189985_c();
                if (isConcrete && squaredMotion > 1.0 && (blockraytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(new Vector3d(this.field_70169_q, this.field_70167_r, this.field_70166_s), this.func_213303_ch(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)this))).func_216346_c() != RayTraceResult.Type.MISS && this.field_70170_p.func_204610_c(blockraytraceresult.func_216350_a()).func_206884_a((ITag)FluidTags.field_206959_a)) {
                    pos = blockraytraceresult.func_216350_a();
                    isInWater = true;
                }
                if (!this.field_70122_E && !isInWater) {
                    if (!(this.field_70170_p.field_72995_K || (this.field_145812_b <= 100 || pos.func_177956_o() >= 1 && pos.func_177956_o() <= 256) && this.field_145812_b <= 600)) {
                        if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a((IItemProvider)block);
                        }
                        this.func_70106_y();
                    }
                } else {
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.7, -0.5, 0.7));
                    if (!state.func_203425_a(Blocks.field_196603_bb)) {
                        this.func_70106_y();
                        if (!this.field_145808_f) {
                            boolean isValidPosition;
                            boolean isReplaceable = state.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(this.field_70170_p, pos, Direction.DOWN, ItemStack.field_190927_a, Direction.UP));
                            boolean canFallThrough = FallingBlock.func_185759_i((BlockState)this.field_70170_p.func_180495_p(pos.func_177977_b())) && (!isConcrete || !isInWater);
                            boolean bl = isValidPosition = this.field_175132_d.func_196955_c((IWorldReader)this.field_70170_p, pos) && !canFallThrough;
                            if (isReplaceable && isValidPosition) {
                                if (this.field_175132_d.func_235901_b_((Property)BlockStateProperties.field_208198_y) && this.field_70170_p.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a) {
                                    this.field_175132_d = (BlockState)this.field_175132_d.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true));
                                }
                                if (this.field_70170_p.func_180501_a(pos, this.field_175132_d, 3)) {
                                    TileEntity tileEntity;
                                    if (block instanceof IFallable) {
                                        ((IFallable)block).onLand(this.field_70170_p, pos, this.field_175132_d, state, (FallingBlockEntity)this);
                                    }
                                    if (this.field_145810_d != null && this.field_175132_d.hasTileEntity() && (tileEntity = this.field_70170_p.func_175625_s(pos)) != null) {
                                        CompoundNBT compound = tileEntity.func_189515_b(new CompoundNBT());
                                        for (String key : this.field_145810_d.func_150296_c()) {
                                            INBT nbt = this.field_145810_d.func_74781_a(key);
                                            if ("x".equals(key) || "y".equals(key) || "z".equals(key)) continue;
                                            compound.func_218657_a(key, nbt.func_74737_b());
                                        }
                                        tileEntity.func_230337_a_(this.field_175132_d, compound);
                                        tileEntity.func_70296_d();
                                    }
                                } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                    this.ccb$onDestroyedOnLanding(block, pos);
                                    this.func_199703_a((IItemProvider)block);
                                }
                            } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                this.ccb$onDestroyedOnLanding(block, pos);
                                this.func_199703_a((IItemProvider)block);
                            }
                        } else {
                            this.ccb$onDestroyedOnLanding(block, pos);
                        }
                    }
                }
            }
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.98));
        }
    }

    private void ccb$onDestroyedOnLanding(Block block, BlockPos pos) {
        if (block instanceof IFallable) {
            ((IFallable)block).onBrokenAfterFall(this.field_70170_p, pos, (FallingBlockEntity)this);
        }
    }

    @Inject(method={"onLivingFall(FF)Z"}, at={@At(value="TAIL")}, cancellable=true)
    public void ccb$onLivingFall(float distance, float damageMultiplier, CallbackInfoReturnable<Boolean> info) {
        boolean defaultValue = (Boolean)info.getReturnValue();
        if (this.field_175132_d.func_177230_c() instanceof IFallable) {
            info.setReturnValue((Object)this.ccb$handleFallDamage(distance, damageMultiplier, CCBDamageSources.STALAGMITE));
        } else {
            info.setReturnValue((Object)defaultValue);
        }
    }

    @Unique
    public boolean ccb$handleFallDamage(float distance, float damageMultiplier, DamageSource source) {
        int fallDistance;
        if (!this.field_145809_g && (fallDistance = MathHelper.func_76123_f((float)(distance - 1.0f))) >= 0) {
            DamageSource fallDamageSource;
            Predicate<Entity> hurtEntityPredicate;
            if (this.field_175132_d.func_177230_c() instanceof IFallable) {
                IFallable fallable = (IFallable)this.field_175132_d.func_177230_c();
                hurtEntityPredicate = fallable.getHurtEntityPredicate();
                fallDamageSource = fallable.getFallDamageSource();
            } else {
                hurtEntityPredicate = EntityPredicates.field_180132_d;
                fallDamageSource = DamageSource.field_82729_p;
            }
            float damageAmount = Math.min(MathHelper.func_76141_d((float)((float)fallDistance * this.field_145816_i)), this.field_145815_h);
            this.field_70170_p.func_175674_a((Entity)((FallingBlockEntity)this), this.func_174813_aQ(), hurtEntityPredicate).forEach(entity -> entity.func_70097_a(fallDamageSource, damageAmount));
            boolean isAnvil = this.field_175132_d.func_235714_a_((ITag)BlockTags.field_200572_k);
            if (isAnvil && damageAmount > 0.0f && this.field_70146_Z.nextFloat() < 0.05f + (float)fallDistance * 0.05f) {
                BlockState state = AnvilBlock.func_196433_f((BlockState)this.field_175132_d);
                if (state == null) {
                    this.field_145808_f = true;
                } else {
                    this.field_175132_d = state;
                }
            }
        }
        return false;
    }
}

