/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.core.common.entity;

import com.blackgear.cavesandcliffs.common.blocks.LightningRodBlock;
import com.blackgear.cavesandcliffs.common.blocks.Oxidizable;
import com.blackgear.cavesandcliffs.core.registries.CCBBlocks;
import com.blackgear.cavesandcliffs.core.registries.other.utils.BlockPosUtils;
import com.blackgear.cavesandcliffs.core.registries.other.utils.WorldUtils;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningBoltEntity.class})
public abstract class LightningBoltEntityMixin
extends Entity {
    @Shadow
    private int field_70262_b;

    @Shadow
    protected abstract void func_195053_a(int var1);

    public LightningBoltEntityMixin(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Unique
    private void powerLightningRod() {
        BlockPos blockPos = this.getAffectedBlockPos();
        BlockState blockState = this.field_70170_p.func_180495_p(blockPos);
        if (blockState.func_203425_a((Block)CCBBlocks.LIGHTNING_ROD.get())) {
            ((LightningRodBlock)blockState.func_177230_c()).setPowered(blockState, this.field_70170_p, blockPos);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void worldTick(CallbackInfo info) {
        super.func_70071_h_();
        if (this.field_70262_b == 2) {
            if (this.field_70170_p.func_201670_d()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187754_de, SoundCategory.WEATHER, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f, false);
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.2f, false);
            } else {
                Difficulty difficulty = this.field_70170_p.func_175659_aa();
                if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
                    this.func_195053_a(4);
                }
                this.powerLightningRod();
                LightningBoltEntityMixin.cleanOxidization(this.field_70170_p, this.getAffectedBlockPos());
            }
        }
    }

    @Unique
    private BlockPos getAffectedBlockPos() {
        Vector3d pos = this.func_213303_ch();
        return new BlockPos(pos.field_72450_a, pos.field_72448_b - 1.0E-6, pos.field_72449_c);
    }

    @Unique
    private static void cleanOxidization(World world, BlockPos pos) {
        BlockState state;
        BlockPos blockPos;
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_203425_a((Block)CCBBlocks.LIGHTNING_ROD.get())) {
            blockPos = pos.func_177972_a(((Direction)blockState.func_177229_b((Property)LightningRodBlock.field_176387_N)).func_176734_d());
            state = world.func_180495_p(blockPos);
        } else {
            blockPos = pos;
            state = blockState;
        }
        if (state.func_177230_c() instanceof Oxidizable) {
            world.func_175656_a(blockPos, Oxidizable.getUnaffectedOxidationState(world.func_180495_p(blockPos)));
            BlockPos.Mutable mutable = pos.func_239590_i_();
            int maxCleanRadius = world.field_73012_v.nextInt(3) + 3;
            for (int radius = 0; radius < maxCleanRadius; ++radius) {
                int count = world.field_73012_v.nextInt(8) + 1;
                LightningBoltEntityMixin.cleanOxidizationAround(world, blockPos, mutable, count);
            }
        }
    }

    @Unique
    private static void cleanOxidizationAround(World world, BlockPos pos, BlockPos.Mutable mutable, int count) {
        Optional<BlockPos> blockPos;
        mutable.func_189533_g((Vector3i)pos);
        for (int index = 0; index < count && (blockPos = LightningBoltEntityMixin.cleanOxidizationAround(world, (BlockPos)mutable)).isPresent(); ++index) {
            mutable.func_189533_g((Vector3i)blockPos.get());
        }
    }

    @Unique
    private static Optional<BlockPos> cleanOxidizationAround(World world, BlockPos pos) {
        for (BlockPos blockPos : BlockPosUtils.iterateRandomly(world.field_73012_v, 10, pos, 1)) {
            BlockState state = world.func_180495_p(blockPos);
            if (!(state.func_177230_c() instanceof Oxidizable)) continue;
            Oxidizable.getDecreasedOxidationState(state).ifPresent(stateIn -> world.func_175656_a(blockPos, stateIn));
            WorldUtils.syncWorldEvent(world, 3002, blockPos, -1);
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }
}

