/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.core.common.item;

import com.blackgear.cavesandcliffs.core.registries.CCBSoundEvents;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DeadCoralWallFanBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BoneMealItem.class})
public abstract class BoneMealItemMixin
extends Item {
    @Shadow
    public static boolean applyBonemeal(ItemStack stack, World worldIn, BlockPos pos, PlayerEntity player) {
        IGrowable igrowable;
        BlockState blockstate = worldIn.func_180495_p(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)worldIn, (BlockPos)pos, (BlockState)blockstate, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (blockstate.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)blockstate.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos, blockstate, worldIn.field_72995_K)) {
            if (worldIn instanceof ServerWorld) {
                if (igrowable.func_180670_a(worldIn, worldIn.field_73012_v, pos, blockstate)) {
                    igrowable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, blockstate);
                }
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    @Shadow
    public static boolean func_203173_b(ItemStack stack, World worldIn, BlockPos pos, @Nullable Direction side) {
        if (worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) && worldIn.func_204610_c(pos).func_206882_g() == 8) {
            if (worldIn instanceof ServerWorld) {
                block0: for (int i = 0; i < 128; ++i) {
                    BlockPos blockpos = pos;
                    BlockState blockstate = Blocks.field_203198_aQ.func_176223_P();
                    for (int j = 0; j < i / 16; ++j) {
                        if (worldIn.func_180495_p(blockpos = blockpos.func_177982_a(field_77697_d.nextInt(3) - 1, (field_77697_d.nextInt(3) - 1) * field_77697_d.nextInt(3) / 2, field_77697_d.nextInt(3) - 1)).func_235785_r_((IBlockReader)worldIn, blockpos)) continue block0;
                    }
                    Optional optional = worldIn.func_242406_i(blockpos);
                    if (Objects.equals(optional, Optional.of(Biomes.field_203614_T)) || Objects.equals(optional, Optional.of(Biomes.field_203617_W))) {
                        if (i == 0 && side != null && side.func_176740_k().func_176722_c()) {
                            blockstate = (BlockState)((Block)BlockTags.field_211922_B.func_205596_a(worldIn.field_73012_v)).func_176223_P().func_206870_a((Property)DeadCoralWallFanBlock.field_211884_b, (Comparable)side);
                        } else if (field_77697_d.nextInt(4) == 0) {
                            blockstate = ((Block)BlockTags.field_212741_H.func_205596_a(field_77697_d)).func_176223_P();
                        }
                    }
                    if (blockstate.func_177230_c().func_203417_a((ITag)BlockTags.field_211922_B)) {
                        for (int k = 0; !blockstate.func_196955_c((IWorldReader)worldIn, blockpos) && k < 4; ++k) {
                            blockstate = (BlockState)blockstate.func_206870_a((Property)DeadCoralWallFanBlock.field_211884_b, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(field_77697_d));
                        }
                    }
                    if (!blockstate.func_196955_c((IWorldReader)worldIn, blockpos)) continue;
                    BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                    if (blockstate1.func_203425_a(Blocks.field_150355_j) && worldIn.func_204610_c(blockpos).func_206882_g() == 8) {
                        worldIn.func_180501_a(blockpos, blockstate, 3);
                        continue;
                    }
                    if (!blockstate1.func_203425_a(Blocks.field_203198_aQ) || field_77697_d.nextInt(10) != 0) continue;
                    ((IGrowable)Blocks.field_203198_aQ).func_225535_a_((ServerWorld)worldIn, field_77697_d, blockpos, blockstate1);
                }
                stack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    public BoneMealItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Inject(method={"onItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOn(ItemUseContext context, CallbackInfoReturnable<ActionResultType> info) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockPos facingPos = pos.func_177972_a(context.func_196000_l());
        if (BoneMealItemMixin.applyBonemeal(context.func_195996_i(), world, pos, context.func_195999_j())) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, pos, 0);
                world.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.ITEM_BONEMEAL_USE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            info.setReturnValue((Object)ActionResultType.func_233537_a_((boolean)world.field_72995_K));
        } else {
            BlockState blockstate = world.func_180495_p(pos);
            boolean flag = blockstate.func_224755_d((IBlockReader)world, pos, context.func_196000_l());
            if (flag && BoneMealItemMixin.func_203173_b(context.func_195996_i(), world, facingPos, context.func_196000_l())) {
                if (!world.field_72995_K) {
                    world.func_217379_c(2005, facingPos, 0);
                    world.func_184133_a(null, pos, (SoundEvent)CCBSoundEvents.ITEM_BONEMEAL_USE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                }
                info.setReturnValue((Object)ActionResultType.func_233537_a_((boolean)world.field_72995_K));
            } else {
                info.setReturnValue((Object)ActionResultType.PASS);
            }
        }
    }
}

