/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.core.common.item;

import com.blackgear.cavesandcliffs.common.blocks.CandleBlock;
import com.blackgear.cavesandcliffs.common.blocks.CandleCakeBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.FireChargeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireChargeItem.class})
public class FireChargeItemMixin
extends Item {
    public FireChargeItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Inject(method={"onItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void useOn(ItemUseContext context, CallbackInfoReturnable<ActionResultType> info) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        boolean canBeUsed = false;
        if (CandleBlock.canBeLit(state) || CandleCakeBlock.canBeLit(state)) {
            this.playUseSound(world, pos);
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)));
            canBeUsed = true;
        }
        if (canBeUsed) {
            context.func_195996_i().func_190918_g(1);
            info.setReturnValue((Object)ActionResultType.SUCCESS);
        }
    }

    private void playUseSound(World worldIn, BlockPos pos) {
        worldIn.func_184133_a(null, pos, SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 1.0f, (field_77697_d.nextFloat() - field_77697_d.nextFloat()) * 0.2f + 1.0f);
    }
}

