/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.cavesandcliffs.mixin.core.common.world.gen;

import com.blackgear.cavesandcliffs.common.blocks.AbstractCauldronBlock;
import com.blackgear.cavesandcliffs.core.registries.CCBPointsOfInterest;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerWorld.class})
public abstract class ServerWorldMixin
extends World {
    protected ServerWorldMixin(ISpawnWorldInfo worldInfo, RegistryKey<World> dimension, DimensionType dimensionType, Supplier<IProfiler> profiler, boolean isRemote, boolean isDebug, long seed) {
        super(worldInfo, dimension, dimensionType, profiler, isRemote, isDebug, seed);
    }

    @Shadow
    public abstract PointOfInterestManager func_217443_B();

    @Shadow
    public abstract ServerWorld func_201672_e();

    @Inject(method={"tickEnvironment(Lnet/minecraft/world/chunk/Chunk;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickEnvironment(Chunk chunkIn, int randomTickSpeed, CallbackInfo info) {
        ChunkPos chunkPos = chunkIn.func_76632_l();
        boolean isRaining = this.func_72896_J();
        int x = chunkPos.func_180334_c();
        int z = chunkPos.func_180333_d();
        IProfiler iProfiler = this.func_217381_Z();
        iProfiler.func_219895_b("iceandsnow");
        if (this.field_73012_v.nextInt(16) == 0) {
            BlockPos blockHeight = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_217383_a(x, 0, z, 15));
            BlockPos below = blockHeight.func_177977_b();
            Biome biome = this.func_226691_t_(blockHeight);
            if (biome.func_201848_a((IWorldReader)((ServerWorld)this), below)) {
                this.func_175656_a(below, Blocks.field_150432_aD.func_176223_P());
            }
            if (isRaining) {
                if (biome.func_201850_b((IWorldReader)((ServerWorld)this), blockHeight)) {
                    this.func_175656_a(blockHeight, Blocks.field_150433_aE.func_176223_P());
                }
                BlockState state = this.func_180495_p(below);
                Biome.RainType rainType = this.func_226691_t_(below).func_201851_b();
                if (state.func_177230_c() instanceof AbstractCauldronBlock) {
                    ((AbstractCauldronBlock)state.func_177230_c()).handlePrecipitation(state, (World)((ServerWorld)this), below, rainType);
                } else {
                    this.func_180495_p(below).func_177230_c().func_176224_k((World)((ServerWorld)this), below);
                }
            }
        }
    }

    private Optional<BlockPos> findLightningRod(BlockPos pos) {
        Optional<BlockPos> isLightningRodPos = this.getNearestPosition(this.func_217443_B(), pointOfInterestType -> pointOfInterestType == CCBPointsOfInterest.LIGHTNING_ROD.get(), blockPos -> blockPos.func_177956_o() == this.func_201672_e().func_201676_a(Heightmap.Type.WORLD_SURFACE, blockPos.func_177958_n(), blockPos.func_177952_p()) - 1, pos, 128, PointOfInterestManager.Status.ANY);
        return isLightningRodPos.map(blockPos -> blockPos.func_177981_b(1));
    }

    @Inject(method={"adjustPosToNearbyEntity(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/util/math/BlockPos;"}, at={@At(value="HEAD", shift=At.Shift.AFTER)}, cancellable=true)
    private void adjustPosToNearbyEntity(BlockPos pos, CallbackInfoReturnable<BlockPos> cir) {
        BlockPos height = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos);
        Optional<BlockPos> lightningRodPos = this.findLightningRod(height);
        if (lightningRodPos.isPresent()) {
            cir.setReturnValue((Object)lightningRodPos.get());
        } else {
            AxisAlignedBB range = new AxisAlignedBB(height, new BlockPos(height.func_177958_n(), this.func_217301_I(), height.func_177952_p())).func_186662_g(3.0);
            List entities = this.func_175647_a(LivingEntity.class, range, entity -> entity != null && entity.func_70089_S() && this.func_226660_f_(entity.func_233580_cy_()));
            if (!entities.isEmpty()) {
                cir.setReturnValue((Object)((LivingEntity)entities.get(this.field_73012_v.nextInt(entities.size()))).func_233580_cy_());
            } else {
                if (height.func_177956_o() == -1) {
                    height = height.func_177981_b(2);
                }
                cir.setReturnValue((Object)height);
            }
        }
    }

    @Unique
    public Optional<BlockPos> getNearestPosition(PointOfInterestManager manager, Predicate<PointOfInterestType> typePredicate, Predicate<BlockPos> posPredicate, BlockPos pos, int distance, PointOfInterestManager.Status status) {
        return manager.func_219146_b(typePredicate, pos, distance, status).map(PointOfInterest::func_218261_f).filter(posPredicate).min(Comparator.comparingDouble(posX -> posX.func_177951_i((Vector3i)pos)));
    }
}

