/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials;

import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.command.TPACommands;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Path;
import java.util.Iterator;
import me.shedaniel.architectury.hooks.LevelResourceHooks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.storage.FolderName;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;

@Mod.EventBusSubscriber(modid="ftbessentials", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FTBEEventHandler {
    public static final FolderName CONFIG_FILE = LevelResourceHooks.create((String)"serverconfig/ftbessentials.snbt");
    public static final Style RECORDING_STYLE = Style.field_240709_b_.func_240721_b_(TextFormatting.RED);
    public static final Style STREAMING_STYLE = Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)9520895));

    @SubscribeEvent
    public static void serverAboutToStart(FMLServerAboutToStartEvent event) {
        FTBEConfig.CONFIG.load(event.getServer().func_240776_a_(CONFIG_FILE));
        FTBEPlayerData.MAP.clear();
        FTBEWorldData.instance = new FTBEWorldData(event.getServer());
        try {
            SNBTCompoundTag tag = SNBT.read((Path)FTBEWorldData.instance.mkdirs("").resolve("data.snbt"));
            if (tag != null) {
                FTBEWorldData.instance.read(tag);
            }
        }
        catch (Exception ex) {
            FTBEssentials.LOGGER.error("Failed to load world data: " + ex);
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void serverStopped(FMLServerStoppedEvent event) {
        FTBEWorldData.instance = null;
        TPACommands.REQUESTS.clear();
    }

    @SubscribeEvent
    public static void worldSaved(WorldEvent.Save event) {
        if (FTBEWorldData.instance != null && FTBEWorldData.instance.save && SNBT.write((Path)FTBEWorldData.instance.mkdirs("").resolve("data.snbt"), (CompoundNBT)FTBEWorldData.instance.write())) {
            FTBEWorldData.instance.save = false;
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        FTBEPlayerData data = FTBEPlayerData.get(event.getPlayer());
        data.lastSeen = new TeleportPos((Entity)event.getPlayer());
        data.save();
        for (FTBEPlayerData d : FTBEPlayerData.MAP.values()) {
            d.sendTabName((ServerPlayerEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        FTBEPlayerData data = FTBEPlayerData.get(event.getPlayer());
        data.lastSeen = new TeleportPos((Entity)event.getPlayer());
        data.save();
    }

    @SubscribeEvent
    public static void playerLoad(PlayerEvent.LoadFromFile event) {
        if (FTBEWorldData.instance != null) {
            FTBEPlayerData.get(event.getPlayer()).load();
        }
    }

    @SubscribeEvent
    public static void playerSaved(PlayerEvent.SaveToFile event) {
        if (FTBEWorldData.instance != null) {
            FTBEPlayerData.get(event.getPlayer()).saveNow();
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player instanceof ServerPlayerEntity) {
            FTBEPlayerData data = FTBEPlayerData.get(event.player);
            if (data.god && !event.player.field_71075_bZ.field_75102_a) {
                event.player.field_71075_bZ.field_75102_a = true;
                event.player.func_71016_p();
            }
            if (data.fly && !event.player.field_71075_bZ.field_75101_c) {
                event.player.field_71075_bZ.field_75101_c = true;
                event.player.func_71016_p();
            }
        }
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            long now = System.currentTimeMillis();
            Iterator<TPACommands.TPARequest> iterator = TPACommands.REQUESTS.values().iterator();
            while (iterator.hasNext()) {
                TPACommands.TPARequest r = iterator.next();
                if (now <= r.created + 60000L) continue;
                ServerPlayerEntity source = r.server.func_184103_al().func_177451_a(r.source.uuid);
                ServerPlayerEntity target = r.server.func_184103_al().func_177451_a(r.target.uuid);
                if (source != null) {
                    source.func_145747_a((ITextComponent)new StringTextComponent("TPA request expired!"), Util.field_240973_b_);
                }
                if (target != null) {
                    target.func_145747_a((ITextComponent)new StringTextComponent("TPA request expired!"), Util.field_240973_b_);
                }
                iterator.remove();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerServerChatHighest(ServerChatEvent event) {
        FTBEPlayerData data = FTBEPlayerData.get((PlayerEntity)event.getPlayer());
        if (data.muted) {
            event.setCanceled(true);
            event.getPlayer().func_146105_b((ITextComponent)new StringTextComponent("You can't use chat, you've been muted by an admin!").func_240699_a_(TextFormatting.RED), false);
        }
    }

    @SubscribeEvent
    public static void playerName(PlayerEvent.NameFormat event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            FTBEPlayerData data = FTBEPlayerData.get(event.getPlayer());
            if (!data.nick.isEmpty()) {
                event.setDisplayname((ITextComponent)new StringTextComponent(data.nick));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void playerNameLow(PlayerEvent.NameFormat event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            FTBEPlayerData data = FTBEPlayerData.get(event.getPlayer());
            if (data.recording > 0) {
                event.setDisplayname((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)new StringTextComponent("\u23fa").func_240703_c_(data.recording == 1 ? RECORDING_STYLE : STREAMING_STYLE)).func_240702_b_(" ").func_230529_a_(event.getDisplayname()));
            }
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            FTBEPlayerData.addTeleportHistory((ServerPlayerEntity)event.getEntity());
        }
    }
}

