/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.integration.waila;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.api.impl.config.WailaConfig;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class HUDHandlerGraveStone
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    static final ResourceLocation CONFIG_SHOW_REGISTRY = new ResourceLocation("waila", "show_registry");
    static final ResourceLocation REGISTRY_NAME_TAG = new ResourceLocation("waila", "registry_name");
    static final HUDHandlerGraveStone INSTANCE = new HUDHandlerGraveStone();

    public void appendHead(List<ITextComponent> t, IDataAccessor accessor, IPluginConfig config) {
        ITaggableList tooltip = (ITaggableList)t;
        tooltip.setTag((Object)OBJECT_NAME_TAG, (Object)new StringTextComponent(String.format(((WailaConfig)Waila.CONFIG.get()).getFormatting().getBlockName(), ((GraveStoneTileEntity)accessor.getTileEntity()).func_200200_C_().getString())));
        if (config.get(CONFIG_SHOW_REGISTRY)) {
            tooltip.setTag((Object)REGISTRY_NAME_TAG, (Object)new StringTextComponent(accessor.getBlock().getRegistryName().toString()).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        CompoundNBT data;
        if (!(accessor.getTileEntity() instanceof GraveStoneTileEntity)) {
            return;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)accessor.getTileEntity();
        IFormattableTextComponent time = GraveUtils.getDate(grave.getDeath().getTimestamp());
        if (time != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("message.gravestone.date_of_death", new Object[]{time}));
        }
        if ((data = accessor.getServerData()).func_74764_b("ItemCount")) {
            tooltip.add((ITextComponent)new TranslationTextComponent("message.gravestone.item_count", new Object[]{data.func_74762_e("ItemCount")}));
        }
    }

    public void appendServerData(CompoundNBT compoundNBT, ServerPlayerEntity serverPlayerEntity, World world, TileEntity grave) {
        Death death = ((GraveStoneTileEntity)grave).getDeath();
        compoundNBT.func_74768_a("ItemCount", (int)death.getAllItems().stream().filter(itemStack -> !itemStack.func_190926_b()).count());
    }
}

