/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.world.SimplexNoise;
import biomesoplenty.common.world.layer.traits.IBOPAreaTransformer0;
import biomesoplenty.common.world.layer.traits.IBOPContextExtended;
import java.util.Random;

public enum RainfallNoiseLayer implements IBOPAreaTransformer0
{
    SMALL_ZONES(0.16),
    MEDIUM_ZONES(0.06),
    LARGE_ZONES(0.01);

    private final double scale;
    private long seed;
    private double xOffset;
    private double zOffset;

    private RainfallNoiseLayer(double scale) {
        this.scale = scale;
    }

    @Override
    public int applyPixel(IBOPContextExtended context, int x, int z) {
        double noiseVal;
        long seed = context.getWorldSeed();
        if (this.seed != seed) {
            Random random = new Random(seed - 123L);
            this.xOffset = (random.nextDouble() - 0.5) * 8192.0;
            this.zOffset = (random.nextDouble() - 0.5) * 8192.0;
            this.seed = seed;
        }
        if ((noiseVal = SimplexNoise.noise(((double)x + this.xOffset) * this.scale, ((double)z + this.zOffset) * this.scale)) < -0.637) {
            return 0;
        }
        if (noiseVal < -0.575) {
            return 1;
        }
        if (noiseVal < -0.465) {
            return 2;
        }
        if (noiseVal < -0.295) {
            return 3;
        }
        if (noiseVal < -0.148) {
            return 4;
        }
        if (noiseVal < -0.034) {
            return 5;
        }
        if (noiseVal < 0.132) {
            return 6;
        }
        if (noiseVal < 0.246) {
            return 7;
        }
        if (noiseVal < 0.4) {
            return 8;
        }
        if (noiseVal < 0.551) {
            return 9;
        }
        if (noiseVal < 0.634) {
            return 10;
        }
        return 11;
    }
}

