/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render.layer;

import com.github.alexthe666.alexsmobs.client.model.ModelKangaroo;
import com.github.alexthe666.alexsmobs.client.render.RenderKangaroo;
import com.github.alexthe666.alexsmobs.entity.EntityKangaroo;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.ForgeHooksClient;

public class LayerKangarooArmor
extends LayerRenderer<EntityKangaroo, ModelKangaroo> {
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();
    private final BipedModel defaultBipedModel = new BipedModel(1.0f);
    private RenderKangaroo renderer;

    public LayerKangarooArmor(RenderKangaroo render) {
        super((IEntityRenderer)render);
        this.renderer = render;
    }

    public static ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntityKangaroo roo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.func_227860_a_();
        if (roo.isRoger()) {
            ItemStack haloStack = new ItemStack((IItemProvider)AMItemRegistry.HALO);
            matrixStackIn.func_227860_a_();
            this.translateToHead(matrixStackIn);
            float f = 0.1f * (float)Math.sin(((float)roo.field_70173_aa + partialTicks) * 0.1f) + (roo.func_70631_g_() ? 0.2f : 0.0f);
            matrixStackIn.func_227861_a_(0.0, (double)(-0.75f - f), (double)-0.2f);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStackIn.func_227862_a_(1.3f, 1.3f, 1.3f);
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)roo, haloStack, ItemCameraTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.func_227865_b_();
        }
        if (!roo.func_70631_g_()) {
            ArmorItem armoritem;
            float f2;
            float f1;
            float f;
            int i;
            int clampedLight;
            boolean flag1;
            boolean notAVanillaModel;
            BipedModel<?> a;
            matrixStackIn.func_227860_a_();
            ItemStack itemstack = roo.func_184582_a(EquipmentSlotType.HEAD);
            if (itemstack.func_77973_b() instanceof ArmorItem) {
                ArmorItem armoritem2 = (ArmorItem)itemstack.func_77973_b();
                if (itemstack.canEquip(EquipmentSlotType.HEAD, (Entity)roo)) {
                    a = this.defaultBipedModel;
                    notAVanillaModel = (a = this.getArmorModelHook((LivingEntity)roo, itemstack, EquipmentSlotType.HEAD, (BipedModel)a)) != this.defaultBipedModel;
                    this.setModelSlotVisible(a, EquipmentSlotType.HEAD);
                    this.translateToHead(matrixStackIn);
                    matrixStackIn.func_227861_a_(0.0, (double)0.015f, (double)-0.05f);
                    if (itemstack.func_77973_b() == AMItemRegistry.FEDORA) {
                        matrixStackIn.func_227861_a_(0.0, (double)0.05f, 0.0);
                    }
                    matrixStackIn.func_227862_a_(0.7f, 0.7f, 0.7f);
                    flag1 = itemstack.func_77962_s();
                    clampedLight = packedLightIn;
                    if (armoritem2 instanceof IDyeableArmorItem) {
                        i = ((IDyeableArmorItem)armoritem2).func_200886_f(itemstack);
                        f = (float)(i >> 16 & 0xFF) / 255.0f;
                        f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                        f2 = (float)(i & 0xFF) / 255.0f;
                        this.renderHelmet(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlotType.HEAD, null), notAVanillaModel);
                        this.renderHelmet(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlotType.HEAD, "overlay"), notAVanillaModel);
                    } else {
                        this.renderHelmet(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlotType.HEAD, null), notAVanillaModel);
                    }
                }
            } else {
                this.translateToHead(matrixStackIn);
                matrixStackIn.func_227861_a_(0.0, -0.2, (double)-0.1f);
                matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 180.0f, true));
                matrixStackIn.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
                matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
                Minecraft.func_71410_x().func_175599_af().func_229110_a_(itemstack, ItemCameraTransforms.TransformType.FIXED, packedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
            }
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227860_a_();
            itemstack = roo.func_184582_a(EquipmentSlotType.CHEST);
            if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == EquipmentSlotType.CHEST) {
                a = this.defaultBipedModel;
                notAVanillaModel = (a = this.getArmorModelHook((LivingEntity)roo, itemstack, EquipmentSlotType.CHEST, (BipedModel)a)) != this.defaultBipedModel;
                this.setModelSlotVisible(a, EquipmentSlotType.CHEST);
                this.translateToChest(matrixStackIn);
                matrixStackIn.func_227861_a_(0.0, 0.25, 0.0);
                matrixStackIn.func_227862_a_(1.0f, 1.0f, 1.0f);
                flag1 = itemstack.func_77962_s();
                clampedLight = packedLightIn;
                if (armoritem instanceof IDyeableArmorItem) {
                    i = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                    f = (float)(i >> 16 & 0xFF) / 255.0f;
                    f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    f2 = (float)(i & 0xFF) / 255.0f;
                    this.renderChestplate(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, f, f1, f2, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlotType.CHEST, null), notAVanillaModel);
                    this.renderChestplate(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlotType.CHEST, "overlay"), notAVanillaModel);
                } else {
                    this.renderChestplate(roo, matrixStackIn, bufferIn, clampedLight, flag1, a, 1.0f, 1.0f, 1.0f, LayerKangarooArmor.getArmorResource((Entity)roo, itemstack, EquipmentSlotType.CHEST, null), notAVanillaModel);
                }
            }
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
    }

    private void translateToHead(MatrixStack matrixStackIn) {
        this.translateToChest(matrixStackIn);
        ((ModelKangaroo)this.renderer.func_217764_d()).neck.func_228307_a_(matrixStackIn);
        ((ModelKangaroo)this.renderer.func_217764_d()).head.func_228307_a_(matrixStackIn);
    }

    private void translateToChest(MatrixStack matrixStackIn) {
        ((ModelKangaroo)this.renderer.func_217764_d()).root.func_228307_a_(matrixStackIn);
        ((ModelKangaroo)this.renderer.func_217764_d()).body.func_228307_a_(matrixStackIn);
        ((ModelKangaroo)this.renderer.func_217764_d()).chest.func_228307_a_(matrixStackIn);
    }

    private void renderChestplate(EntityKangaroo entity, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, boolean glintIn, BipedModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228640_c_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        ((ModelKangaroo)this.renderer.func_217764_d()).func_217111_a((EntityModel)modelIn);
        float sitProgress = entity.prevSitProgress + (entity.sitProgress - entity.prevSitProgress) * Minecraft.func_71410_x().func_184121_ak();
        modelIn.field_78115_e.field_78795_f = 1.5707964f;
        modelIn.field_78115_e.field_78796_g = 0.0f;
        modelIn.field_78115_e.field_78808_h = 0.0f;
        modelIn.field_78115_e.field_78800_c = 0.0f;
        modelIn.field_78115_e.field_78797_d = 0.25f;
        modelIn.field_78115_e.field_78798_e = -7.6f;
        modelIn.field_178723_h.func_217177_a((ModelRenderer)((ModelKangaroo)this.renderer.func_217764_d()).arm_right);
        modelIn.field_178724_i.func_217177_a((ModelRenderer)((ModelKangaroo)this.renderer.func_217764_d()).arm_left);
        modelIn.field_178724_i.field_78797_d = ((ModelKangaroo)this.renderer.func_217764_d()).arm_left.field_78797_d - 4.0f + sitProgress * 0.25f;
        modelIn.field_178723_h.field_78797_d = ((ModelKangaroo)this.renderer.func_217764_d()).arm_right.field_78797_d - 4.0f + sitProgress * 0.25f;
        modelIn.field_178724_i.field_78798_e = ((ModelKangaroo)this.renderer.func_217764_d()).arm_left.field_78798_e - 0.5f;
        modelIn.field_178723_h.field_78798_e = ((ModelKangaroo)this.renderer.func_217764_d()).arm_right.field_78798_e - 0.5f;
        modelIn.field_78115_e.field_78806_j = false;
        modelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
        modelIn.field_78115_e.field_78806_j = true;
        modelIn.field_178723_h.field_78806_j = false;
        modelIn.field_178724_i.field_78806_j = false;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(1.1f, 1.65f, 1.1f);
        modelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
        matrixStackIn.func_227865_b_();
        modelIn.field_178723_h.field_78806_j = true;
        modelIn.field_178724_i.field_78806_j = true;
    }

    private void renderHelmet(EntityKangaroo entity, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, boolean glintIn, BipedModel modelIn, float red, float green, float blue, ResourceLocation armorResource, boolean notAVanillaModel) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)RenderType.func_228640_c_((ResourceLocation)armorResource), (boolean)false, (boolean)glintIn);
        ((ModelKangaroo)this.renderer.func_217764_d()).func_217111_a((EntityModel)modelIn);
        modelIn.field_78116_c.field_78795_f = 0.0f;
        modelIn.field_78116_c.field_78796_g = 0.0f;
        modelIn.field_78116_c.field_78808_h = 0.0f;
        modelIn.field_178720_f.field_78795_f = 0.0f;
        modelIn.field_178720_f.field_78796_g = 0.0f;
        modelIn.field_178720_f.field_78808_h = 0.0f;
        modelIn.field_78116_c.field_78800_c = 0.0f;
        modelIn.field_78116_c.field_78797_d = 0.0f;
        modelIn.field_78116_c.field_78798_e = 0.0f;
        modelIn.field_178720_f.field_78800_c = 0.0f;
        modelIn.field_178720_f.field_78797_d = 0.0f;
        modelIn.field_178720_f.field_78798_e = 0.0f;
        modelIn.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, red, green, blue, 1.0f);
    }

    protected void setModelSlotVisible(BipedModel p_188359_1_, EquipmentSlotType slotIn) {
        this.setModelVisible(p_188359_1_);
        switch (slotIn) {
            case HEAD: {
                p_188359_1_.field_78116_c.field_78806_j = true;
                p_188359_1_.field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178723_h.field_78806_j = true;
                p_188359_1_.field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                p_188359_1_.field_78115_e.field_78806_j = true;
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                p_188359_1_.field_178721_j.field_78806_j = true;
                p_188359_1_.field_178722_k.field_78806_j = true;
            }
        }
    }

    protected void setModelVisible(BipedModel model) {
        model.func_178719_a(false);
    }

    protected BipedModel<?> getArmorModelHook(LivingEntity entity, ItemStack itemStack, EquipmentSlotType slot, BipedModel model) {
        return ForgeHooksClient.getArmorModel((LivingEntity)entity, (ItemStack)itemStack, (EquipmentSlotType)slot, (BipedModel)model);
    }
}

