/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.world;

import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class AMWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "alexsmobs_world_data";
    private World world;
    private int tickCounter;
    private int beachedCachalotSpawnDelay;
    private int beachedCachalotSpawnChance;
    private UUID beachedCachalotID;

    public AMWorldData() {
        super(IDENTIFIER);
    }

    public static AMWorldData get(World world) {
        if (world instanceof ServerWorld) {
            ServerWorld overworld = world.func_73046_m().func_71218_a(World.field_234918_g_);
            DimensionSavedDataManager storage = overworld.func_217481_x();
            AMWorldData data = (AMWorldData)storage.func_215752_a(AMWorldData::new, IDENTIFIER);
            if (data != null) {
                data.world = world;
                data.func_76185_a();
            }
            return data;
        }
        return null;
    }

    public int getBeachedCachalotSpawnDelay() {
        return this.beachedCachalotSpawnDelay;
    }

    public void setBeachedCachalotSpawnDelay(int delay) {
        this.beachedCachalotSpawnDelay = delay;
    }

    public int getBeachedCachalotSpawnChance() {
        return this.beachedCachalotSpawnChance;
    }

    public void setBeachedCachalotSpawnChance(int chance) {
        this.beachedCachalotSpawnChance = chance;
    }

    public void setBeachedCachalotID(UUID id) {
        this.beachedCachalotID = id;
    }

    public void debug() {
    }

    public void tick() {
        ++this.tickCounter;
    }

    public void func_76184_a(CompoundNBT nbt) {
        if (nbt.func_150297_b("BeachedCachalotSpawnDelay", 99)) {
            this.beachedCachalotSpawnDelay = nbt.func_74762_e("BeachedCachalotSpawnDelay");
        }
        if (nbt.func_150297_b("BeachedCachalotSpawnChance", 99)) {
            this.beachedCachalotSpawnChance = nbt.func_74762_e("BeachedCachalotSpawnChance");
        }
        if (nbt.func_150297_b("BeachedCachalotId", 8)) {
            this.beachedCachalotID = UUID.fromString(nbt.func_74779_i("BeachedCachalotId"));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74768_a("beachedCachalotSpawnDelay", this.beachedCachalotSpawnDelay);
        compound.func_74768_a("beachedCachalotSpawnChance", this.beachedCachalotSpawnChance);
        if (this.beachedCachalotID != null) {
            compound.func_74778_a("beachedCachalotId", this.beachedCachalotID.toString());
        }
        return compound;
    }
}

