/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.forge;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.item.FTBLibraryItems;
import dev.ftb.mods.ftblibrary.item.forge.FluidContainerItem;
import dev.ftb.mods.ftblibrary.util.forge.FluidKey;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ftblibrary", bus=Mod.EventBusSubscriber.Bus.MOD)
public class FTBLibraryForgeClientEventHandler {
    private static final Map<FluidKey, Integer> fluidColorCache = new HashMap<FluidKey, Integer>();

    @SubscribeEvent
    public static void colorRegistry(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((stack, i) -> {
            if (i == 1) {
                FluidStack fluidStack = FluidContainerItem.getFluidStack(stack);
                Integer c = fluidColorCache.get(new FluidKey(fluidStack));
                if (c == null) {
                    c = FTBLibraryForgeClientEventHandler.calculateFluidColor(fluidStack);
                    fluidColorCache.put(new FluidKey(fluidStack.copy()), c);
                }
                return c;
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)FTBLibraryItems.FLUID_CONTAINER.get()});
    }

    private static int calculateFluidColor(FluidStack fluidStack) {
        Texture texture = Minecraft.func_71410_x().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b);
        if (!(texture instanceof AtlasTexture)) {
            return -65281;
        }
        TextureAtlasSprite sprite = ((AtlasTexture)texture).func_195424_a(fluidStack.getFluid().getAttributes().getStillTexture(fluidStack));
        if (sprite == null || sprite instanceof MissingTextureSprite || sprite.func_110970_k() == 0) {
            return -65281;
        }
        Color4I col = Color4I.rgb(fluidStack.getFluid().getAttributes().getColor(fluidStack));
        float[] rgba = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        float tintR = col.redf();
        float tintG = col.greenf();
        float tintB = col.bluef();
        for (int frame = 0; frame < sprite.func_110970_k(); ++frame) {
            for (int y = 0; y < sprite.func_94216_b(); ++y) {
                for (int x = 0; x < sprite.func_94211_a(); ++x) {
                    int color = sprite.getPixelRGBA(frame, x, y);
                    float a = (float)NativeImage.func_227786_a_((int)color) / 255.0f;
                    if (!(a > 0.0f)) continue;
                    rgba[0] = rgba[0] + (float)NativeImage.func_227791_b_((int)color) / 255.0f * tintR;
                    rgba[1] = rgba[1] + (float)NativeImage.func_227793_c_((int)color) / 255.0f * tintG;
                    rgba[2] = rgba[2] + (float)NativeImage.func_227795_d_((int)color) / 255.0f * tintB;
                    rgba[3] = rgba[3] + a;
                }
            }
        }
        if (rgba[3] == 0.0f) {
            return -65281;
        }
        return Color4I.rgba((int)(rgba[0] * 255.0f / rgba[3]), (int)(rgba[1] * 255.0f / rgba[3]), (int)(rgba[2] * 255.0f / rgba[3]), 255).rgba();
    }
}

