/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.RightClickOption;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointMenuElement;
import xaero.map.mods.gui.WaypointSymbolCreator;

public class Waypoint
extends WaypointMenuElement
implements Comparable<Waypoint>,
IRightClickableElement {
    private Object original;
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private int x;
    private int y;
    private int z;
    private String text;
    private String symbol;
    private int color;
    private boolean disabled = false;
    private int type = 0;
    private boolean rotation = false;
    private int yaw = 0;
    private float destAlpha = 0.0f;
    private float alpha = 0.0f;
    private SlowingAnimation alphaAnim = null;
    private boolean editable;
    private boolean temporary;
    private boolean global;
    private String setName;
    private boolean yIncluded;
    private ArrayList<RightClickOption> rightClickOptions;

    public Waypoint(Object original, int x, int y, int z, String name, String symbol, int color, int type, boolean editable, String setName, boolean yIncluded) {
        this.original = original;
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.text = name;
        this.editable = editable;
        this.setName = setName;
        this.yIncluded = yIncluded;
        this.rightClickOptions = new ArrayList();
        this.rightClickOptions.add(new RightClickOption(name, this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
            }
        });
        if (!SupportMods.xaeroMinimap.hidingWaypointCoordinates()) {
            this.rightClickOptions.add(new RightClickOption(String.format("X: %d, Y: %s, Z: %d", x, this.yIncluded ? "" + y : "~", z), this.rightClickOptions.size(), this){

                @Override
                public void onAction(Screen screen) {
                    SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
                }
            });
        }
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_edit", this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.openWaypoint((GuiMap)screen, Waypoint.this);
            }
        }.setNameFormatArgs("E"));
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_teleport", this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.teleportToWaypoint(screen, Waypoint.this);
            }

            @Override
            public boolean isActive() {
                return SupportMods.xaeroMinimap.canTeleport();
            }
        }.setNameFormatArgs("T"));
        this.rightClickOptions.add(new RightClickOption("gui.xaero_right_click_waypoint_share", this.rightClickOptions.size(), this){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroMinimap.shareWaypoint(Waypoint.this, (GuiMap)screen);
            }
        });
        this.rightClickOptions.add(new RightClickOption("", this.rightClickOptions.size(), this){

            @Override
            public String getName() {
                return Waypoint.this.temporary ? "gui.xaero_right_click_waypoint_restore" : (Waypoint.this.disabled ? "gui.xaero_right_click_waypoint_enable" : "gui.xaero_right_click_waypoint_disable");
            }

            @Override
            public void onAction(Screen screen) {
                if (Waypoint.this.temporary) {
                    SupportMods.xaeroMinimap.toggleTemporaryWaypoint(Waypoint.this);
                } else {
                    SupportMods.xaeroMinimap.disableWaypoint(Waypoint.this);
                }
            }
        }.setNameFormatArgs("H"));
        this.rightClickOptions.add(new RightClickOption("", this.rightClickOptions.size(), this){

            @Override
            public String getName() {
                return Waypoint.this.temporary ? "gui.xaero_right_click_waypoint_delete_confirm" : "gui.xaero_right_click_waypoint_delete";
            }

            @Override
            public void onAction(Screen screen) {
                if (Waypoint.this.temporary) {
                    SupportMods.xaeroMinimap.deleteWaypoint(Waypoint.this);
                } else {
                    SupportMods.xaeroMinimap.toggleTemporaryWaypoint(Waypoint.this);
                }
            }
        }.setNameFormatArgs("DEL"));
    }

    public String getName() {
        return I18n.func_135052_a((String)this.text, (Object[])new Object[0]);
    }

    public void renderWaypoint(IVertexBuilder waypointNameBGConsumer, MultiTextureRenderTypeRenderer uniquePremultipliedTextureUIObjectRenderer, MatrixStack matrixStack, double wpScale, float x, float y, boolean viewing, TextureManager textureManager, FontRenderer fontRenderer, WaypointSymbolCreator symbolCreator, boolean renderBackground, IRenderTypeBuffer.Impl renderTypeBuffers) {
        int symbolFrameWidth;
        float visibilityAlpha = this.disabled ? 0.3f : 1.0f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 0.0);
        matrixStack.func_227862_a_((float)wpScale, (float)wpScale, 1.0f);
        matrixStack.func_227860_a_();
        int color = this.color;
        String symbol = this.symbol;
        int type = this.type;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (symbol.length() > 1) {
            flagU += 35;
            flagW += 13;
        }
        if (this.temporary) {
            flagU += 83;
        }
        matrixStack.func_227861_a_((double)((float)(-flagW) / 2.0f), (double)(-flagH + 1), 0.0);
        if (renderBackground) {
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.func_227866_c_().func_227870_a_(), uniquePremultipliedTextureUIObjectRenderer, 0, 0, flagU, flagV, flagW, flagH, red * visibilityAlpha, green * visibilityAlpha, blue * visibilityAlpha, visibilityAlpha, textureManager.func_229267_b_(WorldMap.guiTextures).func_110552_b());
        }
        matrixStack.func_227865_b_();
        float oldDestAlpha = this.destAlpha;
        this.destAlpha = viewing ? 255.0f : 0.0f;
        if (oldDestAlpha != this.destAlpha) {
            this.alphaAnim = new SlowingAnimation(this.alpha, this.destAlpha, 0.8, 1.0);
        }
        if (this.alphaAnim != null) {
            this.alpha = (float)this.alphaAnim.getCurrent();
        }
        float alpha = this.alpha;
        int symbolTexture = 0;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        int stringWidth = fontRenderer.func_78256_a(symbol);
        int n = symbolFrameWidth = stringWidth / 2 > 4 ? 64 : 32;
        if (type == 0 && alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolTexture = symbolCreator.getSymbolTexture(symbol);
        } else if (type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolTexture = symbolCreator.getDeathSymbolTexture();
        }
        if (symbolTexture != 0) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(-1.0f - (float)symbolWidth / 2.0f), (double)(32 + (renderBackground ? -43 + symbolVerticalOffset - 1 : -12)), 0.0);
            matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.func_227866_c_().func_227870_a_(), uniquePremultipliedTextureUIObjectRenderer, 0, 0, 0, 0, symbolFrameWidth, 32, visibilityAlpha, visibilityAlpha, visibilityAlpha, visibilityAlpha, symbolFrameWidth, 32, symbolTexture);
            matrixStack.func_227865_b_();
        }
        if ((int)alpha > 0) {
            int tc = (int)alpha << 24 | 0xFFFFFF;
            String name = this.getName();
            int len = fontRenderer.func_78256_a(name);
            matrixStack.func_227861_a_(0.0, (double)(renderBackground ? -38 : -11), 0.0);
            matrixStack.func_227862_a_(3.0f, 3.0f, 1.0f);
            int bgLen = Math.max(len + 2, 10);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), waypointNameBGConsumer, -bgLen / 2, -1, bgLen / 2, 9, red, green, blue, alpha / 255.0f);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), waypointNameBGConsumer, -bgLen / 2, -1, bgLen / 2, 8, 0.0f, 0.0f, 0.0f, alpha / 255.0f * 200.0f / 255.0f);
            if ((int)alpha > 3) {
                matrixStack.func_227861_a_(0.0, 0.0, 1.0);
                Misc.drawNormalText(matrixStack, name, (float)(-(len - 1)) / 2.0f, 0.0f, tc, false, renderTypeBuffers);
            }
        }
        matrixStack.func_227865_b_();
    }

    @Override
    public void renderInMenu(MatrixStack matrixStack, Screen gui, int x, int y, int mouseX, int mouseY, double scale, boolean elementEnabled, boolean hovered, Minecraft mc, boolean pressed) {
        RenderSystem.pushMatrix();
        if (hovered) {
            RenderSystem.translatef((float)(pressed ? 1.0f : 2.0f), (float)0.0f, (float)0.0f);
        }
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        RenderSystem.translatef((float)-4.0f, (float)-4.0f, (float)0.0f);
        RenderSystem.enableBlend();
        if (this.type == 1) {
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)this.color);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(minimapTextures);
            RenderSystem.color4f((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            gui.func_238474_b_(matrixStack, 1, 1, 0, 78, 9, 9);
            RenderSystem.color4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            gui.func_238474_b_(matrixStack, 0, 0, 0, 78, 9, 9);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            RenderSystem.disableTexture();
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)this.color);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.type == 0) {
            mc.field_71466_p.func_238405_a_(matrixStack, this.symbol, (float)(5 - mc.field_71466_p.func_78256_a(this.symbol) / 2), 1.0f, -1);
        }
        String name = this.getName();
        if (this.global) {
            name = "* " + name;
        }
        int len = mc.field_71466_p.func_78256_a(name);
        int textX = -3 - len;
        int infoIconWidth = 10;
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(textX - 2 - (this.disabled ? infoIconWidth : 0) - (this.temporary ? infoIconWidth : 0)), (int)-2, (int)(textX + len + 2), (int)11, (int)0x77000000);
        mc.field_71466_p.func_238405_a_(matrixStack, name, (float)textX, 0.0f, -1);
        RenderSystem.enableBlend();
        int infoIconOffset = infoIconWidth;
        if (this.disabled) {
            RenderSystem.enableTexture();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_238474_b_(matrixStack, textX - 1 - infoIconOffset, 0, 173, 16, 8, 8);
            infoIconOffset += infoIconWidth;
        }
        if (this.temporary) {
            RenderSystem.enableTexture();
            RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(WorldMap.guiTextures);
            gui.func_238474_b_(matrixStack, textX - 1 - infoIconOffset, 0, 165, 16, 8, 8);
            infoIconOffset += infoIconWidth;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void renderShadow(float brightness, IVertexBuilder regularUIObjectConsumer, MatrixStack matrixStack, double wpScale, float x, float y, TextureManager textureManager) {
        float visibilityAlpha = this.disabled ? 0.3f : 1.0f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 0.0);
        matrixStack.func_227862_a_((float)wpScale, (float)wpScale, 1.0f);
        matrixStack.func_227861_a_(-14.0, -41.0, 0.0);
        MapRenderHelper.blitIntoExistingBuffer(matrixStack.func_227866_c_().func_227870_a_(), regularUIObjectConsumer, 0, 19, 0, 117, 41, 22, 0.0f, 0.0f, 0.0f, brightness * visibilityAlpha);
        matrixStack.func_227865_b_();
    }

    @Override
    public int compareTo(Waypoint arg0) {
        return this.z > arg0.z ? 1 : (this.z != arg0.z ? -1 : 0);
    }

    public String toString() {
        return this.getName();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public int getType() {
        return this.type;
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Object getOriginal() {
        return this.original;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    @Override
    public int getLeftSideLength(Minecraft mc) {
        return 9 + mc.field_71466_p.func_78256_a(this.getName());
    }

    public String getSetName() {
        return this.setName;
    }

    public String getComparisonName() {
        String comparisonName = this.getName().toLowerCase().trim();
        if (comparisonName.startsWith("the ")) {
            comparisonName = comparisonName.substring(4);
        }
        if (comparisonName.startsWith("a ")) {
            comparisonName = comparisonName.substring(2);
        }
        return comparisonName;
    }

    @Override
    public ArrayList<RightClickOption> getRightClickOptions() {
        return this.rightClickOptions;
    }

    @Override
    public boolean isRightClickValid() {
        return SupportMods.xaeroMinimap.waypointExists(this);
    }

    @Override
    public int getRightClickTitleBackgroundColor() {
        return this.color;
    }
}

