/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.MusketMod;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class BulletEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    public static final double MIN_DAMAGE = 0.5;
    public static final double GRAVITY = 0.05;
    public static final double AIR_FRICTION = 0.99;
    public static final double WATER_FRICTION = 0.6;
    public static final short LIFETIME = 50;
    public static double maxDistance;
    public float damageMultiplier;
    public float distanceTravelled;
    public short tickCounter;

    public BulletEntity(World world) {
        super(MusketMod.BULLET_ENTITY_TYPE, world);
    }

    public BulletEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this(world);
    }

    public boolean isFirstTick() {
        return this.tickCounter == 0;
    }

    public Entity getShooter() {
        return super.func_234616_v_();
    }

    public DamageSource causeMusketDamage(BulletEntity bullet, Entity attacker) {
        return new IndirectEntityDamageSource("musket", (Entity)bullet, attacker).func_76349_b();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.processCollision()) {
            this.func_70106_y();
            return;
        }
        this.tickCounter = (short)(this.tickCounter + 1);
        if (this.tickCounter >= 50 || (double)this.distanceTravelled > maxDistance) {
            this.func_70106_y();
            return;
        }
        Vector3d motion = this.func_213322_ci();
        double posX = this.func_226277_ct_() + motion.field_72450_a;
        double posY = this.func_226278_cu_() + motion.field_72448_b;
        double posZ = this.func_226281_cx_() + motion.field_72449_c;
        this.distanceTravelled = (float)((double)this.distanceTravelled + motion.func_72433_c());
        motion = motion.func_178786_a(0.0, 0.05, 0.0);
        double friction = 0.99;
        if (this.func_70090_H()) {
            int count = 4;
            for (int i = 0; i != 4; ++i) {
                double t = ((double)i + 1.0) / 4.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, posX - motion.field_72450_a * t, posY - motion.field_72448_b * t, posZ - motion.field_72449_c * t, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
            }
            friction = 0.6;
        }
        this.func_213317_d(motion.func_186678_a(friction));
        this.func_70107_b(posX, posY, posZ);
        this.func_145775_I();
    }

    public boolean processCollision() {
        Entity target;
        Vector3d to;
        Vector3d from = this.func_213303_ch();
        BlockRayTraceResult collision = this.field_70170_p.func_217299_a(new RayTraceContext(from, to = from.func_178787_e(this.func_213322_ci()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        if (collision.func_216346_c() != RayTraceResult.Type.MISS) {
            to = collision.func_216347_e();
        }
        if ((target = this.closestEntityOnPath(from, to)) != null) {
            Entity shooter;
            if (target instanceof PlayerEntity && (shooter = this.getShooter()) instanceof PlayerEntity && !((PlayerEntity)shooter).func_96122_a((PlayerEntity)target)) {
                target = null;
            }
            if (target != null) {
                this.hitEntity(target);
                return true;
            }
        }
        if (collision.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockState blockstate = this.field_70170_p.func_180495_p(collision.func_216350_a());
        blockstate.func_215690_a(this.field_70170_p, blockstate, collision, (ProjectileEntity)this);
        int impactParticleCount = (int)(this.func_213322_ci().func_189985_c() / 20.0);
        if (impactParticleCount > 0) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate), to.field_72450_a, to.field_72448_b, to.field_72449_c, impactParticleCount, 0.0, 0.0, 0.0, 0.01);
        }
        return true;
    }

    public void hitEntity(Entity target) {
        Entity shooter = this.getShooter();
        DamageSource damagesource = this.causeMusketDamage(this, (Entity)(shooter != null ? shooter : this));
        float damage = this.damageMultiplier * (float)this.func_213322_ci().func_189985_c();
        if ((double)damage > 0.5) {
            target.func_70097_a(damagesource, damage);
        }
    }

    public Predicate<Entity> getTargetPredicate() {
        Entity shooter = this.getShooter();
        return entity -> !entity.func_175149_v() && entity.func_70089_S() && entity.func_70067_L() && entity != shooter;
    }

    public Entity closestEntityOnPath(Vector3d start, Vector3d end) {
        Vector3d motion = this.func_213322_ci();
        Entity result = null;
        double result_dist = 0.0;
        AxisAlignedBB aabbSelection = this.func_174813_aQ().func_216361_a(motion).func_186662_g(0.5);
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, aabbSelection, this.getTargetPredicate())) {
            double dist;
            AxisAlignedBB aabb = entity.func_174813_aQ();
            Optional optional = aabb.func_216365_b(start, end);
            if (!optional.isPresent()) {
                aabb = aabb.func_72317_d(entity.field_70142_S - entity.func_226277_ct_(), entity.field_70137_T - entity.func_226278_cu_(), entity.field_70136_U - entity.func_226281_cx_());
                optional = aabb.func_216365_b(start, end);
            }
            if (!optional.isPresent() || !((dist = start.func_72436_e((Vector3d)optional.get())) < result_dist) && result != null) continue;
            result = entity;
            result_dist = dist;
        }
        return result;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.damageMultiplier = compound.func_74760_g("damageMultiplier");
        this.distanceTravelled = compound.func_74760_g("distanceTravelled");
    }

    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("damageMultiplier", this.damageMultiplier);
        compound.func_74776_a("distanceTravelled", this.distanceTravelled);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer data) {
        data.writeShort(0);
        Vector3d motion = this.func_213322_ci();
        data.writeFloat((float)motion.field_72450_a);
        data.writeFloat((float)motion.field_72448_b);
        data.writeFloat((float)motion.field_72449_c);
    }

    public void readSpawnData(PacketBuffer data) {
        data.readShort();
        Vector3d motion = new Vector3d((double)data.readFloat(), (double)data.readFloat(), (double)data.readFloat());
        this.func_213317_d(motion);
    }
}

