/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletRenderer;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.RenderHelper;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientSetup {
    public static void init(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(MusketMod.BULLET_ENTITY_TYPE, BulletRenderer::new);
        IItemPropertyGetter loaded = (stack, world, player) -> GunItem.isLoaded(stack) ? 1.0f : 0.0f;
        ItemModelsProperties.func_239418_a_((Item)MusketMod.MUSKET, (ResourceLocation)new ResourceLocation("loaded"), (IItemPropertyGetter)loaded);
        ItemModelsProperties.func_239418_a_((Item)MusketMod.MUSKET_WITH_BAYONET, (ResourceLocation)new ResourceLocation("loaded"), (IItemPropertyGetter)loaded);
        ItemModelsProperties.func_239418_a_((Item)MusketMod.PISTOL, (ResourceLocation)new ResourceLocation("loaded"), (IItemPropertyGetter)loaded);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onRenderHandEvent(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof GunItem) {
            Minecraft mc = Minecraft.func_71410_x();
            RenderHelper.renderSpecificFirstPersonHand(mc.func_175597_ag(), (AbstractClientPlayerEntity)mc.field_71439_g, event.getHand(), event.getPartialTicks(), event.getInterpolatedPitch(), event.getSwingProgress(), event.getEquipProgress(), stack, event.getMatrixStack(), event.getBuffers(), event.getLight());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEventPre(RenderLivingEvent.Pre<PlayerEntity, PlayerModel<PlayerEntity>> event) {
        BipedModel.ArmPose leftArmPose;
        BipedModel.ArmPose rightArmPose;
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        if (player.field_82175_bq) {
            return;
        }
        if (player.func_184591_cq() == HandSide.RIGHT) {
            rightArmPose = ClientSetup.getArmPose(player, Hand.MAIN_HAND);
            leftArmPose = ClientSetup.getArmPose(player, Hand.OFF_HAND);
        } else {
            rightArmPose = ClientSetup.getArmPose(player, Hand.OFF_HAND);
            leftArmPose = ClientSetup.getArmPose(player, Hand.MAIN_HAND);
        }
        PlayerModel model = (PlayerModel)event.getRenderer().func_217764_d();
        if (rightArmPose != null) {
            model.field_187076_m = rightArmPose;
        }
        if (leftArmPose != null) {
            model.field_187075_l = leftArmPose;
        }
    }

    public static BipedModel.ArmPose getArmPose(PlayerEntity player, Hand hand) {
        GunItem gunItem;
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof GunItem && (gunItem = (GunItem)stack.func_77973_b()).canUseFrom(player, hand) && GunItem.isLoaded(stack)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return null;
    }

    public static void handleSmokeEffectPacket(MusketMod.SmokeEffectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        INetHandler listener = ctx.get().getNetworkManager().func_150729_e();
        if (listener instanceof ClientPlayNetHandler) {
            GunItem.fireParticles((World)((ClientPlayNetHandler)listener).func_195514_j(), packet.origin, packet.direction);
        }
    }
}

