/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.MusketMod;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class GunItem
extends Item {
    public static final int LOADING_STAGE_1 = 5;
    public static final int LOADING_STAGE_2 = 10;
    public static final int LOADING_STAGE_3 = 20;
    public static final int RELOAD_DURATION = 30;
    public static ItemStack activeMainHandStack;
    public static ItemStack activeOffhandStack;

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public abstract float bulletStdDev();

    public abstract float bulletSpeed();

    public abstract float damageMultiplierMin();

    public abstract float damageMultiplierMax();

    public abstract SoundEvent fireSound();

    public abstract boolean twoHanded();

    public boolean canUseFrom(PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return true;
        }
        if (this.twoHanded()) {
            return false;
        }
        ItemStack mainHandStack = player.func_184586_b(Hand.MAIN_HAND);
        if (!mainHandStack.func_190926_b() && mainHandStack.func_77973_b() instanceof GunItem) {
            return !((GunItem)mainHandStack.func_77973_b()).twoHanded();
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        GunItem offhandGun;
        ItemStack offhandStack;
        if (!this.canUseFrom(player, hand)) {
            return super.func_77659_a(worldIn, player, hand);
        }
        ItemStack stack = player.func_184586_b(hand);
        boolean creative = player.field_71075_bZ.field_75098_d;
        if (player.func_208600_a((ITag)FluidTags.field_206959_a) && !creative) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (hand == Hand.MAIN_HAND && !this.twoHanded() && GunItem.isLoaded(stack) && !(offhandStack = player.func_184586_b(Hand.OFF_HAND)).func_190926_b() && offhandStack.func_77973_b() instanceof GunItem && !(offhandGun = (GunItem)offhandStack.func_77973_b()).twoHanded() && GunItem.isLoaded(offhandStack)) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        boolean haveAmmo = !GunItem.findAmmo(player).func_190926_b() || creative;
        boolean loaded = GunItem.isLoaded(stack);
        if (loaded) {
            if (!worldIn.field_72995_K) {
                Vector3d front = Vector3d.func_189986_a((float)player.field_70125_A, (float)player.field_70177_z);
                HandSide mainArm = player.func_184591_cq();
                boolean isRightHand = hand == Hand.MAIN_HAND && mainArm == HandSide.RIGHT || hand == Hand.OFF_HAND && mainArm == HandSide.LEFT;
                Vector3d side = Vector3d.func_189986_a((float)0.0f, (float)(player.field_70177_z + (float)(isRightHand ? 90 : -90)));
                Vector3d down = Vector3d.func_189986_a((float)(player.field_70125_A + 90.0f), (float)player.field_70177_z);
                this.fire((LivingEntity)player, front, side.func_178787_e(down).func_186678_a(0.15));
                GunItem.increaseGunExperience(player);
            }
            player.func_184185_a(this.fireSound(), 3.5f, 1.0f);
            GunItem.setLoaded(stack, false);
            stack.func_222118_a(1, (LivingEntity)player, entity -> entity.func_213334_d(hand));
            if (worldIn.field_72995_K) {
                GunItem.setActiveStack(hand, stack);
            }
            return ActionResult.func_226249_b_((Object)stack);
        }
        if (haveAmmo) {
            GunItem.setLoadingStage(stack, 1);
            player.func_184598_c(hand);
            if (worldIn.field_72995_K) {
                GunItem.setActiveStack(hand, stack);
            }
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        GunItem.setLoadingStage(stack, 0);
    }

    public void func_219972_a(World world, LivingEntity entity, ItemStack stack, int timeLeft) {
        int usingDuration = this.func_77626_a(stack) - timeLeft;
        int loadingStage = GunItem.getLoadingStage(stack);
        if (loadingStage == 1 && usingDuration >= 5) {
            entity.func_184185_a(MusketMod.SOUND_MUSKET_LOAD_0, 0.8f, 1.0f);
            GunItem.setLoadingStage(stack, 2);
        } else if (loadingStage == 2 && usingDuration >= 10) {
            entity.func_184185_a(MusketMod.SOUND_MUSKET_LOAD_1, 0.8f, 1.0f);
            GunItem.setLoadingStage(stack, 3);
        } else if (loadingStage == 3 && usingDuration >= 20) {
            entity.func_184185_a(MusketMod.SOUND_MUSKET_LOAD_2, 0.8f, 1.0f);
            GunItem.setLoadingStage(stack, 4);
        }
        if (world.field_72995_K && entity instanceof PlayerEntity) {
            GunItem.setActiveStack(entity.func_184600_cs(), stack);
            return;
        }
        if (usingDuration >= 30 && !GunItem.isLoaded(stack)) {
            if (entity instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)entity;
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack ammoStack = GunItem.findAmmo(player);
                    if (ammoStack.func_190926_b()) {
                        return;
                    }
                    ammoStack.func_190918_g(1);
                    if (ammoStack.func_190926_b()) {
                        player.field_71071_by.func_184437_d(ammoStack);
                    }
                }
            }
            world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), MusketMod.SOUND_MUSKET_READY, entity.func_184176_by(), 0.8f, 1.0f);
            GunItem.setLoaded(stack, true);
        }
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity enemy, LivingEntity entityIn) {
        stack.func_222118_a(1, entityIn, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityIn) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityIn, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public static ItemStack getActiveStack(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return activeMainHandStack;
        }
        return activeOffhandStack;
    }

    public static void setActiveStack(Hand hand, ItemStack stack) {
        if (hand == Hand.MAIN_HAND) {
            activeMainHandStack = stack;
        } else {
            activeOffhandStack = stack;
        }
    }

    public static boolean isLoaded(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        return tag != null && tag.func_74771_c("loaded") == 1;
    }

    public static boolean isAmmo(ItemStack stack) {
        return stack.func_77973_b() == MusketMod.CARTRIDGE;
    }

    public static ItemStack findAmmo(PlayerEntity player) {
        if (GunItem.isAmmo(player.func_184586_b(Hand.OFF_HAND))) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (GunItem.isAmmo(player.func_184586_b(Hand.MAIN_HAND))) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i != player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack itemstack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (!GunItem.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void fire(LivingEntity shooter, Vector3d direction) {
        this.fire(shooter, direction, Vector3d.field_186680_a);
    }

    public void fire(LivingEntity shooter, Vector3d direction, Vector3d smokeOriginOffset) {
        Vector3d n2;
        Vector3d n1;
        float angle = (float)Math.PI * 2 * field_77697_d.nextFloat();
        float gaussian = Math.abs((float)field_77697_d.nextGaussian());
        if (gaussian > 4.0f) {
            gaussian = 4.0f;
        }
        float spread = this.bulletStdDev() * gaussian;
        if (Math.abs(direction.field_72450_a) < 1.0E-5 && Math.abs(direction.field_72449_c) < 1.0E-5) {
            n1 = new Vector3d(1.0, 0.0, 0.0);
            n2 = new Vector3d(0.0, 0.0, 1.0);
        } else {
            n1 = new Vector3d(-direction.field_72449_c, 0.0, direction.field_72450_a).func_72432_b();
            n2 = direction.func_72431_c(n1);
        }
        Vector3d motion = direction.func_186678_a((double)MathHelper.func_76134_b((float)spread)).func_178787_e(n1.func_186678_a((double)(MathHelper.func_76126_a((float)spread) * MathHelper.func_76126_a((float)angle)))).func_178787_e(n2.func_186678_a((double)(MathHelper.func_76126_a((float)spread) * MathHelper.func_76134_b((float)angle)))).func_186678_a((double)this.bulletSpeed());
        Vector3d origin = new Vector3d(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e(), shooter.func_226281_cx_());
        BulletEntity bullet = new BulletEntity(shooter.field_70170_p);
        bullet.func_212361_a((Entity)shooter);
        bullet.func_70107_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
        bullet.func_213317_d(motion);
        float t = field_77697_d.nextFloat();
        bullet.damageMultiplier = t * this.damageMultiplierMin() + (1.0f - t) * this.damageMultiplierMax();
        shooter.field_70170_p.func_217376_c((Entity)bullet);
        MusketMod.sendSmokeEffect(shooter, origin.func_178787_e(smokeOriginOffset), direction);
    }

    public static void fireParticles(World world, Vector3d origin, Vector3d direction) {
        Random random = world.func_201674_k();
        for (int i = 0; i != 10; ++i) {
            double t = Math.pow(random.nextFloat(), 1.5);
            Vector3d p = origin.func_178787_e(direction.func_186678_a(1.25 + t));
            p = p.func_178787_e(new Vector3d((double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5, (double)random.nextFloat() - 0.5).func_186678_a(0.1));
            Vector3d v = direction.func_186678_a(0.1).func_186678_a(1.0 - t);
            world.func_195594_a((IParticleData)ParticleTypes.field_197598_I, p.field_72450_a, p.field_72448_b, p.field_72449_c, v.field_72450_a, v.field_72448_b, v.field_72449_c);
        }
    }

    public static void increaseGunExperience(PlayerEntity player) {
        String NAME = "gun_experience";
        Scoreboard board = player.func_96123_co();
        ScoreObjective objective = board.func_96518_b("gun_experience");
        if (objective == null) {
            objective = board.func_199868_a("gun_experience", ScoreCriteria.field_96641_b, (ITextComponent)new StringTextComponent("gun_experience"), ScoreCriteria.RenderType.INTEGER);
        }
        Score score = board.func_96529_a(player.func_195047_I_(), objective);
        score.func_96648_a();
    }

    public static void setLoaded(ItemStack stack, boolean loaded) {
        stack.func_196082_o().func_74774_a("loaded", (byte)(loaded ? 1 : 0));
    }

    public static void setLoadingStage(ItemStack stack, int loadingStage) {
        stack.func_196082_o().func_74768_a("loadingStage", loadingStage);
    }

    public static int getLoadingStage(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("loadingStage");
    }
}

