/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.BulletEntity;
import ewewukek.musketmod.ClientSetup;
import ewewukek.musketmod.Config;
import ewewukek.musketmod.MusketItem;
import ewewukek.musketmod.PistolItem;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="musketmod")
public class MusketMod {
    public static final String MODID = "musketmod";
    @ObjectHolder(value="musketmod:musket")
    public static Item MUSKET;
    @ObjectHolder(value="musketmod:musket_with_bayonet")
    public static Item MUSKET_WITH_BAYONET;
    @ObjectHolder(value="musketmod:pistol")
    public static Item PISTOL;
    @ObjectHolder(value="musketmod:cartridge")
    public static Item CARTRIDGE;
    @ObjectHolder(value="musketmod:musket_load0")
    public static SoundEvent SOUND_MUSKET_LOAD_0;
    @ObjectHolder(value="musketmod:musket_load1")
    public static SoundEvent SOUND_MUSKET_LOAD_1;
    @ObjectHolder(value="musketmod:musket_load2")
    public static SoundEvent SOUND_MUSKET_LOAD_2;
    @ObjectHolder(value="musketmod:musket_ready")
    public static SoundEvent SOUND_MUSKET_READY;
    @ObjectHolder(value="musketmod:musket_fire")
    public static SoundEvent SOUND_MUSKET_FIRE;
    @ObjectHolder(value="musketmod:pistol_fire")
    public static SoundEvent SOUND_PISTOL_FIRE;
    @ObjectHolder(value="musketmod:bullet")
    public static EntityType<BulletEntity> BULLET_ENTITY_TYPE;
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_CHANNEL;

    public MusketMod() {
        Config.reload();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientSetup::init));
        NETWORK_CHANNEL.registerMessage(1, SmokeEffectPacket.class, SmokeEffectPacket::encode, SmokeEffectPacket::new, SmokeEffectPacket::handle);
    }

    public static void sendSmokeEffect(LivingEntity player, Vector3d origin, Vector3d direction) {
        NETWORK_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SmokeEffectPacket(origin, direction));
    }

    static {
        NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "main"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    }

    public static class SmokeEffectPacket {
        public final Vector3d origin;
        public final Vector3d direction;

        public SmokeEffectPacket(Vector3d origin, Vector3d direction) {
            this.origin = origin;
            this.direction = direction;
        }

        public SmokeEffectPacket(PacketBuffer buf) {
            this.origin = new Vector3d((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
            this.direction = new Vector3d((double)buf.readFloat(), (double)buf.readFloat(), (double)buf.readFloat());
        }

        public void encode(PacketBuffer buf) {
            buf.writeFloat((float)this.origin.field_72450_a);
            buf.writeFloat((float)this.origin.field_72448_b);
            buf.writeFloat((float)this.origin.field_72449_c);
            buf.writeFloat((float)this.direction.field_72450_a);
            buf.writeFloat((float)this.direction.field_72448_b);
            buf.writeFloat((float)this.direction.field_72449_c);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this.lambda$null$1((Supplier)ctx)));
            ctx.get().setPacketHandled(true);
        }

        private /* synthetic */ Runnable lambda$null$1(Supplier ctx) {
            return () -> this.lambda$null$0((Supplier)ctx);
        }

        private /* synthetic */ void lambda$null$0(Supplier ctx) {
            ClientSetup.handleSmokeEffectPacket(this, ctx);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerEvents {
        @SubscribeEvent
        public static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
            event.addListener(new IFutureReloadListener(){

                public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                    return stage.func_216872_a((Object)Unit.INSTANCE).thenRunAsync(() -> Config.reload(), gameExecutor);
                }
            });
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            Item stock = new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)){

                public int getBurnTime(ItemStack itemStack) {
                    return 200;
                }
            };
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName(MusketMod.MODID, "barrel"), (Item)stock.setRegistryName(MusketMod.MODID, "stock"), (Item)new MusketItem(new Item.Properties().func_200916_a(ItemGroup.field_78037_j), false).setRegistryName(MusketMod.MODID, "musket"), (Item)new MusketItem(new Item.Properties().func_200916_a(ItemGroup.field_78037_j), true).setRegistryName(MusketMod.MODID, "musket_with_bayonet"), (Item)new PistolItem(new Item.Properties().func_200916_a(ItemGroup.field_78037_j)).setRegistryName(MusketMod.MODID, "pistol"), (Item)new Item(new Item.Properties().func_200916_a(ItemGroup.field_78037_j)).setRegistryName(MusketMod.MODID, "cartridge")});
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
            event.getRegistry().register(EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).setCustomClientFactory(BulletEntity::new).func_220321_a(0.5f, 0.5f).setTrackingRange(64).setUpdateInterval(5).setShouldReceiveVelocityUpdates(false).func_206830_a("musketmod:bullet").setRegistryName(MusketMod.MODID, "bullet"));
        }

        @SubscribeEvent
        public static void onSoundRegistry(RegistryEvent.Register<SoundEvent> event) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)new SoundEvent(new ResourceLocation(MusketMod.MODID, "musket_load0")).setRegistryName(MusketMod.MODID, "musket_load0"), (SoundEvent)new SoundEvent(new ResourceLocation(MusketMod.MODID, "musket_load1")).setRegistryName(MusketMod.MODID, "musket_load1"), (SoundEvent)new SoundEvent(new ResourceLocation(MusketMod.MODID, "musket_load2")).setRegistryName(MusketMod.MODID, "musket_load2"), (SoundEvent)new SoundEvent(new ResourceLocation(MusketMod.MODID, "musket_ready")).setRegistryName(MusketMod.MODID, "musket_ready"), (SoundEvent)new SoundEvent(new ResourceLocation(MusketMod.MODID, "musket_fire")).setRegistryName(MusketMod.MODID, "musket_fire"), (SoundEvent)new SoundEvent(new ResourceLocation(MusketMod.MODID, "pistol_fire")).setRegistryName(MusketMod.MODID, "pistol_fire")});
        }
    }
}

