/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import com.mojang.blaze3d.matrix.MatrixStack;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.MusketMod;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderHelper {
    public static boolean disableMainHandEquipAnimation;
    public static boolean disableOffhandEquipAnimation;

    public static void renderSpecificFirstPersonHand(FirstPersonRenderer renderer, AbstractClientPlayerEntity player, Hand hand, float partialTicks, float interpolatedPitch, float swingProgress, float equipProgress, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer render, int packedLight) {
        HandSide handside = hand == Hand.MAIN_HAND ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        boolean isRightHand = handside == HandSide.RIGHT;
        float sign = isRightHand ? 1.0f : -1.0f;
        GunItem gunItem = (GunItem)stack.func_77973_b();
        if (!gunItem.canUseFrom((PlayerEntity)player, hand)) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)sign * 0.5, -0.5 - 0.6 * (double)equipProgress, -0.7);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(70.0f));
            renderer.func_228397_a_((LivingEntity)player, stack, isRightHand ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !isRightHand, matrixStack, render, packedLight);
            matrixStack.func_227865_b_();
            return;
        }
        if (stack == GunItem.getActiveStack(hand)) {
            RenderHelper.setEquipAnimationDisabled(hand, true);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)sign * 0.15, -0.25, -0.35);
        if (swingProgress > 0.0f) {
            float swingSharp = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
            float swingNormal = MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
            if (gunItem == MusketMod.MUSKET_WITH_BAYONET) {
                matrixStack.func_227861_a_((double)sign * -0.05 * (double)swingNormal, 0.0, 0.05 - 0.3 * (double)swingSharp);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(5.0f * swingSharp));
            } else {
                matrixStack.func_227861_a_((double)sign * 0.05 * (double)(1.0f - swingNormal), 0.05 * (double)(1.0f - swingNormal), 0.05 - 0.4 * (double)swingSharp);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f + sign * 20.0f * (1.0f - swingSharp)));
            }
        } else if (player.func_184587_cr() && player.func_184600_cs() == hand) {
            float usingDuration = (float)stack.func_77988_m() - ((float)player.func_184605_cv() - partialTicks + 1.0f);
            if (usingDuration > 0.0f && usingDuration < 30.0f) {
                matrixStack.func_227861_a_(0.0, -0.3, 0.05);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(60.0f));
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(10.0f));
                if (usingDuration >= 8.0f && usingDuration <= 14.0f || usingDuration >= 18.0f && usingDuration <= 24.0f) {
                    float t;
                    if (usingDuration >= 18.0f) {
                        usingDuration -= 10.0f;
                    }
                    if (usingDuration < 10.0f) {
                        t = (usingDuration - 8.0f) / 2.0f;
                        t = MathHelper.func_76126_a((float)(1.5707964f * MathHelper.func_76129_c((float)t)));
                    } else {
                        t = (14.0f - usingDuration) / 4.0f;
                    }
                    matrixStack.func_227861_a_(0.0, 0.0, 0.025 * (double)t);
                }
                if (gunItem == MusketMod.PISTOL) {
                    matrixStack.func_227861_a_(0.0, 0.0, -0.12);
                }
            }
        } else if (RenderHelper.isEquipAnimationDisabled(hand)) {
            if (equipProgress == 0.0f) {
                RenderHelper.setEquipAnimationDisabled(hand, false);
            }
        } else {
            matrixStack.func_227861_a_(0.0, -0.6 * (double)equipProgress, 0.0);
        }
        renderer.func_228397_a_((LivingEntity)player, stack, isRightHand ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !isRightHand, matrixStack, render, packedLight);
        matrixStack.func_227865_b_();
    }

    public static boolean isEquipAnimationDisabled(Hand hand) {
        if (hand == Hand.MAIN_HAND) {
            return disableMainHandEquipAnimation;
        }
        return disableOffhandEquipAnimation;
    }

    public static void setEquipAnimationDisabled(Hand hand, boolean disabled) {
        if (hand == Hand.MAIN_HAND) {
            disableMainHandEquipAnimation = disabled;
        } else {
            disableOffhandEquipAnimation = disabled;
        }
    }
}

