/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.inventory;

import com.mojang.datafixers.util.Pair;
import com.oblivioussp.spartanweaponry.inventory.SlotFiltered;
import com.oblivioussp.spartanweaponry.item.QuiverBaseItem;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public abstract class QuiverBaseContainer
extends Container {
    protected final ItemStack quiverStack;
    protected final IItemHandler handler;
    protected final Predicate<ItemStack> slotFilter;
    protected int playerInvStart;
    protected int playerInvEnd;
    protected int hotbarStart;
    protected int hotbarEnd;

    protected QuiverBaseContainer(ContainerType<?> type, int id, PlayerInventory inventory, ItemStack quiverStack, Predicate<ItemStack> slotFilter) {
        super(type, id);
        this.slotFilter = slotFilter;
        this.quiverStack = quiverStack;
        this.handler = (IItemHandler)quiverStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseThrow(QuiverBaseItem.CAPABILITY_EXCEPTION);
        this.playerInvStart = this.handler.getSlots();
        this.playerInvEnd = this.playerInvStart + 26;
        this.hotbarStart = this.playerInvEnd + 1;
        this.hotbarEnd = this.hotbarStart + 8;
        this.addQuiverSlots();
        this.addPlayerSlots(inventory);
    }

    protected void addQuiverSlots() {
        int slotStartX = 53;
        int slotStartY = 20;
        int columns = 1;
        switch (this.handler.getSlots()) {
            case 4: {
                columns = 4;
                slotStartX = 53;
                break;
            }
            case 6: {
                columns = 6;
                slotStartX = 35;
                break;
            }
            case 9: {
                columns = 9;
                slotStartX = 8;
                break;
            }
            case 12: {
                columns = 6;
                slotStartX = 35;
            }
        }
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            this.func_75146_a((Slot)new SlotFiltered(this.handler, i, slotStartX + 18 * (i % columns), slotStartY + MathHelper.func_76141_d((float)(i / columns)) * 18, this.slotFilter));
        }
    }

    protected void addPlayerSlots(PlayerInventory inventory) {
        int i;
        int yOffset = this.handler.getSlots() == 12 ? 18 : 0;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, 9 + i * 9 + j, 8 + j * 18, 51 + yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventory, i, 8 + i * 18, 109 + yOffset));
        }
        this.func_75146_a(new Slot((IInventory)inventory, 40, -21, this.handler.getSlots() == 12 ? 127 : 109){

            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
            }
        });
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotIdx) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIdx);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (slotIdx >= 0 && slotIdx < this.handler.getSlots() ? !this.func_75135_a(slotStack, this.playerInvStart, this.hotbarEnd + 2, false) : slotIdx >= this.playerInvStart && slotIdx <= this.hotbarEnd + 1 && slot.func_75214_a(stack) && !this.func_75135_a(slotStack, 0, this.playerInvStart, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return stack;
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickType, PlayerEntity player) {
        if (slot >= 0 && this.func_75139_a(slot) != null && this.func_75139_a(slot).func_75211_c().equals(this.quiverStack, false)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slot, dragType, clickType, player);
    }

    public ItemStack getQuiverStack() {
        return this.quiverStack;
    }

    protected static ItemStack findQuiverStack(PlayerInventory inventory, QuiverBaseItem.SlotType slotType, int slot) {
        ItemStack quiverStack = ItemStack.field_190927_a;
        switch (slotType) {
            case HOTBAR: {
                quiverStack = inventory.func_70301_a(slot);
                break;
            }
            case CURIO: {
                Optional opt = CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.func_77973_b() instanceof QuiverBaseItem, (LivingEntity)inventory.field_70458_d);
                if (!opt.isPresent()) break;
                quiverStack = (ItemStack)((ImmutableTriple)opt.get()).right;
                break;
            }
            case MAIN_HAND: {
                quiverStack = inventory.field_70458_d.func_184614_ca();
                break;
            }
            case OFF_HAND: {
                quiverStack = inventory.field_70458_d.func_184592_cb();
                break;
            }
        }
        return quiverStack;
    }
}

