/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item;

import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.item.BasicItem;
import com.oblivioussp.spartanweaponry.util.WeaponOilEffect;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class WeaponOilItem
extends BasicItem {
    public static final String NBT_OIL = "Oil";
    public static IForgeRegistry<WeaponOilEffect> weaponOilRegistry;

    public WeaponOilItem(String regName) {
        super(regName, new Item.Properties().func_200916_a(ModItems.GROUP_SW).func_200917_a(1));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            // empty if block
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        WeaponOilEffect oil = WeaponOilItem.getOilFromStack(stack);
        if (oil != null) {
            tooltip.add((ITextComponent)new StringTextComponent(""));
            tooltip.add((ITextComponent)new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.weapon_oil.applied." + oil.getRegistryName().func_110623_a(), new Object[]{Float.valueOf(4.0f)}).func_240699_a_(TextFormatting.BLUE));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.spartanweaponry.weapon_oil.uses", new Object[]{30}).func_240699_a_(TextFormatting.DARK_GREEN));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        WeaponOilEffect oil = WeaponOilItem.getOilFromStack(stack);
        if (oil != null) {
            return new TranslationTextComponent(this.func_77658_a() + "." + oil.getRegistryName().func_110623_a());
        }
        return super.func_200295_i(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static WeaponOilEffect getOilFromStack(ItemStack stack) {
        ResourceLocation oil = new ResourceLocation(stack.func_196082_o().func_74779_i(NBT_OIL));
        if (weaponOilRegistry == null) {
            weaponOilRegistry = GameRegistry.findRegistry(WeaponOilEffect.class);
        }
        if (weaponOilRegistry != null && weaponOilRegistry.containsKey(oil)) {
            return (WeaponOilEffect)weaponOilRegistry.getValue(oil);
        }
        return null;
    }

    public static void setOilInStack(ItemStack stack, WeaponOilEffect oil) {
        stack.func_196082_o().func_74778_a(NBT_OIL, oil.getRegistryName().toString());
    }
}

