/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather;

import corgitaco.betterweather.api.BetterWeatherRegistry;
import corgitaco.betterweather.config.BetterWeatherClientConfig;
import corgitaco.betterweather.data.network.NetworkHandler;
import corgitaco.betterweather.server.BetterWeatherGameRules;
import corgitaco.betterweather.weather.event.AcidRain;
import corgitaco.betterweather.weather.event.Blizzard;
import corgitaco.betterweather.weather.event.Cloudy;
import corgitaco.betterweather.weather.event.None;
import corgitaco.betterweather.weather.event.Rain;
import corgitaco.betterweather.weather.event.client.settings.AcidRainClientSettings;
import corgitaco.betterweather.weather.event.client.settings.BlizzardClientSettings;
import corgitaco.betterweather.weather.event.client.settings.CloudyClientSettings;
import corgitaco.betterweather.weather.event.client.settings.NoneClientSettings;
import corgitaco.betterweather.weather.event.client.settings.RainClientSettings;
import java.io.File;
import java.nio.file.Path;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="betterweather")
public class BetterWeather {
    public static final String MOD_ID = "betterweather";
    public static final Path CONFIG_PATH = new File(String.valueOf(FMLPaths.CONFIGDIR.get().resolve("betterweather"))).toPath();
    public static final Logger LOGGER = LogManager.getLogger();
    public static final BetterWeatherClientConfig CLIENT_CONFIG = new BetterWeatherClientConfig();
    public static final boolean USING_OPTIFINE = (Boolean)new LazyValue(() -> {
        try {
            return Class.forName("net.optifine.Config") != null;
        }
        catch (Exception e) {
            return false;
        }
    }).func_179281_c();

    public BetterWeather() {
        if (!CONFIG_PATH.toFile().exists()) {
            CONFIG_PATH.toFile().mkdir();
        }
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::lateSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(BetterWeatherGameRules::init);
        NetworkHandler.init();
        Registry.func_218322_a(BetterWeatherRegistry.CLIENT_WEATHER_EVENT_SETTINGS, (ResourceLocation)new ResourceLocation(MOD_ID, "acid_rain"), AcidRainClientSettings.CODEC);
        Registry.func_218322_a(BetterWeatherRegistry.CLIENT_WEATHER_EVENT_SETTINGS, (ResourceLocation)new ResourceLocation(MOD_ID, "blizzard"), BlizzardClientSettings.CODEC);
        Registry.func_218322_a(BetterWeatherRegistry.CLIENT_WEATHER_EVENT_SETTINGS, (ResourceLocation)new ResourceLocation(MOD_ID, "cloudy"), CloudyClientSettings.CODEC);
        Registry.func_218322_a(BetterWeatherRegistry.CLIENT_WEATHER_EVENT_SETTINGS, (ResourceLocation)new ResourceLocation(MOD_ID, "none"), NoneClientSettings.CODEC);
        Registry.func_218322_a(BetterWeatherRegistry.CLIENT_WEATHER_EVENT_SETTINGS, (ResourceLocation)new ResourceLocation(MOD_ID, "rain"), RainClientSettings.CODEC);
        Registry.func_218322_a(BetterWeatherRegistry.WEATHER_EVENT, (ResourceLocation)new ResourceLocation(MOD_ID, "acid_rain"), AcidRain.CODEC);
        Registry.func_218322_a(BetterWeatherRegistry.WEATHER_EVENT, (ResourceLocation)new ResourceLocation(MOD_ID, "blizzard"), Blizzard.CODEC);
        Registry.func_218322_a(BetterWeatherRegistry.WEATHER_EVENT, (ResourceLocation)new ResourceLocation(MOD_ID, "cloudy"), Cloudy.CODEC);
        Registry.func_218322_a(BetterWeatherRegistry.WEATHER_EVENT, (ResourceLocation)new ResourceLocation(MOD_ID, "none"), None.CODEC);
        Registry.func_218322_a(BetterWeatherRegistry.WEATHER_EVENT, (ResourceLocation)new ResourceLocation(MOD_ID, "rain"), Rain.CODEC);
        BetterWeatherRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "none"), None.DEFAULT);
        BetterWeatherRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "acid_rain"), AcidRain.DEFAULT);
        BetterWeatherRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "blizzard"), Blizzard.DEFAULT);
        BetterWeatherRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "cloudy"), Cloudy.DEFAULT);
        BetterWeatherRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "rain"), Rain.DEFAULT);
        BetterWeatherRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "acid_rain_thundering"), AcidRain.DEFAULT_THUNDERING);
        BetterWeatherRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "blizzard_thundering"), Blizzard.DEFAULT_THUNDERING);
        BetterWeatherRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "cloudy_thundering"), Cloudy.DEFAULT_THUNDERING);
        BetterWeatherRegistry.DEFAULT_EVENTS.put(new ResourceLocation(MOD_ID, "thundering"), Rain.DEFAULT_THUNDERING);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        if (USING_OPTIFINE) {
            LOGGER.info("Optifine is loaded.");
        }
    }

    private void lateSetup(FMLLoadCompleteEvent event) {
    }
}

