/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.api.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.betterweather.util.client.ColorUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Util;

public class ColorSettings {
    public static final Codec<ColorSettings> CODEC = RecordCodecBuilder.create(seasonClientSettingsInstance -> seasonClientSettingsInstance.group((App)Codec.STRING.fieldOf("foliageTargetHexColor").forGetter(colorSettings -> colorSettings.targetFoliageHexColor == Integer.MAX_VALUE ? "" : Integer.toHexString(colorSettings.targetFoliageHexColor)), (App)Codec.DOUBLE.fieldOf("foliageColorBlendStrength").orElse((Object)0.0).forGetter(colorSettings -> colorSettings.foliageColorBlendStrength), (App)Codec.STRING.fieldOf("grassTargetHexColor").orElse((Object)"").forGetter(colorSettings -> colorSettings.targetGrassHexColor == Integer.MAX_VALUE ? "" : Integer.toHexString(colorSettings.targetGrassHexColor)), (App)Codec.DOUBLE.fieldOf("grassColorBlendStrength").orElse((Object)0.0).forGetter(colorSettings -> colorSettings.foliageColorBlendStrength), (App)Codec.STRING.fieldOf("skyTargetHexColor").orElse((Object)"").forGetter(colorSettings -> colorSettings.targetSkyHexColor == Integer.MAX_VALUE ? "" : Integer.toHexString(colorSettings.targetSkyHexColor)), (App)Codec.DOUBLE.fieldOf("skyColorBlendStrength").orElse((Object)0.0).forGetter(colorSettings -> colorSettings.skyColorBlendStrength), (App)Codec.STRING.fieldOf("fogTargetHexColor").orElse((Object)"").forGetter(colorSettings -> colorSettings.targetFogHexColor == Integer.MAX_VALUE ? "" : Integer.toHexString(colorSettings.targetFogHexColor)), (App)Codec.DOUBLE.fieldOf("fogColorBlendStrength").orElse((Object)0.0).forGetter(colorSettings -> colorSettings.fogColorBlendStrength), (App)Codec.STRING.fieldOf("cloudTargetHexColor").orElse((Object)"").forGetter(colorSettings -> colorSettings.targetFogHexColor == Integer.MAX_VALUE ? "" : Integer.toHexString(colorSettings.targetFogHexColor)), (App)Codec.DOUBLE.fieldOf("cloudColorBlendStrength").orElse((Object)0.0).forGetter(colorSettings -> colorSettings.fogColorBlendStrength)).apply((Applicative)seasonClientSettingsInstance, ColorSettings::new));
    public static Map<String, String> VALUE_COMMENTS = (Map)Util.func_200696_a(new HashMap(), map -> {
        map.put("fogColorBlendStrength", "The strength of this world's fog color blend towards the value of \"fogTargetHexColor\".\nRange: 0 - 1.0");
        map.put("fogTargetHexColor", "Blends the world's fog color towards this value. Blend strength is determined by the value of \"fogColorBlendStrength\".");
        map.put("foliageColorBlendStrength", "The strength of this world's sky color blend towards the value of \"foliageTargetHexColor\".\nRange: 0 - 1.0");
        map.put("foliageTargetHexColor", "Blends this world's foliage color towards this value. Blend strength is determined by the value of \"foliageColorBlendStrength\".");
        map.put("grassColorBlendStrength", "The strength of this world's grass color blend towards the value of \"grassTargetHexColor\".\nRange: 0 - 1.0");
        map.put("grassTargetHexColor", "Blends this world's grass color towards this value. Blend strength is determined by the value of \"grassColorBlendStrength\".");
        map.put("skyColorBlendStrength", "The strength of this world's sky color blend towards the value of \"skyTargetHexColor\".\nRange: 0 - 1.0");
        map.put("skyTargetHexColor", "Blends this world's grass color towards this value. Blend strength is determined by the value of \"skyColorBlendStrength\".");
        map.put("cloudColorBlendStrength", "The strength of this world's cloud color blend towards the value of \"cloudTargetHexColor\".\nRange: 0 - 1.0");
        map.put("cloudTargetHexColor", "Blends this world's grass color towards this value. Blend strength is determined by the value of \"cloudColorBlendStrength\".");
    });
    private final int targetFoliageHexColor;
    private final double foliageColorBlendStrength;
    private final int targetGrassHexColor;
    private final double grassColorBlendStrength;
    private final int targetSkyHexColor;
    private final double skyColorBlendStrength;
    private final int targetCloudHexColor;
    private final double cloudColorBlendStrength;
    private final int targetFogHexColor;
    private final double fogColorBlendStrength;

    public ColorSettings() {
        this("", 0.0, "", 0.0);
    }

    public ColorSettings(String targetFoliageHexColor, double foliageColorBlendStrength, String targetGrassColor, double grassColorBlendStrength) {
        this(targetFoliageHexColor, foliageColorBlendStrength, targetGrassColor, grassColorBlendStrength, targetGrassColor, 0.0, targetGrassColor, 0.0, targetGrassColor, 0.0);
    }

    public ColorSettings(String targetFoliageHexColor, double foliageColorBlendStrength, String targetGrassColor, double grassColorBlendStrength, String targetSkyHexColor, double skyColorBlendStrength, String targetFogHexColor, double fogColorBlendStrength, String targetCloudHexColor, double cloudColorBlendStrength) {
        this(ColorUtil.tryParseColor(targetFoliageHexColor), foliageColorBlendStrength, ColorUtil.tryParseColor(targetGrassColor), grassColorBlendStrength, ColorUtil.tryParseColor(targetSkyHexColor), skyColorBlendStrength, ColorUtil.tryParseColor(targetFogHexColor), fogColorBlendStrength, ColorUtil.tryParseColor(targetCloudHexColor), skyColorBlendStrength);
    }

    public ColorSettings(int targetFoliageHexColor, double foliageColorBlendStrength, int targetGrassColor, double grassColorBlendStrength) {
        this(targetFoliageHexColor, foliageColorBlendStrength, targetGrassColor, grassColorBlendStrength, targetFoliageHexColor, 0.0, targetFoliageHexColor, 0.0, targetFoliageHexColor, 0.0);
    }

    public ColorSettings(int targetFoliageHexColor, double foliageColorBlendStrength, int targetGrassColor, double grassColorBlendStrength, int targetSkyHexColor, double skyColorBlendStrength, int targetFogHexColor, double fogColorBlendStrength, int targetCloudHexColor, double cloudColorBlendStrength) {
        this.targetFoliageHexColor = targetFoliageHexColor;
        this.foliageColorBlendStrength = foliageColorBlendStrength;
        this.targetGrassHexColor = targetGrassColor;
        this.grassColorBlendStrength = grassColorBlendStrength;
        this.targetSkyHexColor = targetSkyHexColor;
        this.targetFogHexColor = targetFogHexColor;
        this.fogColorBlendStrength = fogColorBlendStrength;
        this.skyColorBlendStrength = skyColorBlendStrength;
        this.targetCloudHexColor = targetCloudHexColor;
        this.cloudColorBlendStrength = cloudColorBlendStrength;
    }

    public int getTargetFoliageHexColor() {
        return this.targetFoliageHexColor;
    }

    public double getFoliageColorBlendStrength() {
        return this.foliageColorBlendStrength;
    }

    public int getTargetGrassHexColor() {
        return this.targetGrassHexColor;
    }

    public double getGrassColorBlendStrength() {
        return this.grassColorBlendStrength;
    }

    public int getTargetSkyHexColor() {
        return this.targetSkyHexColor;
    }

    public double getSkyColorBlendStrength() {
        return this.skyColorBlendStrength;
    }

    public int getTargetFogHexColor() {
        return this.targetFogHexColor;
    }

    public double getFogColorBlendStrength() {
        return this.fogColorBlendStrength;
    }

    public int getTargetCloudHexColor() {
        return this.targetCloudHexColor;
    }

    public double getCloudColorBlendStrength() {
        return this.cloudColorBlendStrength;
    }
}

