/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.api.client;

import com.mojang.blaze3d.systems.RenderSystem;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.client.ColorSettings;
import corgitaco.betterweather.api.client.graphics.Graphics;
import corgitaco.betterweather.api.client.graphics.opengl.program.ShaderProgram;
import corgitaco.betterweather.api.client.graphics.opengl.program.ShaderProgramBuilder;
import corgitaco.betterweather.api.weather.WeatherEventClientSettings;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class WeatherEventClient<T extends WeatherEventClientSettings> {
    private final ColorSettings colorSettings;
    private final float skyOpacity;
    private final float fogDensity;
    private final boolean sunsetSunriseColor;
    private ShaderProgram program;
    protected final BlockPos.Mutable mutable = new BlockPos.Mutable();

    public WeatherEventClient(T clientSettings) {
        this.colorSettings = ((WeatherEventClientSettings)clientSettings).getColorSettings();
        this.skyOpacity = ((WeatherEventClientSettings)clientSettings).skyOpacity();
        this.fogDensity = ((WeatherEventClientSettings)clientSettings).fogDensity();
        this.sunsetSunriseColor = ((WeatherEventClientSettings)clientSettings).sunsetSunriseColor();
    }

    public boolean renderWeather(Graphics graphics, Minecraft mc, ClientWorld world, LightTexture lightTexture, int ticks, float partialTicks, double x, double y, double z, Predicate<Biome> biomePredicate) {
        return graphics.isSupported() ? this.renderWeatherShaders(graphics, world, x, y, z) : this.renderWeatherLegacy(mc, world, lightTexture, ticks, partialTicks, x, y, z, biomePredicate);
    }

    public abstract boolean renderWeatherShaders(Graphics var1, ClientWorld var2, double var3, double var5, double var7);

    public abstract boolean renderWeatherLegacy(Minecraft var1, ClientWorld var2, LightTexture var3, int var4, float var5, double var6, double var8, double var10, Predicate<Biome> var12);

    public abstract void clientTick(ClientWorld var1, int var2, long var3, Minecraft var5, Predicate<Biome> var6);

    public boolean sunsetSunriseColor() {
        return this.sunsetSunriseColor;
    }

    public float skyOpacity() {
        return MathHelper.func_76131_a((float)this.skyOpacity, (float)0.0f, (float)1.0f);
    }

    public float dayLightDarkness() {
        return this.fogDensity;
    }

    public boolean drippingLeaves() {
        return false;
    }

    public float fogDensity() {
        return this.fogDensity;
    }

    public ColorSettings getColorSettings() {
        return this.colorSettings;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float skyOpacity(ClientWorld world, BlockPos playerPos, Predicate<Biome> isValidBiome) {
        return this.mixer(world, playerPos, 12, 2.0f, 1.0f - this.skyOpacity, isValidBiome);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float fogDensity(ClientWorld world, BlockPos playerPos, Predicate<Biome> isValidBiome) {
        return this.mixer(world, playerPos, 12, 0.1f, this.fogDensity, isValidBiome);
    }

    private float mixer(ClientWorld world, BlockPos playerPos, int transitionRange, float weight, float targetMaxValue, Predicate<Biome> validBiomes) {
        int x = playerPos.func_177958_n();
        int z = playerPos.func_177952_p();
        float accumulated = 0.0f;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int sampleX = x - transitionRange; sampleX <= x + transitionRange; ++sampleX) {
            pos.func_223471_o(sampleX);
            for (int sampleZ = z - transitionRange; sampleZ <= z + transitionRange; ++sampleZ) {
                pos.func_223472_q(sampleZ);
                Biome biome = world.func_226691_t_((BlockPos)pos);
                if (!validBiomes.test(biome)) continue;
                accumulated += weight * weight;
            }
        }
        float transitionSmoothness = 1089.0f;
        return Math.min(targetMaxValue, (float)Math.sqrt(accumulated / transitionSmoothness));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float cloudBlendStrength(ClientWorld world, BlockPos playerPos, Predicate<Biome> isValidBiome) {
        return this.mixer(world, playerPos, 15, 1.2f, (float)this.getColorSettings().getCloudColorBlendStrength(), isValidBiome);
    }

    public boolean weatherParticlesAndSound(ActiveRenderInfo renderInfo, Minecraft mc, float ticks, Predicate<Biome> validBiomes) {
        return true;
    }

    public void renderVanillaWeather(Minecraft mc, float partialTicks, double cameraX, double cameraY, double cameraZ, LightTexture lightmapIn, float[] rainSizeX, float[] rainSizeZ, ResourceLocation rainTexture, ResourceLocation snowTexture, int ticks, Predicate<Biome> isValidBiome) {
        float rainStrength = mc.field_71441_e.func_72867_j(partialTicks);
        if (!(rainStrength <= 0.0f)) {
            lightmapIn.func_205109_c();
            ClientWorld world = mc.field_71441_e;
            int x = MathHelper.func_76128_c((double)cameraX);
            int y = MathHelper.func_76128_c((double)cameraY);
            int z = MathHelper.func_76128_c((double)cameraZ);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            RenderSystem.enableAlphaTest();
            RenderSystem.disableCull();
            RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            int weatherRenderDistanceInBlocks = 5;
            if (Minecraft.func_71375_t()) {
                weatherRenderDistanceInBlocks = 10;
            }
            RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
            int i1 = -1;
            float ticksAndPartialTicks = (float)ticks + partialTicks;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.Mutable mutable = new BlockPos.Mutable();
            for (int dz = z - weatherRenderDistanceInBlocks; dz <= z + weatherRenderDistanceInBlocks; ++dz) {
                for (int dx = x - weatherRenderDistanceInBlocks; dx <= x + weatherRenderDistanceInBlocks; ++dx) {
                    int index = (dz - z + 16) * 32 + dx - x + 16;
                    double rainX = (double)rainSizeX[index] * 0.5;
                    double rainZ = (double)rainSizeZ[index] * 0.5;
                    mutable.func_181079_c(dx, y, dz);
                    Biome biome = world.func_226691_t_((BlockPos)mutable);
                    if (!isValidBiome.test(biome) || biome.func_201851_b() == Biome.RainType.NONE) continue;
                    int motionBlockingHeight = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, (BlockPos)mutable).func_177956_o();
                    int belowCameraYWeatherRenderDistance = y - weatherRenderDistanceInBlocks;
                    int aboveCameraYWeatherRenderDistance = y + weatherRenderDistanceInBlocks;
                    if (belowCameraYWeatherRenderDistance < motionBlockingHeight) {
                        belowCameraYWeatherRenderDistance = motionBlockingHeight;
                    }
                    if (aboveCameraYWeatherRenderDistance < motionBlockingHeight) {
                        aboveCameraYWeatherRenderDistance = motionBlockingHeight;
                    }
                    int atAboveHeightY = Math.max(motionBlockingHeight, y);
                    if (belowCameraYWeatherRenderDistance == aboveCameraYWeatherRenderDistance) continue;
                    Random random = new Random(dx * dx * 3121 + dx * 45238971 ^ dz * dz * 418711 + dz * 13761);
                    mutable.func_181079_c(dx, belowCameraYWeatherRenderDistance, dz);
                    float biomeTemperature = biome.func_225486_c((BlockPos)mutable);
                    i1 = biomeTemperature >= 0.15f ? this.renderRain(mc, partialTicks, cameraX, cameraY, cameraZ, rainTexture, ticks, rainStrength, (World)world, tessellator, bufferbuilder, weatherRenderDistanceInBlocks, i1, mutable, dz, dx, rainX, rainZ, belowCameraYWeatherRenderDistance, aboveCameraYWeatherRenderDistance, atAboveHeightY, random) : this.renderSnow(mc, partialTicks, cameraX, cameraY, cameraZ, snowTexture, ticks, rainStrength, (World)world, tessellator, bufferbuilder, weatherRenderDistanceInBlocks, i1, ticksAndPartialTicks, mutable, dz, dx, rainX, rainZ, belowCameraYWeatherRenderDistance, aboveCameraYWeatherRenderDistance, atAboveHeightY, random);
                }
            }
            if (i1 >= 0) {
                tessellator.func_78381_a();
            }
            RenderSystem.enableCull();
            RenderSystem.disableBlend();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.disableAlphaTest();
            lightmapIn.func_205108_b();
        }
    }

    private int renderSnow(Minecraft mc, float partialTicks, double x, double y, double z, ResourceLocation snowTexture, int ticks, float rainStrength, World world, Tessellator tessellator, BufferBuilder bufferbuilder, float graphicsQuality, int i1, float f1, BlockPos.Mutable mutable, int dz, int dx, double d0, double d1, int j2, int k2, int atOrAboveY, Random random) {
        if (i1 != 1) {
            if (i1 >= 0) {
                tessellator.func_78381_a();
            }
            i1 = 1;
            mc.func_110434_K().func_110577_a(snowTexture);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }
        float f6 = -((float)(ticks & 0x1FF) + partialTicks) / 512.0f;
        float f7 = (float)(random.nextDouble() + (double)f1 * 0.01 * (double)((float)random.nextGaussian()));
        float f8 = (float)(random.nextDouble() + (double)(f1 * (float)random.nextGaussian()) * 0.001);
        double d3 = (double)((float)dx + 0.5f) - x;
        double d5 = (double)((float)dz + 0.5f) - z;
        float f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / graphicsQuality;
        float alpha = ((1.0f - f9 * f9) * 0.3f + 0.5f) * rainStrength;
        mutable.func_181079_c(dx, atOrAboveY, dz);
        int combinedLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)mutable);
        int l3 = combinedLight >> 16 & 0xFFFF;
        int i4 = (combinedLight & 0xFFFF) * 3;
        int j4 = (l3 * 3 + 240) / 4;
        int k4 = (i4 * 3 + 240) / 4;
        bufferbuilder.func_225582_a_((double)dx - x - d0 + 0.5, (double)k2 - y, (double)dz - z - d1 + 0.5).func_225583_a_(0.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225587_b_(k4, j4).func_181675_d();
        bufferbuilder.func_225582_a_((double)dx - x + d0 + 0.5, (double)k2 - y, (double)dz - z + d1 + 0.5).func_225583_a_(1.0f + f7, (float)j2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225587_b_(k4, j4).func_181675_d();
        bufferbuilder.func_225582_a_((double)dx - x + d0 + 0.5, (double)j2 - y, (double)dz - z + d1 + 0.5).func_225583_a_(1.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225587_b_(k4, j4).func_181675_d();
        bufferbuilder.func_225582_a_((double)dx - x - d0 + 0.5, (double)j2 - y, (double)dz - z - d1 + 0.5).func_225583_a_(0.0f + f7, (float)k2 * 0.25f + f6 + f8).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225587_b_(k4, j4).func_181675_d();
        return i1;
    }

    private int renderRain(Minecraft mc, float partialTicks, double x, double y, double z, ResourceLocation rainTexture, int ticks, float rainStrength, World world, Tessellator tessellator, BufferBuilder bufferbuilder, float l, int i1, BlockPos.Mutable mutable, int dz, int dx, double d0, double d1, int j2, int k2, int atOrAboveY, Random random) {
        if (i1 != 0) {
            if (i1 >= 0) {
                tessellator.func_78381_a();
            }
            i1 = 0;
            mc.func_110434_K().func_110577_a(rainTexture);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        }
        int i3 = ticks + dx * dx * 3121 + dx * 45238971 + dz * dz * 418711 + dz * 13761 & 0x1F;
        float f3 = -((float)i3 + partialTicks) / 32.0f * (3.0f + random.nextFloat());
        double d2 = (double)((float)dx + 0.5f) - x;
        double d4 = (double)((float)dz + 0.5f) - z;
        float f4 = MathHelper.func_76133_a((double)(d2 * d2 + d4 * d4)) / l;
        float alpha = ((1.0f - f4 * f4) * 0.5f + 0.5f) * rainStrength;
        mutable.func_181079_c(dx, atOrAboveY, dz);
        int combinedLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)mutable);
        bufferbuilder.func_225582_a_((double)dx - x - d0 + 0.5, (double)k2 - y, (double)dz - z - d1 + 0.5).func_225583_a_(0.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_227886_a_(combinedLight).func_181675_d();
        bufferbuilder.func_225582_a_((double)dx - x + d0 + 0.5, (double)k2 - y, (double)dz - z + d1 + 0.5).func_225583_a_(1.0f, (float)j2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_227886_a_(combinedLight).func_181675_d();
        bufferbuilder.func_225582_a_((double)dx - x + d0 + 0.5, (double)j2 - y, (double)dz - z + d1 + 0.5).func_225583_a_(1.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_227886_a_(combinedLight).func_181675_d();
        bufferbuilder.func_225582_a_((double)dx - x - d0 + 0.5, (double)j2 - y, (double)dz - z - d1 + 0.5).func_225583_a_(0.0f, (float)k2 * 0.25f + f3).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_227886_a_(combinedLight).func_181675_d();
        return i1;
    }

    public ShaderProgram buildOrGetProgram(Consumer<ShaderProgramBuilder> consumer) {
        if (this.program == null) {
            ShaderProgramBuilder builder = ShaderProgramBuilder.create();
            try {
                consumer.accept(builder);
            }
            catch (Exception e) {
                BetterWeather.LOGGER.error((Object)e);
                builder.clean();
            }
            this.program = builder.build();
            return this.program;
        }
        return this.program;
    }
}

