/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.api.client.graphics.opengl.program;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.client.graphics.opengl.program.Program;
import corgitaco.betterweather.api.client.graphics.opengl.program.ShaderProgramBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.nio.FloatBuffer;
import java.util.function.Consumer;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public final class ShaderProgram
extends Program {
    private final Object2IntMap<String> uniforms = new Object2IntArrayMap();
    private final ShaderProgramBuilder builder;

    protected ShaderProgram(ShaderProgramBuilder builder) {
        this.builder = builder;
        try {
            builder.forEach(shader -> GL20.glAttachShader((int)this.program, (int)shader));
            GL20.glLinkProgram((int)this.program);
            this.logStatusError(35714, info -> {
                throw new RuntimeException((String)info);
            });
            builder.forEach(shader -> GL20.glDetachShader((int)this.program, (int)shader));
            GL20.glValidateProgram((int)this.program);
            this.logStatusError(35715, arg_0 -> ((Logger)BetterWeather.LOGGER).warn(arg_0));
        }
        catch (Exception e) {
            BetterWeather.LOGGER.error((Object)e);
            this.destroy();
        }
    }

    private void logStatusError(int status, Consumer<String> consumer) {
        if (GL20.glGetProgrami((int)this.program, (int)status) == 0) {
            consumer.accept(GL20.glGetProgramInfoLog((int)this.program));
        }
    }

    public int getOrMapUniform(String uniform) {
        return (Integer)this.uniforms.computeIfAbsent((Object)uniform, key -> GL20.glGetUniformLocation((int)this.program, (CharSequence)key));
    }

    public void uploadFloat(String uniform, float f) {
        GL20.glUniform1f((int)this.getOrMapUniform(uniform), (float)f);
    }

    public void uploadMatrix4f(String uniform, Matrix4f matrix4f) {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            FloatBuffer buffer = memoryStack.mallocFloat(16);
            matrix4f.func_195879_b(buffer);
            GL20.glUniformMatrix4fv((int)this.getOrMapUniform(uniform), (boolean)false, (FloatBuffer)buffer);
        }
    }

    @Override
    public void destroy() {
        this.builder.clean();
        super.destroy();
    }
}

